/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import com.tridium.nre.util.IElement;
import javax.baja.category.BCategoryMask;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;

public class SetCategoryMaskOp
extends SyncOp {
    String name;
    String mask;

    public SetCategoryMaskOp(BComponent c, BCategoryMask mask) {
        super(c);
        this.mask = mask.encodeToString();
    }

    public SetCategoryMaskOp(BComponent c, String mask) {
        super(c);
        this.mask = mask;
    }

    public SetCategoryMaskOp() {
    }

    @Override
    public int getId() {
        return 99;
    }

    public BCategoryMask getMask() {
        return BCategoryMask.make(this.mask);
    }

    @Override
    void commit(SyncBuffer parent, BComponentSpace space, Context context) throws Exception {
        this.component.setCategoryMask(BCategoryMask.make(this.mask), context);
    }

    @Override
    void encode(SyncEncoder out) throws Exception {
        super.encode(out);
        out.attr("c", this.mask).end().newLine();
    }

    @Override
    void decode(SyncBuffer buffer, BComponentSpace space, SyncDecoder in) throws Exception {
        super.decode(buffer, space, in);
        IElement elem = in.elem();
        this.mask = elem.get("c");
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("SetCatMask: ").append(this.componentToString()).append(" -> ").append(this.mask);
        return s.toString();
    }
}

