/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import com.tridium.nre.util.IElement;
import com.tridium.sys.engine.NKnob;
import com.tridium.sys.engine.NRelationKnob;
import com.tridium.sys.engine.ProxyKnob;
import com.tridium.sys.engine.ProxyRelationKnob;
import com.tridium.sys.schema.ComponentSlotMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.baja.io.ValueDocDecoder;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.ProxyBroker;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BSimple;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;

public class LoadOp
extends SyncOp {
    int depth;
    BComponent current;
    Map<BComponent, List<IElement>> knobs;
    Map<BComponent, List<IElement>> rknobs;
    boolean partialLoad = false;

    public LoadOp(BComponent c, int depth) {
        super(c);
        this.depth = depth;
    }

    public LoadOp() {
    }

    public LoadOp(BComponent c, int depth, boolean partialLoad) {
        this(c, depth);
        this.partialLoad = partialLoad;
    }

    @Override
    public int getId() {
        return 108;
    }

    public int getDepth() {
        return this.depth;
    }

    @Override
    void commit(SyncBuffer parent, BComponentSpace space, Context context) throws Exception {
        this.syncComponent(this.current, this.component, this.partialLoad);
        if (!this.partialLoad) {
            this.loadKnobs(space);
            this.loadRelationKnobs(space);
        }
    }

    void syncComponent(BComponent from, BComponent to, boolean partialLoad) throws Exception {
        if (from.getType() != to.getType()) {
            throw new IllegalStateException(from.getType() + " != " + to.getType());
        }
        if (to.getHandle() == null || !to.getHandle().equals(from.getHandle())) {
            throw new IllegalStateException("from.h != to.h -> " + from.getHandle() + " != " + to.getHandle());
        }
        ComponentSlotMap fromMap = (ComponentSlotMap)from.fw(1);
        ComponentSlotMap toMap = (ComponentSlotMap)to.fw(1);
        toMap.setCachedPermissions(fromMap.getCachedPermissions());
        toMap.setCategoryMask(fromMap.getCategoryMask(), Context.commit);
        boolean fromLoaded = fromMap.isBrokerPropsLoaded();
        if (!fromLoaded) {
            this.syncIcon(from, to);
            if (!partialLoad) {
                return;
            }
        }
        if (!partialLoad) {
            toMap.setBrokerPropsLoaded(true);
        }
        HashMap<String, Property> propsBefore = new HashMap<String, Property>();
        Property[] props = to.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            propsBefore.put(props[i].getName(), props[i]);
        }
        ArrayList<Property> orderedDynamicProps = new ArrayList<Property>();
        boolean orderChanged = false;
        int index = 0;
        SlotCursor<Slot> c = from.getSlots();
        while (c.next()) {
            String name = c.slot().getName();
            Slot fromSlot = c.slot();
            Slot toSlot = to.getSlot(name);
            int fromFlags = from.getFlags(fromSlot);
            BFacets fromFacets = from.getSlotFacets(fromSlot);
            if (toSlot == null) {
                Property fromProp = (Property)fromSlot;
                BValue fromValue = from.get(fromProp);
                BValue toValue = this.newCopy(fromValue);
                orderedDynamicProps.add(to.add(name, toValue, fromFlags, fromFacets, Context.commit));
                ++index;
                if (!fromValue.isComponent()) continue;
                this.syncComponent((BComponent)fromValue, (BComponent)toValue, false);
                continue;
            }
            propsBefore.remove(name);
            to.setFlags(toSlot, fromFlags, Context.commit);
            if (toSlot.isDynamic()) {
                to.setFacets(toSlot, fromFacets, Context.commit);
                orderedDynamicProps.add(toSlot.asProperty());
                if (!orderChanged && toMap.getDynamicPropertyByIndex(index++) != toSlot) {
                    orderChanged = true;
                }
            }
            if (!fromSlot.isProperty()) continue;
            this.syncValue(from, (Property)fromSlot, to, (Property)toSlot, false);
        }
        if (!propsBefore.isEmpty()) {
            for (String name : propsBefore.keySet()) {
                to.remove(name, Context.commit);
            }
        }
        if (orderChanged) {
            to.reorder(orderedDynamicProps.toArray(new Property[0]), Context.commit);
        }
    }

    void syncValue(BComplex from, Property fromProp, BComplex to, Property toProp, boolean partialLoad) throws Exception {
        BValue fromValue = from.get(fromProp);
        BValue toValue = to.get(toProp);
        if (fromValue.getClass() != toValue.getClass() || fromValue.isSimple() || toValue.isComponent() && (toValue.asComponent().getHandle() == null || toValue.asComponent().getComponentSpace() == null)) {
            if (fromValue.isComponent() && fromValue.asComponent().getHandle() == null) {
                if (fromValue.asComponent().getPropertyInParent().isDynamic()) {
                    throw new IllegalStateException("LoadOp - dynamic slot with no handle");
                }
                if (ProxyBroker.LOG.isLoggable(Level.WARNING)) {
                    ProxyBroker.LOG.warning("remote VM does not have frozen slot \"" + from.getType() + '.' + fromProp.getName() + '\"');
                }
                to.setFlags(toProp, to.getFlags(toProp) | 4, Context.commit);
                return;
            }
            toValue = this.newCopy(fromValue);
            to.set(toProp, toValue, Context.commit);
            if (fromValue.isComponent()) {
                this.syncComponent((BComponent)fromValue, (BComponent)toValue, partialLoad);
            }
            return;
        }
        if (fromValue.isComponent()) {
            BComponent fromComp = (BComponent)fromValue;
            BComponent toComp = (BComponent)toValue;
            if (toComp.getHandle() == null) {
                throw new IllegalStateException();
            }
            this.syncComponent(fromComp, toComp, partialLoad);
            return;
        }
        BStruct fromStruct = (BStruct)fromValue;
        BStruct toStruct = (BStruct)toValue;
        SlotCursor<Property> c = fromStruct.getProperties();
        while (c.next()) {
            Property toStructProp;
            Property fromStructProp = c.property();
            if (fromStructProp != (toStructProp = toStruct.getProperty(fromStructProp.getName()))) {
                throw new IllegalStateException("Structs should have same prop " + fromStructProp + " != " + toStructProp);
            }
            this.syncValue(fromStruct, fromStructProp, toStruct, toStructProp, partialLoad);
        }
    }

    BValue newCopy(BValue from) {
        if (from.isComponent()) {
            BComponent fromComp = (BComponent)from;
            BComponent to = (BComponent)fromComp.getType().getInstance();
            ((ComponentSlotMap)to.fw(1)).setHandle(fromComp.getHandle());
            return to;
        }
        return from.newCopy(true);
    }

    void loadKnobs(BComponentSpace space) throws Exception {
        for (BComponent from : this.knobs.keySet()) {
            if (!((ComponentSlotMap)from.fw(1)).isBrokerPropsLoaded()) continue;
            BComponent to = space.findByHandle(from.getHandle(), false);
            if (to == null) {
                throw new IllegalStateException("" + from.getHandle());
            }
            List<IElement> elems = this.knobs.get(from);
            ArrayList<NKnob> toMerge = new ArrayList<NKnob>(elems.size());
            for (int i = 0; i < elems.size(); ++i) {
                IElement elem = elems.get(i);
                ProxyKnob knob = SyncDecoder.decodeKnob(to, elem);
                if (knob == null) continue;
                toMerge.add(knob);
            }
            ((ComponentSlotMap)to.fw(1)).mergeKnobs(toMerge);
        }
    }

    void loadRelationKnobs(BComponentSpace space) throws Exception {
        for (BComponent from : this.rknobs.keySet()) {
            if (!((ComponentSlotMap)from.fw(1)).isBrokerPropsLoaded()) continue;
            BComponent to = space.findByHandle(from.getHandle(), false);
            if (to == null) {
                throw new IllegalStateException("" + from.getHandle());
            }
            List<IElement> elems = this.rknobs.get(from);
            ArrayList<NRelationKnob> toMerge = new ArrayList<NRelationKnob>(elems.size());
            for (int i = 0; i < elems.size(); ++i) {
                IElement elem = elems.get(i);
                ProxyRelationKnob knob = SyncDecoder.decodeRelationKnob(to, elem);
                if (knob == null) continue;
                toMerge.add(knob);
            }
            ((ComponentSlotMap)to.fw(1)).mergeRelationKnobs(toMerge);
        }
    }

    void syncIcon(BComponent from, BComponent to) {
        Property fromProp = from.getProperty("icon");
        if (fromProp == null) {
            return;
        }
        BValue val = from.get(fromProp);
        if (!(val instanceof BSimple)) {
            return;
        }
        Property toProp = to.getProperty("icon");
        if (toProp == null) {
            to.add("icon", val, Context.commit);
        } else {
            to.set(toProp, val, Context.commit);
        }
    }

    @Override
    void encode(SyncEncoder out) throws Exception {
        super.encode(out);
        if (this.partialLoad) {
            out.attr("partialLoad", true);
        }
        out.endAttr().newLine().key("b");
        out.encodeForLoad = true;
        boolean trans = out.setEncodeTransients(true);
        out.encode(null, this.component, this.depth);
        out.setEncodeTransients(trans);
        out.encodeForLoad = true;
        out.end(String.valueOf((char)this.getId())).newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void decode(SyncBuffer buffer, BComponentSpace space, SyncDecoder in) throws Exception {
        super.decode(buffer, space, in);
        IElement elem = in.elem();
        this.partialLoad = elem.get("partialLoad", "false").equals("true");
        in.knobs = null;
        in.rknobs = null;
        in.next();
        boolean wasSkippingLegacyEncodings = false;
        ValueDocDecoder.ITypeResolver typeResolver = in.getTypeResolver();
        try {
            wasSkippingLegacyEncodings = typeResolver.getSkipLegacyEncodings();
            typeResolver.setSkipLegacyEncodings(true);
            this.current = (BComponent)in.decode();
        }
        finally {
            typeResolver.setSkipLegacyEncodings(wasSkippingLegacyEncodings);
        }
        this.knobs = in.knobs;
        this.rknobs = in.rknobs;
        in.knobs = null;
        in.rknobs = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Load: " + this.componentToString());
        if (this.partialLoad) {
            sb.append(", partialLoad enabled");
        }
        return sb.toString();
    }
}

