/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import com.tridium.nre.util.IElement;
import com.tridium.sys.schema.ComplexSlotMap;
import com.tridium.sys.schema.ComponentSlotMap;
import javax.baja.security.BPermissions;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;

public class AddOp
extends SyncOp {
    String name;
    BValue value;
    int flags;
    BFacets facets;
    String newName;
    int depth;

    public AddOp(BComponent c, String name, BValue value, int flags, BFacets facets) {
        this(c, name, value, flags, facets, Integer.MAX_VALUE);
    }

    public AddOp(BComponent c, String name, BValue value, int flags, BFacets facets, int depth) {
        super(c);
        this.name = name;
        this.value = value;
        this.flags = flags;
        this.facets = facets;
        this.depth = depth;
    }

    public AddOp() {
    }

    @Override
    public int getId() {
        return 97;
    }

    public String getSlotName() {
        return this.name;
    }

    public BValue getValue() {
        return this.value;
    }

    public int getFlags() {
        return this.flags;
    }

    public BFacets getFacets() {
        return this.facets;
    }

    public String getNewSlotName() {
        return this.newName;
    }

    @Override
    void commit(SyncBuffer parent, BComponentSpace space, Context context) throws Exception {
        block3: {
            try {
                ComponentSlotMap slotMap = (ComponentSlotMap)this.component.fw(1);
                ComplexSlotMap valueSlotMap = (ComplexSlotMap)this.value.fw(1);
                Property prop = slotMap.add(this.name, this.flags, this.value, valueSlotMap, this.facets, context, parent.listener);
                if (prop != null) {
                    this.newName = prop.getName();
                }
            }
            catch (DuplicateSlotException e) {
                if (space.isProxyComponentSpace()) break block3;
                throw e;
            }
        }
    }

    @Override
    void encode(SyncEncoder out) throws Exception {
        BPermissions permissions;
        if (this.value.isComponent() && !(permissions = out.getPermissionsFor(this.value.asComponent())).hasOperatorRead()) {
            throw new SyncOp.SyncOpSecurityException("Missing op read permission on value");
        }
        super.encode(out);
        if (this.name != null) {
            out.attr("n", this.name);
        }
        if (this.flags != 0) {
            out.attr("f", Flags.encodeToString(this.flags));
        }
        if (this.facets != null && !this.facets.isNull()) {
            out.attr("facets", this.facets.encodeToString());
        }
        out.endAttr().newLine().key("b");
        out.encode(null, this.value, this.depth);
        out.end(String.valueOf((char)this.getId())).newLine();
    }

    @Override
    void decode(SyncBuffer buffer, BComponentSpace space, SyncDecoder in) throws Exception {
        super.decode(buffer, space, in);
        IElement elem = in.elem();
        this.name = elem.get("n", null);
        this.flags = Flags.decodeFromString(elem.get("f", "0"));
        this.facets = (BFacets)BFacets.DEFAULT.decodeFromString(elem.get("facets", ""));
        in.next();
        this.value = in.decode();
    }

    @Override
    public String toString() {
        return "Add: " + this.componentToString() + " -> " + this.name + " = " + this.value;
    }
}

