/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security.crypto;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.crypto.core.cert.NCertificateParameters;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.NX509CertificateEntry;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.baja.nre.security.IKeyPurpose;
import javax.baja.nre.security.IX509Certificate;
import javax.baja.nre.security.IX509CertificateEntry;

public final class X509CertificateFactory {
    private static final X509CertificateFactory instance = new X509CertificateFactory();

    public static X509CertificateFactory getInstance() {
        return instance;
    }

    private X509CertificateFactory() {
    }

    public IX509CertificateEntry generateSelfSignedCert(String alias, String subjectDn, String issuerDn, Date notBeforeDate, Date notAfterDate, int keySize, IKeyPurpose keyPurpose, String subAltName, String email) throws Exception {
        NCertificateParameters params = new NCertificateParameters(alias, subjectDn, issuerDn, notBeforeDate, notAfterDate, keySize, (KeyPurpose)keyPurpose, subAltName, email, null);
        return CertUtils.generateSelfSignedCert((NCertificateParameters)params);
    }

    public IX509CertificateEntry generateSelfSignedCert(KeyPair pair, String alias, String subjectDn, String issuerDn, Date notBeforeDate, Date notAfterDate, IKeyPurpose keyPurpose, String subAltName, String email) throws Exception {
        NCertificateParameters params = new NCertificateParameters(alias, subjectDn, issuerDn, notBeforeDate, notAfterDate, 0, (KeyPurpose)keyPurpose, subAltName, email, null);
        return CertUtils.generateSelfSignedCert((KeyPair)pair, (NCertificateParameters)params);
    }

    public IX509Certificate createCertificate(X509Certificate cert) {
        return NX509Certificate.make((X509Certificate)cert);
    }

    public IX509CertificateEntry createCertificateEntry(String alias, X509Certificate[] chain, PrivateKey key) {
        return NX509CertificateEntry.make((String)alias, (X509Certificate[])chain, (PrivateKey)key);
    }
}

