/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import com.tridium.session.NiagaraSuperSession;
import com.tridium.session.SessionManager;
import com.tridium.user.BUserPasswordConfiguration;
import java.security.AccessController;
import java.util.HashSet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;

@NiagaraType
public abstract class BAbstractAuthenticator
extends BComponent {
    @Generated
    public static final Type TYPE = Sys.loadType(BAbstractAuthenticator.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean canLogin() {
        return true;
    }

    public boolean canLogin(BUser user) {
        BUserPasswordConfiguration userConfig;
        BAbsTime expiration;
        return !(user.getAuthenticator() instanceof BPasswordAuthenticator) || (expiration = (userConfig = ((BPasswordAuthenticator)user.getAuthenticator()).getPasswordConfig()).getExpiration()).isNull() || !expiration.isBefore(BAbsTime.now());
    }

    @Override
    public void changed(Property property, Context context) {
        super.changed(property, context);
        BComplex parent = this.getParent();
        if (parent instanceof BUser && this.isRunning()) {
            this.invalidUserSessions((BUser)parent);
        }
    }

    protected void invalidUserSessions(BUser user) {
        HashSet<String> excludedIds = new HashSet<String>();
        NiagaraSuperSession currentSession = SessionManager.getCurrentNiagaraSuperSession();
        if (currentSession != null) {
            excludedIds.add(currentSession.getId());
        }
        AccessController.doPrivileged(() -> {
            SessionManager.invalidateSuperSessions(user, excludedIds);
            return null;
        });
    }

    @Override
    public final boolean isChildLegal(BComponent comp) {
        return false;
    }

    public boolean requiresCredentialsReset() {
        return false;
    }
}

