/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.query;

import com.tridium.sys.station.BStationScheme;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.BSlotScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BQueryScheme;
import javax.baja.space.BHandleScheme;
import javax.baja.sys.BInterface;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.util.BTypeSpec;
import javax.baja.util.CloseableIterator;

@NiagaraType
public interface BIQueryHandler
extends BInterface {
    @Generated
    public static final Type TYPE = Sys.loadType(BIQueryHandler.class);
    public static final Set<String> VALID_QUERY_ORD_SCHEMES = Collections.unmodifiableSet(Stream.of(BStationScheme.INSTANCE.getId(), BSlotScheme.INSTANCE.getId(), BHandleScheme.INSTANCE.getId(), "neql", "bql", "namespace", "sys", "nspace", "virtual", "single", "hierarchy").collect(Collectors.toSet()));
    public static final Set<BTypeSpec> TRUSTED_QUERY_HANDLERS = Collections.unmodifiableSet(Stream.of(BTypeSpec.make("fox:FoxQueryHandler"), BTypeSpec.make("neql:NeqlComponentQueryHandler"), BTypeSpec.make("orientSystemDb:OrientSystemDb")).collect(Collectors.toSet()));

    public boolean canHandle(OrdTarget var1, BQueryScheme var2);

    public CloseableIterator<Entity> query(OrdTarget var1, OrdQuery var2);

    public static void validateQueryOrds(BOrdList queryOrds) throws LocalizableException {
        Set invalidOrdSchemes = Collections.emptySet();
        for (BOrd queryOrd : queryOrds) {
            OrdQuery[] ordQueries;
            for (OrdQuery ordQuery : ordQueries = queryOrd.parse()) {
                String ordScheme = ordQuery.getScheme();
                if (VALID_QUERY_ORD_SCHEMES.contains(ordScheme)) continue;
                if (invalidOrdSchemes.isEmpty()) {
                    invalidOrdSchemes = new LinkedHashSet();
                }
                invalidOrdSchemes.add(ordScheme);
            }
        }
        if (!invalidOrdSchemes.isEmpty()) {
            String invalidOrdSchemesStr = String.join((CharSequence)", ", invalidOrdSchemes);
            throw new LocalizableException("baja", "query.invalidOrdSchemes", new Object[]{invalidOrdSchemesStr});
        }
    }
}

