/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.nav;

import javax.baja.naming.BOrdScheme;
import javax.baja.naming.BasicQuery;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;

@NiagaraType(ordScheme="nav")
@NiagaraSingleton
public class BNavScheme
extends BOrdScheme {
    @Generated
    public static final BNavScheme INSTANCE = new BNavScheme();
    @Generated
    public static final Type TYPE = Sys.loadType(BNavScheme.class);
    private static final LexiconModule LEX = LexiconModule.make("baja");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    private BNavScheme() {
        super("nav");
    }

    @Override
    public OrdQuery parse(String queryBody) {
        return new NavQuery(this.getId(), queryBody);
    }

    @Override
    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        String[] path;
        BObject baseObject = base.get();
        if (!(baseObject instanceof BINavNode)) {
            throw new SyntaxException(LEX.getText("navScheme.error.missingNavNodeBase", base));
        }
        BINavNode node = (BINavNode)((Object)baseObject);
        this.checkPermissions(node, base);
        String body = query.getBody();
        if (body.isEmpty()) {
            throw new SyntaxException(LEX.getText("navScheme.error.emptyBody", base));
        }
        if (body.startsWith("/")) {
            throw new SyntaxException(LEX.getText("navScheme.error.startingSlash", base));
        }
        for (String navName : path = TextUtil.split((String)query.getBody(), (char)'/')) {
            if (navName.isEmpty()) {
                throw new SyntaxException(LEX.getText("navScheme.error.missingNavNodeName", base));
            }
            if ((node = node.getNavChild(navName)) == null) {
                throw new UnresolvedException(LEX.getText("navScheme.error.navNodeMissing", base, navName));
            }
            this.checkPermissions(node, base);
        }
        return new OrdTarget(base, node.asObject());
    }

    private void checkPermissions(BINavNode node, Context cx) {
        BPermissions p;
        if (node instanceof BIProtected && !(p = ((BIProtected)((Object)node)).getPermissions(cx)).has(1)) {
            throw new PermissionException(LEX.getText("navScheme.error.noOperatorRead", cx));
        }
    }

    private static class NavQuery
    extends BasicQuery {
        public NavQuery(String scheme, String body) {
            super(scheme, body);
        }

        @Override
        public void normalize(OrdQueryList list, int index) {
            if (list.isSameScheme(index, index + 1)) {
                NavQuery append = (NavQuery)list.get(index + 1);
                list.merge(index, this.merge(append));
            }
        }

        public NavQuery merge(NavQuery a) {
            return new NavQuery(this.getScheme(), this.getBody() + "/" + a.getBody());
        }
    }
}

