/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.naming;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.SyntaxException;
import javax.baja.nre.util.TextUtil;

public class ViewQuery
implements OrdQuery {
    private static final String[] NO_NAMES = new String[0];
    private String scheme;
    private String body;
    private String viewId;
    private Map<String, String> parameters;

    public ViewQuery(String scheme, String body) throws SyntaxException {
        this.scheme = TextUtil.toLowerCase((String)scheme).trim();
        this.body = body.trim();
        this.parse();
    }

    public ViewQuery(String body) throws SyntaxException {
        this.scheme = "view";
        this.body = body.trim();
        this.parse();
    }

    public String getViewId() {
        return this.viewId;
    }

    public String[] getParameterNames() {
        if (this.parameters == null) {
            return NO_NAMES;
        }
        return this.parameters.keySet().toArray(new String[0]);
    }

    public String getParameter(String name) {
        String value = this.getParameter(name, null);
        if (value == null) {
            throw new IllegalArgumentException("Missing parameter \"" + name + "\"");
        }
        return value;
    }

    public String getParameter(String name, String defaultValue) {
        String value;
        if (this.parameters != null && (value = this.parameters.get(name)) != null) {
            return value;
        }
        return defaultValue;
    }

    public Map<String, String> getParameters() {
        return this.parameters == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public boolean isHost() {
        return false;
    }

    @Override
    public boolean isSession() {
        return false;
    }

    @Override
    public void normalize(OrdQueryList list, int index) {
        if (list.isSameScheme(index, index + 1)) {
            ViewQuery append = (ViewQuery)list.get(index + 1);
            list.merge(index, this.merge(append));
        } else if (index < list.size() - 1) {
            list.remove(index);
        }
    }

    public ViewQuery merge(ViewQuery a) {
        String mergeViewId = null;
        if (this.viewId != null && a.viewId == null) {
            mergeViewId = this.viewId;
        }
        if (a.viewId != null) {
            mergeViewId = a.viewId;
        }
        HashMap<String, String> mergeParams = null;
        if (this.parameters != null || a.parameters != null) {
            HashMap<String, String> hashMap = mergeParams = this.parameters != null ? this.parameters : new HashMap<String, String>();
            if (a.parameters != null) {
                for (String name : a.getParameterNames()) {
                    mergeParams.put(name, a.getParameter(name));
                }
            }
        }
        StringBuilder s = new StringBuilder();
        if (mergeViewId != null) {
            s.append(mergeViewId);
        }
        if (mergeParams != null) {
            s.append('?');
            for (String name : mergeParams.keySet()) {
                s.append(name).append('=').append((String)mergeParams.get(name)).append(';');
            }
        }
        return new ViewQuery(this.scheme, s.toString());
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public String toString() {
        return this.scheme + ':' + this.body;
    }

    void parse() {
        try {
            String body = this.body;
            int len = body.length();
            if (len == 0) {
                throw new SyntaxException("no body");
            }
            int question = body.indexOf(63);
            if (question < 0) {
                this.viewId = body;
            } else {
                this.viewId = body.substring(0, question).trim();
                this.parseParams(question);
            }
            int viewLen = this.viewId.length();
            if (viewLen == 0) {
                this.viewId = null;
            } else {
                for (int i = 0; i < viewLen; ++i) {
                    char c = this.viewId.charAt(i);
                    if (c != '|' && c != ';' && c != '=') continue;
                    throw new SyntaxException("invalid view id char '" + (char)c + "'");
                }
            }
        }
        catch (SyntaxException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SyntaxException(e);
        }
    }

    private void parseParams(int question) {
        String body = this.body;
        int len = body.length();
        int lastEqual = -1;
        int lastSemicolon = question;
        for (int i = question + 1; i < len; ++i) {
            char c = body.charAt(i);
            if (c == ';') {
                this.addParam(lastSemicolon, lastEqual, i);
                lastEqual = -1;
                lastSemicolon = i;
                continue;
            }
            if (c == '=') {
                lastEqual = i;
                continue;
            }
            if (c != '%' && c != '|' && c != '?') continue;
            throw new SyntaxException("invalid param char '" + (char)c + "'");
        }
        if (lastSemicolon < len - 1) {
            this.addParam(lastSemicolon, lastEqual, len);
        }
    }

    private void addParam(int lastSemicolon, int lastEqual, int i) {
        if (lastEqual < 0) {
            throw new SyntaxException("invalid param, missing =");
        }
        String name = this.body.substring(lastSemicolon + 1, lastEqual).trim();
        String value = this.body.substring(lastEqual + 1, i).trim();
        if (name.isEmpty()) {
            throw new SyntaxException("missing name");
        }
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(name, value);
    }
}

