/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.naming;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.Path;
import javax.baja.naming.ViewQuery;

public final class OrdUtil {
    private OrdUtil() {
    }

    public static BOrd replaceBackups(BOrd ord) {
        OrdQuery[] queries = ord.parse();
        ArrayList<OrdQuery> newQueries = null;
        for (int i = 0; i < queries.length; ++i) {
            int backupDepth;
            int n = backupDepth = queries[i] instanceof Path ? ((Path)((Object)queries[i])).getBackupDepth() : 0;
            if (backupDepth > 1) {
                if (newQueries == null) {
                    newQueries = new ArrayList<OrdQuery>(queries.length + backupDepth - 1);
                    newQueries.addAll(Arrays.asList(queries).subList(0, i));
                }
                Path path = (Path)((Object)queries[i]);
                for (int j = 0; j < backupDepth - 1; ++j) {
                    newQueries.add(path.makePath(".."));
                }
                String newBody = queries[i].getBody().replace("/..", "");
                newQueries.add(path.makePath(newBody));
                continue;
            }
            if (newQueries == null) continue;
            newQueries.add(queries[i]);
        }
        if (newQueries != null) {
            ord = BOrd.make(newQueries.toArray(new OrdQuery[0]));
        }
        return ord;
    }

    public static ViewQuery getViewQuery(BOrd ord) {
        if (ord.isNull()) {
            return null;
        }
        return OrdUtil.getViewQuery(OrdUtil.getNormalizedParse(ord));
    }

    public static BOrd getOrdWithoutViewQuery(BOrd ord) {
        if (ord.isNull()) {
            return BOrd.NULL;
        }
        return OrdUtil.getOrdWithoutViewQuery(OrdUtil.getNormalizedParse(ord));
    }

    public static BOrd getOrdWithoutViewQueryParameters(OrdTarget target, List<String> keysToRemove, boolean removeViewId) {
        return OrdUtil.getOrdWithoutViewQueryParameters(target.getOrdWithoutViewQuery(), target.getViewQuery(), keysToRemove, removeViewId);
    }

    public static BOrd getOrdWithoutViewQueryParameters(BOrd ord, List<String> keysToRemove, boolean removeViewId) {
        if (ord.isNull()) {
            return BOrd.NULL;
        }
        OrdQuery[] queries = OrdUtil.getNormalizedParse(ord);
        return OrdUtil.getOrdWithoutViewQueryParameters(OrdUtil.getOrdWithoutViewQuery(queries), OrdUtil.getViewQuery(queries), keysToRemove, removeViewId);
    }

    private static BOrd getOrdWithoutViewQueryParameters(BOrd ordWithoutViewQuery, ViewQuery viewQuery, List<String> keysToRemove, boolean removeViewId) {
        String body;
        if (viewQuery == null) {
            return ordWithoutViewQuery;
        }
        StringBuilder b = new StringBuilder();
        viewQuery.getParameters().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(entry -> {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (keysToRemove.contains(key)) {
                return;
            }
            if (b.length() == 0) {
                b.append('?');
            } else {
                b.append(';');
            }
            b.append(key).append('=').append(value);
        });
        String viewId = viewQuery.getViewId();
        if (viewId == null || removeViewId) {
            viewId = "";
        }
        if ((body = viewId + b.toString()).isEmpty()) {
            return ordWithoutViewQuery;
        }
        ViewQuery newViewQuery = new ViewQuery(body);
        return BOrd.make(ordWithoutViewQuery, newViewQuery);
    }

    private static OrdQuery[] getNormalizedParse(BOrd ord) {
        return ord.normalize().parse();
    }

    private static ViewQuery getViewQuery(OrdQuery[] queries) {
        int n = queries.length - 1;
        if (n >= 0 && queries[n] instanceof ViewQuery) {
            return (ViewQuery)queries[n];
        }
        return null;
    }

    private static BOrd getOrdWithoutViewQuery(OrdQuery[] queries) {
        if (OrdUtil.getViewQuery(queries) == null) {
            return BOrd.make(queries);
        }
        return BOrd.make(queries, 0, queries.length - 1);
    }
}

