/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.naming;

import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(ordScheme="ip")
@NiagaraSingleton
public class BIpScheme
extends BOrdScheme {
    @Generated
    public static final BIpScheme INSTANCE = new BIpScheme();
    @Generated
    public static final Type TYPE = Sys.loadType(BIpScheme.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    private BIpScheme() {
        super("ip");
    }

    @Override
    public OrdQuery parse(String queryBody) {
        return new IpQuery(queryBody);
    }

    @Override
    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        String hostname = query.getBody();
        BHost host = BHost.getHost(hostname);
        if (host == null) {
            host = new BIpHost(hostname);
            BHost.mount(host);
        }
        return new OrdTarget(base, host);
    }

    static class IpQuery
    implements OrdQuery {
        final String hostname;

        IpQuery(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public boolean isHost() {
            return true;
        }

        @Override
        public boolean isSession() {
            return false;
        }

        @Override
        public void normalize(OrdQueryList list, int index) {
            list.trim(index);
        }

        @Override
        public String getScheme() {
            return "ip";
        }

        @Override
        public String getBody() {
            return this.hostname;
        }

        @Override
        public String toString() {
            return "ip:" + this.hostname;
        }
    }
}

