/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file.zip;

import javax.baja.file.zip.BZipFile;
import javax.baja.file.zip.BZipSpace;
import javax.baja.file.zip.ZipPath;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.InvalidOrdBaseException;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(ordScheme="zip")
@NiagaraSingleton
public class BZipScheme
extends BOrdScheme {
    @Generated
    public static final BZipScheme INSTANCE = new BZipScheme();
    @Generated
    public static final Type TYPE = Sys.loadType(BZipScheme.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    private BZipScheme() {
        super("zip");
    }

    @Override
    public OrdQuery parse(String queryBody) {
        return new ZipPath(this.getId(), queryBody);
    }

    @Override
    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        ZipPath path = (ZipPath)query;
        String body = path.getBody();
        if (base.get() instanceof BZipFile) {
            BZipFile zip = (BZipFile)base.get();
            BZipSpace fs = (BZipSpace)zip.open();
            if (body.isEmpty() || body.equals("/")) {
                return new OrdTarget(base, fs);
            }
            return new OrdTarget(base, (BObject)((Object)fs.resolveFile(path)));
        }
        if (base.get() instanceof BZipSpace) {
            BZipSpace fs = (BZipSpace)base.get();
            if (body.isEmpty() || body.equals("/")) {
                return new OrdTarget(base, fs);
            }
            return new OrdTarget(base, (BObject)((Object)fs.resolveFile(path)));
        }
        throw new InvalidOrdBaseException(base.get().getType().toString());
    }
}

