/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file;

import com.tridium.sys.Nre;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.FileAlreadyExistsException;
import java.security.AccessController;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileSpace;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.FileUtil;
import javax.baja.security.PermissionException;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.util.LexiconModule;

public class BajaFileUtil
extends FileUtil {
    private static final BajaFileWriter DEFAULT_FILE_WRITER = new BajaFileWriter(){

        @Override
        public void createFile(BOrd fileOrd, InputStream fileContents, Context cx) throws IOException {
            try (OutputStream out = BajaFileUtil.createFile(fileOrd, cx).getOutputStream();){
                FileUtil.pipe((InputStream)fileContents, (OutputStream)out);
            }
        }

        @Override
        public void replaceFile(BOrd fileOrd, InputStream fileContents, Context cx) throws IOException {
            try (OutputStream out = BajaFileUtil.createFileToOverwrite(fileOrd, cx).getOutputStream();){
                FileUtil.pipe((InputStream)fileContents, (OutputStream)out);
            }
        }

        @Override
        public boolean exists(BOrd fileOrd, Context cx) {
            return new SpaceAndPath(fileOrd, cx).exists();
        }

        @Override
        public boolean isWritable(BOrd fileOrd, Context cx) {
            return new SpaceAndPath(fileOrd, cx).isWritable(cx);
        }
    };
    static Logger log = Logger.getLogger("sys.file");
    private static final LexiconModule LEX = LexiconModule.make("baja");
    private static final String TMP_DIR = AccessController.doPrivileged(() -> System.getProperty("java.io.tmpdir"));
    private static final File TEMP_FILES_DIRECTORY = new File(TMP_DIR);

    public static byte[] read(BIFileStore f) throws IOException {
        return BajaFileUtil.read((InputStream)f.getInputStream(), (long)f.getSize());
    }

    public static void write(BIFileStore f, byte[] contents) throws IOException {
        try (OutputStream out = f.getOutputStream();){
            out.write(contents);
        }
    }

    public static void pipe(BIFile src, BIFile dest) throws IOException {
        try (InputStream in = src.getInputStream();
             OutputStream out = dest.getOutputStream();){
            long size = src.getSize();
            if (size >= 0L) {
                BajaFileUtil.pipe((InputStream)in, (long)size, (OutputStream)out);
            } else {
                BajaFileUtil.pipe((InputStream)in, (OutputStream)out);
            }
        }
    }

    public static BajaFileWriter getDefaultFileWriter() {
        return DEFAULT_FILE_WRITER;
    }

    public static BIFile createFileToOverwrite(BOrd fileOrd, Context cx) throws IOException {
        return BajaFileUtil.createFileToOverwrite(fileOrd, null, null, cx);
    }

    public static BIFile createFileToOverwrite(BOrd fileOrd, String ext, BObject base, Context cx) throws IOException {
        return BajaFileUtil.createFile(fileOrd, ext, true, base, cx);
    }

    public static BIFile createFile(BOrd fileOrd, Context cx) throws IOException {
        return BajaFileUtil.createFile(fileOrd, null, null, cx);
    }

    public static BIFile createFile(BOrd fileOrd, String ext, BObject base, Context cx) throws IOException {
        return BajaFileUtil.createFile(fileOrd, ext, false, base, cx);
    }

    private static BIFile createFile(BOrd desiredOrd, String ext, boolean overwrite, BObject base, Context cx) throws IOException {
        String ordStr = String.valueOf(desiredOrd);
        if ("null".equals(ordStr) || ordStr.isEmpty()) {
            throw new IllegalArgumentException("Filename required");
        }
        if (ext != null && !ordStr.endsWith(ext)) {
            ordStr = ordStr + "." + ext;
        }
        BOrd ord = BOrd.make(ordStr);
        try {
            BObject obj = ord.get(base, cx);
            if (!overwrite) {
                throw new FileAlreadyExistsException(ordStr + " already exists");
            }
            return (BIFile)((Object)obj);
        }
        catch (UnresolvedException e) {
            return new SpaceAndPath(ord, cx).makeFile();
        }
        catch (SyntaxException e) {
            throw new IllegalArgumentException("Illegal filename: \"" + ordStr + "\"");
        }
    }

    public static File createTempFile(String ext) throws IOException {
        TEMP_FILES_DIRECTORY.mkdirs();
        File file = File.createTempFile("temp", "." + ext, TEMP_FILES_DIRECTORY);
        file.deleteOnExit();
        return file;
    }

    public static String readString(BIFile file) throws IOException {
        return BajaFileUtil.readString((Reader)new InputStreamReader(file.getInputStream()));
    }

    public static String[] readLines(BIFile file) throws IOException {
        return BajaFileUtil.readLines((Reader)new InputStreamReader(file.getInputStream()));
    }

    public static boolean isSpecialModule(String name) {
        return AccessController.doPrivileged(() -> {
            File binDir = new File(Nre.getNiagaraHome(), "bin");
            File binExtDir = new File(binDir, "ext");
            File file = BajaFileUtil.find((File)binExtDir, (String)(name + ".jar"));
            return file != null && file.exists();
        });
    }

    private static class SpaceAndPath {
        BIFileSpace space;
        FilePath path;

        private SpaceAndPath(BOrd fileOrd, Context cx) {
            OrdQuery[] q = fileOrd.normalize().parse();
            if (q.length == 0) {
                throw new IllegalArgumentException(LEX.getText("NotAFileOrd", cx, fileOrd));
            }
            OrdQuery last = q[q.length - 1];
            if (!(last instanceof FilePath)) {
                throw new IllegalArgumentException(LEX.getText("NotAFileOrd", cx, fileOrd));
            }
            this.path = (FilePath)last;
            q[q.length - 1] = new FilePath("");
            this.space = (BIFileSpace)((Object)BOrd.make(q).resolve().get());
        }

        private boolean exists() {
            return this.space.findFile(this.path) != null;
        }

        private boolean isWritable(Context cx) {
            try {
                this.space.checkWritePermission(this.path, cx);
                return true;
            }
            catch (PermissionException e) {
                return false;
            }
        }

        private BIFile makeFile() throws IOException {
            return this.space.makeFile(this.path);
        }
    }

    public static interface BajaFileWriter {
        public void createFile(BOrd var1, InputStream var2, Context var3) throws IOException;

        public void replaceFile(BOrd var1, InputStream var2, Context var3) throws IOException;

        public boolean exists(BOrd var1, Context var2);

        public boolean isWritable(BOrd var1, Context var2);
    }
}

