/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class FilteredIterator<T>
implements Iterator<T> {
    private Predicate<T> filter;
    private Iterator<T> inner;
    private T current;

    public FilteredIterator(Predicate<T> filter, Iterator<T> inner) {
        this.filter = filter;
        this.inner = inner;
    }

    @Override
    public boolean hasNext() {
        if (this.current != null) {
            return true;
        }
        while (this.inner.hasNext()) {
            this.current = this.nextImpl();
            if (this.current == null || !this.filter.test(this.current)) continue;
            return true;
        }
        this.current = null;
        return false;
    }

    @Override
    public T next() {
        T result = this.nextImpl();
        if (result != null) {
            return result;
        }
        throw new NoSuchElementException();
    }

    private T nextImpl() {
        if (this.current == null) {
            while (this.inner.hasNext()) {
                T result = this.inner.next();
                if (!this.filter.test(result)) continue;
                return result;
            }
            return null;
        }
        T result = this.current;
        this.current = null;
        return result;
    }
}

