/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import com.tridium.nre.util.ArrayIterator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class StringTable
extends Dictionary<String, Object> {
    static final String[] EMPTY = new String[0];
    String[] keys = EMPTY;
    Object[] values = EMPTY;
    int count = 0;

    public StringTable() {
    }

    public StringTable(int capacity) {
        this.keys = new String[capacity];
        this.values = new Object[capacity];
    }

    public StringTable(String[] keys, Object[] values) {
        this.init(keys, values);
    }

    public synchronized void init(String[] keys, Object[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException();
        }
        int n = this.count = keys.length;
        this.keys = new String[n];
        String[] k = this.keys;
        this.values = new Object[n];
        Object[] v = this.values;
        System.arraycopy(keys, 0, this.keys, 0, n);
        System.arraycopy(values, 0, this.values, 0, n);
        for (int incr = n / 2; incr >= 1; incr /= 2) {
            for (int i = incr; i < n; ++i) {
                String tempKey = k[i];
                Object tempValue = v[i];
                for (int j = i; j >= incr && tempKey.compareTo(k[j - incr]) < 0; j -= incr) {
                    k[j] = k[j - incr];
                    v[j] = v[j - incr];
                }
                k[j] = tempKey;
                v[j] = tempValue;
            }
        }
    }

    public synchronized Object get(String key) {
        String[] k = this.keys;
        int lo = -1;
        int hi = this.count;
        while (hi - lo > 1) {
            int i = (hi + lo) / 2;
            int cmp = key.compareTo(k[i]);
            if (cmp < 0) {
                hi = i;
                continue;
            }
            if (cmp > 0) {
                lo = i;
                continue;
            }
            return this.values[i];
        }
        return null;
    }

    @Override
    public synchronized Object put(String key, Object value) {
        if (this.keys.length >= this.count) {
            this.ensureCapacity(Math.max(8, this.count * 2));
        }
        String[] k = this.keys;
        if (this.count == 0) {
            k[0] = key;
            this.values[0] = value;
            ++this.count;
            return null;
        }
        if (this.count == 1) {
            int c = key.compareTo(k[0]);
            if (c == 0) {
                Object old = this.values[0];
                this.values[0] = value;
                return old;
            }
            if (c < 0) {
                k[1] = k[0];
                this.values[1] = this.values[0];
                k[0] = key;
                this.values[0] = value;
                ++this.count;
            } else {
                k[1] = key;
                this.values[1] = value;
                ++this.count;
            }
            return null;
        }
        int first = 0;
        int last = this.count - 1;
        int i = (last - first) / 2;
        while (first <= last) {
            int c = key.compareTo(k[i]);
            if (c == 0) {
                Object old = this.values[i];
                this.values[i] = value;
                return old;
            }
            if (c < 0) {
                c = key.compareTo(k[first]);
                if (c == 0) {
                    Object old = this.values[first];
                    this.values[first] = value;
                    return old;
                }
                if (c < 0) {
                    i = first;
                    break;
                }
                last = i - 1;
            } else {
                c = key.compareTo(k[last]);
                if (c == 0) {
                    Object old = this.values[last];
                    this.values[last] = value;
                    return old;
                }
                if (c > 0) {
                    i = last + 1;
                    break;
                }
                first = i + 1;
            }
            i = first + (last - first) / 2;
        }
        System.arraycopy(k, i, k, i + 1, this.count - i);
        k[i] = key;
        System.arraycopy(this.values, i, this.values, i + 1, this.count - i);
        this.values[i] = value;
        ++this.count;
        return null;
    }

    public synchronized Object remove(String key) {
        String[] k = this.keys;
        int lo = -1;
        int hi = this.count;
        while (hi - lo > 1) {
            int i = (hi + lo) / 2;
            int cmp = key.compareTo(k[i]);
            if (cmp < 0) {
                hi = i;
                continue;
            }
            if (cmp > 0) {
                lo = i;
                continue;
            }
            Object old = this.values[i];
            System.arraycopy(this.keys, i + 1, this.keys, i, this.count - i - 1);
            System.arraycopy(this.values, i + 1, this.values, i, this.count - i - 1);
            this.keys[this.count - 1] = null;
            this.values[this.count - 1] = null;
            --this.count;
            return old;
        }
        return null;
    }

    public synchronized String[] keyArray() {
        String[] copy = new String[this.count];
        System.arraycopy(this.keys, 0, copy, 0, this.count);
        return copy;
    }

    public synchronized Object[] elementArray() {
        Object[] copy = new Object[this.count];
        System.arraycopy(this.values, 0, copy, 0, this.count);
        return copy;
    }

    public synchronized Object[] elementArray(Object[] result) {
        System.arraycopy(this.values, 0, result, 0, this.count);
        return result;
    }

    public synchronized void copyElementsInto(Object[] array, int startIndex) {
        System.arraycopy(this.values, 0, array, startIndex, this.count);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public synchronized int size() {
        return this.count;
    }

    public synchronized void ensureCapacity(int capacity) {
        if (this.keys.length < capacity) {
            String[] tempKeys = new String[capacity];
            Object[] tempValues = new Object[capacity];
            System.arraycopy(this.keys, 0, tempKeys, 0, this.count);
            System.arraycopy(this.values, 0, tempValues, 0, this.count);
            this.keys = tempKeys;
            this.values = tempValues;
        }
    }

    public synchronized void clear() {
        this.keys = EMPTY;
        this.values = EMPTY;
        this.count = 0;
    }

    public Iterator<String> keyIterator() {
        return new ArrayIterator((Object[])this.keys, 0, this.size());
    }

    public Iterator<Object> valueIterator() {
        return new ArrayIterator(this.values, 0, this.size());
    }

    @Override
    public Enumeration<String> keys() {
        return new EnumeratorKeys();
    }

    @Override
    public Enumeration<Object> elements() {
        return new EnumeratorValues();
    }

    @Override
    public Object get(Object key) {
        return this.get((String)key);
    }

    @Override
    public Object remove(Object key) {
        return this.remove((String)key);
    }

    public synchronized void dump() {
        Enumeration<String> e = this.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            System.out.println("  " + key + " = " + this.get(key));
        }
    }

    public static void main(String[] args) {
        StringTable st = new StringTable();
        st.put("value", (Object)"200");
        st.put("hee", (Object)"2000");
        ArrayIterator i = (ArrayIterator)st.keyIterator();
        System.out.println("Size --> " + st.size());
        while (i.hasNext()) {
            System.out.println("\t Next element -> " + (String)i.next());
        }
        System.out.println("---------");
        while (i.hasPrevious()) {
            System.out.println("\t Next element -> " + (String)i.previous());
        }
        while (i.hasNext()) {
            System.out.println("\t Next element -> " + (String)i.next());
        }
    }

    class EnumeratorValues
    implements Enumeration<Object> {
        private int index = 0;

        @Override
        public boolean hasMoreElements() {
            return this.index < StringTable.this.count;
        }

        @Override
        public Object nextElement() {
            if (this.index >= StringTable.this.count) {
                throw new NoSuchElementException("StringTable");
            }
            return StringTable.this.values[this.index++];
        }
    }

    class EnumeratorKeys
    implements Enumeration<String> {
        private int index = 0;

        @Override
        public boolean hasMoreElements() {
            return this.index < StringTable.this.count;
        }

        @Override
        public String nextElement() {
            if (this.index >= StringTable.this.count) {
                throw new NoSuchElementException("StringTable");
            }
            return StringTable.this.keys[this.index++];
        }
    }
}

