/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.baja.naming.SlotPath;
import javax.baja.security.BAbstractAes256PasswordEncoder;
import javax.baja.security.BAbstractPasswordEncoder;
import javax.baja.security.BAliasedAes256PasswordEncoder;
import javax.baja.security.BIDeferOwnership;
import javax.baja.security.BPassword;
import javax.baja.security.BReversiblePasswordEncoder;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;

public class PasswordUtil {
    public static final BPassword SUBSTITUTE_PASSWORD = BPassword.make("\u0000", "plain.1");
    public static final String SKIP_ENCODING_SENSITIVE_KEY = "skipEncodingSensitive";
    private static final ThreadLocal<Boolean> allowSubstitutePasswordPersistence = new ThreadLocal();
    private static volatile boolean checkForSubstitutePasswords;
    static final Logger log;

    public static List<SlotPath> forceClearReversiblePasswords(BComponent root) {
        ReplaceWithDefaultPasswordPropertyUpdate function = new ReplaceWithDefaultPasswordPropertyUpdate();
        PasswordUtil.updatePasswords(root, function);
        Optional<RuntimeException> exception = function.exceptions().findFirst();
        if (exception.isPresent()) {
            throw exception.get();
        }
        return function.updatedSlots();
    }

    public static void updatePasswords(BComponent root, PasswordPropertyUpdate updater) {
        PasswordUtil.updatePasswords(root, root.getSlotPath(), updater);
    }

    public static void updatePasswords(BComplex c, SlotPath cPath, PasswordPropertyUpdate updater) {
        for (Property p : c.getProperties()) {
            if (p.getType().is(BComplex.TYPE)) {
                PasswordUtil.updatePasswords((BComplex)c.get(p), cPath.merge(new SlotPath(p.getName())), updater);
                continue;
            }
            if (p.getType().is(BPassword.TYPE)) {
                c.set(p, (BValue)updater.apply((BPassword)c.get(p), cPath.merge(new SlotPath(p.getName()))));
                continue;
            }
            if (!BComplex.TYPE.is(p.getType()) && !BPassword.TYPE.is(p.getType())) continue;
            BValue propertyValue = c.get(p);
            if (propertyValue instanceof BComplex) {
                PasswordUtil.updatePasswords((BComplex)propertyValue, cPath.merge(new SlotPath(p.getName())), updater);
                continue;
            }
            if (!(propertyValue instanceof BPassword)) continue;
            c.set(p, (BValue)updater.apply((BPassword)propertyValue, cPath.merge(new SlotPath(p.getName()))));
        }
    }

    public static void setAllowSubstitutePasswordValuesOnThread(boolean allow) {
        if (Sys.isStation()) {
            checkForSubstitutePasswords = true;
            if (allow) {
                allowSubstitutePasswordPersistence.set(Boolean.TRUE);
            } else {
                allowSubstitutePasswordPersistence.remove();
            }
        }
    }

    public static boolean isSubstitutePasswordValueAllowedOnThread() {
        return !Sys.isStation() || checkForSubstitutePasswords && allowSubstitutePasswordPersistence.get() == Boolean.TRUE;
    }

    public static BPassword toAcceptableForm(BPassword password, BPassword defaultPassword) {
        if (!PasswordUtil.isSubstitutePasswordValueAllowedOnThread() && SUBSTITUTE_PASSWORD.validate(password)) {
            return defaultPassword;
        }
        return password;
    }

    public static BPassword assignPasswordOwner(BPassword password, BComplex owner, Property property) {
        while (owner instanceof BIDeferOwnership) {
            property = owner.getPropertyInParent();
            owner = owner.getParent();
        }
        BAbstractPasswordEncoder encoder = password.getPasswordEncoder();
        if (owner != null && encoder instanceof BAbstractAes256PasswordEncoder) {
            String newAlternateOwner;
            String oldAlias = ((BAbstractAes256PasswordEncoder)encoder).getKeyAlias();
            String oldAlternateOwner = encoder instanceof BAliasedAes256PasswordEncoder ? ((BAliasedAes256PasswordEncoder)encoder).getAlternateOwner() : null;
            String newAlias = owner.getType().getModule().getModuleName();
            String newDeclaringModule = property == null ? null : property.getDeclaringType().getModule().getModuleName();
            String string = newAlternateOwner = newDeclaringModule == newAlias ? null : newDeclaringModule;
            if (!oldAlias.equals(newAlias) || !Objects.equals(oldAlternateOwner, newAlternateOwner)) {
                if (!oldAlias.equals(newAlias) && !oldAlias.equals("javax.baja.security.BAes256PasswordEncoder.key")) {
                    throw new SecurityException("Cannot set password that is owned by another module.");
                }
                try {
                    BAliasedAes256PasswordEncoder newEncoder = new BAliasedAes256PasswordEncoder(newAlias);
                    newEncoder.encode(encoder.getSecretChars());
                    newEncoder.setAlternateOwner(newAlternateOwner);
                    password = BPassword.make(newEncoder);
                }
                catch (Exception e) {
                    log.warning("Failed to own password: " + e.getMessage());
                    return password;
                }
            }
        }
        return password;
    }

    public static void assignChildPasswordOwner(BIDeferOwnership defer, BComplex owner) {
        Property alternateOwnerProperty = ((BComplex)((Object)defer)).getPropertyInParent();
        while (owner instanceof BIDeferOwnership) {
            alternateOwnerProperty = owner.getPropertyInParent();
            owner = owner.getParent();
        }
        if (owner != null && defer instanceof BComplex) {
            for (Property property : ((BComplex)((Object)defer)).getProperties()) {
                BValue value = ((BComplex)((Object)defer)).get(property);
                if (value instanceof BPassword) {
                    ((BComplex)((Object)defer)).set(property, (BValue)PasswordUtil.assignPasswordOwner((BPassword)value, owner, alternateOwnerProperty));
                    continue;
                }
                if (!(value instanceof BIDeferOwnership)) continue;
                PasswordUtil.assignChildPasswordOwner((BIDeferOwnership)((Object)value), owner);
            }
        }
    }

    static {
        log = Logger.getLogger("baja");
    }

    public static class ReplaceWithDefaultPasswordPropertyUpdate
    implements PasswordPropertyUpdate {
        @Override
        public BPassword apply(BPassword password, SlotPath slotPath) {
            try {
                if (password.getPasswordEncoder() instanceof BReversiblePasswordEncoder) {
                    this.slotUpdated(slotPath);
                    return BPassword.DEFAULT;
                }
                return password;
            }
            catch (RuntimeException e) {
                exceptions.add(e);
                return this.exceptionalValue();
            }
        }

        @Override
        public BPassword apply(BPassword password) {
            if (password.getPasswordEncoder() instanceof BReversiblePasswordEncoder) {
                return BPassword.DEFAULT;
            }
            return password;
        }
    }

    public static interface PasswordPropertyUpdate
    extends UnaryOperator<BPassword> {
        public static final List<RuntimeException> exceptions = new ArrayList<RuntimeException>();
        public static final List<SlotPath> updatedSlots = new ArrayList<SlotPath>();

        default public BPassword apply(BPassword password, SlotPath slotPath) {
            try {
                return (BPassword)this.apply(password);
            }
            catch (RuntimeException e) {
                exceptions.add(e);
                return this.exceptionalValue();
            }
        }

        default public BPassword exceptionalValue() {
            return BPassword.DEFAULT;
        }

        default public Stream<RuntimeException> exceptions() {
            return exceptions.stream();
        }

        default public List<SlotPath> updatedSlots() {
            return Collections.unmodifiableList(updatedSlots);
        }

        default public void slotUpdated(SlotPath path) {
            updatedSlots.add(path);
        }
    }
}

