/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import com.tridium.nre.diagnostics.DiagnosticUtil;
import java.security.AccessController;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.naming.BModuleScheme;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.LexiconInfo;
import javax.baja.sys.BModule;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;

public class DiagnosticLexicon
extends Lexicon {
    private String diagnosticKey;
    private static final Map<String, Long> lastModifiedMap = new ConcurrentHashMap<String, Long>();
    public static final boolean DIAGNOSTICS = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.lexicon.diagnostics"));
    private static final String PREFIX = AccessController.doPrivileged(() -> System.getProperty("niagara.lexicon.diagnostics.prefix"));
    private static final String SUFFIX = AccessController.doPrivileged(() -> System.getProperty("niagara.lexicon.diagnostics.suffix"));
    private static final boolean ADD_MISSING = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.lexicon.diagnostics.addMissing"));
    private static final boolean ONLY_MISSING = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.lexicon.diagnostics.onlyMissing"));

    public DiagnosticLexicon(BModule module, String lang, String country, String variant) {
        super(module, lang, country, variant);
    }

    @Override
    protected void init(BModule module, String lang, String localKey) {
        this.diagnosticKey = module.getModuleName() + "_" + localKey;
        DiagnosticUtil.diagnose((String)"lexicon.Make", (Object)this.diagnosticKey, () -> super.init(module, lang, localKey));
    }

    @Override
    public Properties getModuleProperties() {
        this.checkForChanges();
        return this.getModifiedProperties(super.getModuleProperties());
    }

    @Override
    public Properties getLanguageProperties() {
        this.checkForChanges();
        return this.getModifiedProperties(super.getLanguageProperties());
    }

    private Properties getModifiedProperties(Properties oldProps) {
        Object[] keys = oldProps.keySet().toArray();
        Properties props = new Properties();
        for (Object key : keys) {
            String result = oldProps.getProperty(key.toString());
            result = this.getModifiedResult(key.toString(), result);
            props.setProperty(key.toString(), result);
        }
        return props;
    }

    private void checkForChanges() {
        Long lastModified;
        if (!BModuleScheme.isModuleDevEnabled()) {
            return;
        }
        boolean reinit = false;
        for (RuntimeProfile profile : this.module.getRuntimeProfiles()) {
            BIFileStore store = DiagnosticLexicon.getFileStore(this.module, profile);
            if (store == null) continue;
            long modified = store.getLastModified().getMillis();
            lastModified = lastModifiedMap.get(store.toString());
            if (lastModified == null) {
                lastModifiedMap.put(store.toString(), modified);
                continue;
            }
            if (modified <= lastModified) continue;
            lastModifiedMap.put(store.toString(), modified);
            reinit = true;
        }
        String localeKey = DiagnosticLexicon.getLocaleKey(this);
        BIFile extendedFile = this.getExtendedFile(this.module, localeKey);
        if (extendedFile != null) {
            long modified = extendedFile.getLastModified().getMillis();
            String extendedKey = extendedFile.toString() + "Extended";
            lastModified = lastModifiedMap.get(extendedKey);
            if (lastModified == null || modified > lastModified) {
                if (lastModified != null) {
                    reinit = true;
                }
                lastModifiedMap.put(extendedKey, modified);
            }
        }
        if (reinit) {
            DiagnosticLexicon.invalidateCache();
            super.init(this.module, this.language, localeKey);
        }
    }

    private BIFile getExtendedFile(BModule module, String localeKey) {
        for (LexiconInfo aLexRegistry : Sys.getRegistry().getLexicons(module.getModuleName(), localeKey)) {
            if (!aLexRegistry.isDefault()) continue;
            return DiagnosticLexicon.getExtendedFile(aLexRegistry);
        }
        return null;
    }

    @Override
    public String get(String key) {
        this.checkForChanges();
        long start = DiagnosticUtil.nanoTime();
        String result = super.get(key);
        if (result == null) {
            DiagnosticUtil.complete((long)start, (String)"lexicon.key.missing", (Object)(this.diagnosticKey + "___" + key));
        } else {
            DiagnosticUtil.complete((long)start, (String)"lexicon.key.used", (Object)(this.diagnosticKey + "___" + key));
        }
        result = this.getModifiedResult(key, result);
        return result;
    }

    private String getModifiedResult(String key, String result) {
        if (this.canModify(key, result)) {
            if (PREFIX != null) {
                result = PREFIX + result;
            }
            if (SUFFIX != null) {
                result = result + SUFFIX;
            }
            if (PREFIX != null || SUFFIX != null) {
                result = TextUtil.replace((String)result, (String)"lexiconKey", (String)key);
                result = TextUtil.replace((String)result, (String)"lexiconModule", (String)this.module.getModuleName());
                result = TextUtil.replace((String)result, (String)"lexiconLang", (String)this.language);
            }
        }
        return result;
    }

    protected boolean canModify(String key, String text) {
        if (text != null && ONLY_MISSING) {
            return false;
        }
        if (text == null && !ADD_MISSING && !ONLY_MISSING) {
            return false;
        }
        if (key.contains(".font") || key.contains(".accelerator") || key.endsWith(".icon") || key.equals("date.displayOrder") || key.contains("weekday.firstDayOfWeek") || key.contains("ip.adapter.none") || key.startsWith("asn.") || key.startsWith("whoHas.") || key.contains(".color") || key.contains(".cellheight") || key.equals("pdf.encoding") || key.contains("pageSize.")) {
            return false;
        }
        if (text != null && (text.contains("module://") || text.contains("/module/") || text.startsWith("#"))) {
            return false;
        }
        try {
            Double.parseDouble(text);
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static String getLocaleKey(Lexicon lex) {
        String localeKey = lex.language;
        if (!lex.country.isEmpty()) {
            localeKey = localeKey + "_" + lex.country;
        }
        if (!lex.variant.isEmpty()) {
            localeKey = localeKey + "_" + lex.variant;
        }
        return localeKey;
    }
}

