/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.timezone;

import java.io.IOException;
import javax.baja.sys.BMonth;
import javax.baja.sys.BTime;
import javax.baja.sys.BWeekday;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.DstRule;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;

public class TzXmlDecoder {
    public static BTimeZone getTimeZone(XElem zoneElem) throws IOException {
        return TzXmlDecoder.getTimeZone(zoneElem, true);
    }

    public static BTimeZone getTimeZone(XElem zoneElem, boolean useCache) throws IOException {
        XElem dstElem;
        BTimeZone zone = null;
        String id = zoneElem.get("id");
        int utcOffset = TzXmlDecoder.getRelTime("utcOffset", zoneElem, true);
        String stdName = id;
        String stdShort = id;
        String dstName = id;
        String dstShort = id;
        XElem displayElem = zoneElem.elem("display");
        if (displayElem != null) {
            stdName = displayElem.get("name", id);
            stdShort = displayElem.get("short", stdName);
            dstName = displayElem.get("dstName", id);
            dstShort = displayElem.get("dstShort", dstName);
        }
        if ((dstElem = zoneElem.elem("dst")) == null) {
            zone = useCache ? BTimeZone.make(id, utcOffset) : BTimeZone.makeIgnoringCache(id, utcOffset);
        } else {
            int dstSavings = TzXmlDecoder.getRelTime("savings", dstElem, true);
            DstRule startRule = TzXmlDecoder.getRule("start", dstElem, true);
            DstRule endRule = TzXmlDecoder.getRule("end", dstElem, true);
            zone = useCache ? BTimeZone.make(id, stdName, stdShort, dstName, dstShort, utcOffset, dstSavings, startRule, endRule) : BTimeZone.makeIgnoringCache(id, stdName, stdShort, dstName, dstShort, utcOffset, dstSavings, startRule, endRule);
        }
        return zone;
    }

    public static int getRelTime(String name, XElem elem, boolean required) {
        String val = elem.get(name, null);
        if (val == null) {
            if (required) {
                throw new XException("Missing \"" + name + "\" attribute.", elem);
            }
            return -1;
        }
        try {
            if (val.endsWith("h")) {
                return (int)(Float.parseFloat(val.substring(0, val.length() - 1)) * 3600000.0f);
            }
            return Integer.parseInt(val);
        }
        catch (Exception e) {
            throw new XException("Invalid time format: " + val, elem);
        }
    }

    public static DstRule getRule(String name, XElem parent, boolean required) throws IOException {
        String weekTxt;
        BTime time = null;
        int timeMode = -1;
        BMonth month = null;
        int day = 0;
        int dayMode = -1;
        int week = -1;
        BWeekday weekday = null;
        XElem ruleElem = parent.elem(name);
        if (ruleElem == null) {
            if (required) {
                throw new XException("Missing \"" + name + "\" element.", parent);
            }
            return null;
        }
        String timeVal = ruleElem.get("time");
        int sep = timeVal.indexOf(32);
        if (sep == -1) {
            time = TzXmlDecoder.parseTime(timeVal);
            timeMode = 0;
        } else {
            time = TzXmlDecoder.parseTime(timeVal.substring(0, sep));
            timeMode = DstRule.decodeTimeMode(timeVal.substring(sep + 1));
        }
        String monthTxt = ruleElem.get("month");
        month = (BMonth)BMonth.january.decodeFromString(monthTxt);
        String wdTxt = ruleElem.get("weekday", null);
        if (wdTxt != null) {
            weekday = (BWeekday)BWeekday.sunday.decodeFromString(wdTxt);
        }
        if ((weekTxt = ruleElem.get("week", null)) != null) {
            try {
                week = DstRule.decodeWeek(weekTxt);
            }
            catch (IllegalArgumentException e) {
                throw new XException("Invalid week specification: " + weekTxt, ruleElem);
            }
        } else {
            week = -1;
        }
        String dayTxt = ruleElem.get("day", null);
        if (dayTxt != null) {
            if (dayTxt.endsWith("...")) {
                dayMode = 1;
                day = Integer.parseInt(dayTxt.substring(0, dayTxt.length() - 3));
            } else if (dayTxt.startsWith("...")) {
                dayMode = 2;
                day = Integer.parseInt(dayTxt.substring(3));
            } else {
                dayMode = 0;
                day = Integer.parseInt(dayTxt);
            }
        } else {
            dayMode = -1;
        }
        if (dayMode == -1) {
            if (week == -1) {
                throw new XException("Week is required if no day is specified.", ruleElem);
            }
            if (weekday == null) {
                throw new XException("Weekday is required if no day is specified.", ruleElem);
            }
            return DstRule.makeWeekday(time, timeMode, week, weekday, month);
        }
        if (dayMode == 0) {
            if (week != -1) {
                throw new XException("\"week\" is not a valid attribute for exact day rules.", ruleElem);
            }
            if (weekday != null) {
                throw new XException("\"weekday\" is not a valid attribute for exact day rules.", ruleElem);
            }
            return DstRule.makeExact(time, timeMode, month, day);
        }
        if (dayMode == 1) {
            if (week != -1) {
                throw new XException("\"week\" is not a valid attribute for \"on or after\" rules.", ruleElem);
            }
            if (weekday == null) {
                throw new XException("\"weekday\" is a required attribute for \"on or after\" rules.", ruleElem);
            }
            return DstRule.makeOnOrAfter(time, timeMode, month, day, weekday);
        }
        if (dayMode == 2) {
            if (week != -1) {
                throw new XException("\"week\" is not a valid attribute for \"on or before\" rules.", ruleElem);
            }
            if (weekday == null) {
                throw new XException("\"weekday\" is a required attribute for \"on or before\" rules.", ruleElem);
            }
            return DstRule.makeOnOrBefore(time, timeMode, month, day, weekday);
        }
        throw new XException("Invalid day mode: " + dayMode, ruleElem);
    }

    public static BTime parseTime(String s) {
        int colon = s.indexOf(58);
        int hour = Integer.parseInt(s.substring(0, colon));
        int minute = Integer.parseInt(s.substring(colon + 1));
        return BTime.make(hour, minute, 0, 0);
    }
}

