/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.transfer;

import com.tridium.sys.transfer.TransferResult;
import com.tridium.sys.transfer.TransferStrategy;
import com.tridium.util.ObjectUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.baja.file.BAbstractFile;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.BObject;
import javax.baja.util.Lexicon;

public class FileToFile
extends TransferStrategy {
    BIFile[] sourceFiles;
    BDirectory targetDir;
    String[] insertNames;
    Lexicon lex;
    String lexCopying;
    String lexMoving;
    String lexDeleting;

    @Override
    public TransferResult transfer() throws Exception {
        this.init();
        this.name();
        this.copy();
        this.remove();
        return this.makeResult();
    }

    protected void init() throws Exception {
        if (FileToFile.isDebugOn()) {
            FileToFile.debug("init");
        }
        this.targetDir = (BDirectory)this.target;
        BObject[] values = this.mark.getValues();
        this.sourceFiles = new BIFile[values.length];
        for (int i = 0; i < values.length; ++i) {
            BIFile src;
            this.sourceFiles[i] = src = (BIFile)((Object)values[i]);
            if (src != this.targetDir) continue;
            throw new IllegalStateException("Source == destination: " + this.targetDir.getFilePath());
        }
        this.lex = Lexicon.make("baja", this.context);
        this.lexCopying = this.lex.getText("file.copying");
        this.lexMoving = this.lex.getText("file.moving");
        this.lexDeleting = this.lex.getText("file.deleting");
    }

    protected void name() throws Exception {
        if (FileToFile.isDebugOn()) {
            FileToFile.debug("name");
        }
        HashMap<String, String> names = FileToFile.namesToHashMap(this.targetDir);
        String[] suggestedNames = this.mark.getNames();
        this.insertNames = new String[suggestedNames.length];
        for (int i = 0; i < this.insertNames.length; ++i) {
            this.insertNames[i] = FileToFile.getUniqueFilename(names, suggestedNames[i]);
            if (FileToFile.isDebugOn()) {
                FileToFile.debug("  " + suggestedNames[i] + " -> " + this.insertNames[i]);
            }
            names.put(this.insertNames[i], "x");
        }
    }

    public static HashMap<String, String> namesToHashMap(BDirectory dir) {
        BIFile[] files;
        HashMap<String, String> names = new HashMap<String, String>();
        for (BIFile file : files = dir.listFiles()) {
            names.put(file.getFileName(), "x");
        }
        return names;
    }

    public static String getUniqueFilename(BDirectory dir, String suggestedName) {
        return FileToFile.getUniqueFilename(FileToFile.namesToHashMap(dir), suggestedName);
    }

    public static boolean isUniqueFilename(BDirectory dir, String name) {
        return FileToFile.namesToHashMap(dir).get(name) == null;
    }

    public static String getUniqueFilename(HashMap<String, String> names, String suggestedName) {
        if (!names.containsKey(suggestedName)) {
            return suggestedName;
        }
        String ext = "";
        int dot = suggestedName.lastIndexOf(46);
        if (dot > 0) {
            ext = suggestedName.substring(dot);
            suggestedName = suggestedName.substring(0, dot);
        }
        String name = ObjectUtil.generateUniqueName(suggestedName, new MapNameContainer(names, ext));
        return name + ext;
    }

    protected void copy() throws Exception {
        if (FileToFile.isDebugOn()) {
            FileToFile.debug("copy");
        }
        for (int i = 0; i < this.sourceFiles.length; ++i) {
            this.copy(this.sourceFiles[i], this.targetDir, this.insertNames[i]);
        }
    }

    private void copy(BIFile src, BDirectory destDir, String nameInDest) throws Exception {
        if (src instanceof BDirectory) {
            this.copyDir((BDirectory)src, destDir, nameInDest);
        } else {
            this.copyFile(src, destDir, nameInDest);
        }
    }

    private void copyDir(BDirectory srcDir, BDirectory destDir, String nameInDest) throws Exception {
        BIFile[] srcFiles;
        if (FileToFile.isDebugOn()) {
            FileToFile.debug("  copyDir: " + srcDir.getFilePath());
        }
        BFileSpace fs = destDir.getFileSpace();
        BDirectory dest = fs.makeDir(destDir.getFilePath().merge(nameInDest), this.getContext());
        for (BIFile srcFile : srcFiles = srcDir.listFiles()) {
            this.copy(srcFile, dest, srcFile.getFileName());
        }
        dest.setLastModified(srcDir.getLastModified());
    }

    private void copyFile(BIFile src, BDirectory destDir, String nameInDest) throws Exception {
        BIFile dest;
        block31: {
            if (FileToFile.isDebugOn()) {
                FileToFile.debug("    copyFile: " + src.getFilePath());
                FileToFile.debug("       isMove: " + this.isMove());
                FileToFile.debug("       dest: " + destDir);
            }
            if (destDir.toString(null).equals("file:~trash") || destDir.toString(null).startsWith("file:~trash/")) {
                this.updateStatus(this.lexDeleting + " \"" + nameInDest + "\"...");
            } else if (this.isMove()) {
                this.updateStatus(this.lexMoving + " \"" + nameInDest + "\"...");
            } else {
                this.updateStatus(this.lexCopying + " \"" + nameInDest + "\"...");
            }
            BFileSpace fs = destDir.getFileSpace();
            dest = fs.makeFile(destDir.getFilePath().merge(nameInDest), this.getContext());
            if ("bog".equalsIgnoreCase(src.getExtension()) || ".kr".equalsIgnoreCase(src.getFileName())) {
                try (InputStream in = src.getInputStream();
                     OutputStream out = dest.getOutputStream();){
                    FileUtil.pipe((InputStream)in, (OutputStream)out);
                    break block31;
                }
            }
            BajaFileUtil.pipe(src, dest);
        }
        if (dest instanceof BAbstractFile) {
            ((BAbstractFile)dest).setLastModified(src.getLastModified());
        }
    }

    protected void remove() throws Exception {
        if (!this.isMove()) {
            return;
        }
        if (FileToFile.isDebugOn()) {
            FileToFile.debug("remove");
        }
        for (BIFile file : this.sourceFiles) {
            BFileSpace fs = file.getFileSpace();
            FilePath path = file.getFilePath();
            if (this.targetDir.toString(null).startsWith("file:~trash")) {
                this.updateStatus(this.lexDeleting + " \"" + path.getName() + "\"...");
            } else {
                this.updateStatus(this.lexMoving + " \"" + path.getName() + "\"...");
            }
            fs.delete(path, this.getContext());
        }
    }

    protected TransferResult makeResult() throws Exception {
        return null;
    }

    static class MapNameContainer
    implements ObjectUtil.NameContainer {
        Map<String, String> map;
        String ext;

        MapNameContainer(Map<String, String> map, String ext) {
            this.map = map;
            this.ext = ext;
        }

        @Override
        public boolean contains(String name) {
            return this.map.get(name + this.ext) != null;
        }
    }
}

