/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.spy;

import com.tridium.sys.Nre;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.util.List;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;

public class UtilSpy
extends SpyDir {
    public UtilSpy() {
        this.add("gc", new GC());
        this.add("forceThreadDump", new ForceThreadDump());
        this.add("JMX Info", new JmxInfo());
    }

    @Override
    public Spy find(String name) {
        if (SpyWriter.verifyNameAndCsrfToken(name, "gc")) {
            return super.find("gc");
        }
        if (SpyWriter.verifyNameAndCsrfToken(name, "forceThreadDump")) {
            return super.find("forceThreadDump");
        }
        return super.find(name);
    }

    @Override
    public void write(SpyWriter out) throws Exception {
        out.w("<ul>");
        for (String name : this.list()) {
            String title = super.find(name).getTitle();
            if (title == null) {
                title = name;
            }
            if (name.equals("gc") || name.equals("forceThreadDump")) {
                out.w("<li>").mutatorButton(name, title).w("</li>");
                continue;
            }
            out.w("<li>").a(name, title).w("</li>\n");
        }
        out.w("</ul>");
        out.println("<hr>");
    }

    static class JmxInfo
    extends Spy {
        JmxInfo() {
        }

        private void row(SpyWriter out, String type, MemoryUsage usage) {
            out.w("<tr>");
            out.w("<td align='left' nowrap='true'>").w(type).w("</td>");
            out.w("<td align='right' nowrap='true'>").w(usage.getInit() / 1024L).w("</td>");
            out.w("<td align='right' nowrap='true'>").w(usage.getUsed() / 1024L).w("</td>");
            out.w("<td align='right' nowrap='true'>").w(usage.getCommitted() / 1024L).w("</td>");
            out.w("<td align='right' nowrap='true'>").w(usage.getMax() / 1024L).w("</td>");
            out.w("</tr>\n");
        }

        @Override
        public void write(SpyWriter out) throws Exception {
            out.startProps("JMX Thread Info");
            ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
            out.prop((Object)"peak thread count", threadBean.getPeakThreadCount());
            out.prop((Object)"current thread count", threadBean.getThreadCount());
            out.prop((Object)"total started thread count", Long.toString(threadBean.getTotalStartedThreadCount()));
            out.endProps();
            out.startProps("JMX Class Loading Info");
            ClassLoadingMXBean classLoadingBean = ManagementFactory.getClassLoadingMXBean();
            out.prop((Object)"loaded class count", classLoadingBean.getLoadedClassCount());
            out.prop((Object)"total loaded class count", Long.toString(classLoadingBean.getTotalLoadedClassCount()));
            out.prop((Object)"unloaded class count", Long.toString(classLoadingBean.getUnloadedClassCount()));
            out.endProps();
            List<MemoryPoolMXBean> poolList = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean pool : poolList) {
                try {
                    MemoryUsage currentUsage = pool.getUsage();
                    MemoryUsage peakUsage = pool.getPeakUsage();
                    out.startTable(true);
                    out.trTitle(pool.getName() + " (KB)", 5);
                    out.w("<tr>");
                    out.thTitle("Type");
                    out.thTitle("init");
                    out.thTitle("used");
                    out.thTitle("committed");
                    out.thTitle("max");
                    out.w("</tr>");
                    this.row(out, "current", currentUsage);
                    this.row(out, "peak", peakUsage);
                    out.endTable();
                }
                catch (Exception exception) {}
            }
        }
    }

    static class ForceThreadDump
    extends Spy {
        ForceThreadDump() {
        }

        @Override
        public void write(SpyWriter out) throws Exception {
            Nre.dumpThreads();
            out.println("The thread dump has been performed.  Access to the dump");
            out.println("cannot be provided via the spy utility since it is done");
            out.println("by native code.  Try using the Platform Manager.");
        }
    }

    static class GC
    extends Spy {
        GC() {
        }

        @Override
        public void write(SpyWriter out) throws Exception {
            long totalMem1 = Runtime.getRuntime().totalMemory() / 1024L;
            long freeMem1 = Runtime.getRuntime().freeMemory() / 1024L;
            System.gc();
            long totalMem2 = Runtime.getRuntime().totalMemory() / 1024L;
            long freeMem2 = Runtime.getRuntime().freeMemory() / 1024L;
            out.startProps("Force Garbage Collection");
            out.trTitle("Before GC", 2);
            out.prop((Object)"totalMemory", totalMem1 + "kb");
            out.prop((Object)"freeMemory", freeMem1 + "kb");
            out.prop((Object)"usedMemory", totalMem1 - freeMem1 + "kb");
            out.trTitle("After GC", 2);
            out.prop((Object)"totalMemory", totalMem2 + "kb");
            out.prop((Object)"freeMemory", freeMem2 + "kb");
            out.prop((Object)"usedMemory", totalMem2 - freeMem2 + "kb");
            out.trTitle("Freed", 2);
            out.prop((Object)"freed", totalMem1 - freeMem1 - (totalMem2 - freeMem2) + "kb");
            out.endProps();
        }
    }
}

