/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.spy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.Writer;
import java.util.regex.Pattern;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Sys;
import org.owasp.encoder.Encode;

public class ConsoleSpyDir
extends SpyDir {
    public ConsoleSpyDir() {
        if (Sys.getProtectedStationHome() == null) {
            return;
        }
        File[] consoleFiles = Sys.getProtectedStationHome().listFiles(new ConsoleFilenameFilter());
        if (consoleFiles != null) {
            for (File f : consoleFiles) {
                if (f == null) continue;
                this.add(f.getName(), new ConsoleSpy(f));
            }
        }
    }

    @Override
    public void write(SpyWriter out) throws Exception {
        super.write(out);
        if (this.list().length == 0) {
            out.write("<p>No Console Files Found</p>");
        }
    }

    class ConsoleFilenameFilter
    implements FilenameFilter {
        final Pattern CONSOLE_PATTERN = Pattern.compile("console(_backup_\\d+_\\d+(_\\d+)?)?.txt");

        ConsoleFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.CONSOLE_PATTERN.matcher(name).matches();
        }
    }

    class ConsoleSpy
    extends Spy {
        private File consoleFile;

        ConsoleSpy(File f) {
            this.consoleFile = f;
        }

        @Override
        public void write(SpyWriter out) throws Exception {
            byte[] bytes;
            out.w("<pre>\n");
            try (FileInputStream in = new FileInputStream(this.consoleFile);){
                bytes = new byte[(int)this.consoleFile.length()];
                in.read(bytes);
            }
            Encode.forHtml((Writer)out, (String)new String(bytes));
            out.w("</pre>\n");
        }
    }
}

