/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import com.tridium.sys.schema.DynamicTable;
import com.tridium.sys.schema.NSlot;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.CursorException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Topic;

final class SlotsCursor
implements SlotCursor<Slot> {
    private int index = -1;
    private volatile boolean closed;
    private BComplex object;
    private NSlot[] frozen;
    private DynamicTable dynamic;
    private int count;

    SlotsCursor(BComplex o, NSlot[] f, DynamicTable d) {
        this.object = o;
        this.frozen = f;
        this.dynamic = d;
        this.count = d == null ? f.length : f.length + d.count;
    }

    @Override
    public BObject target() {
        return this.object;
    }

    @Override
    public Context getContext() {
        return null;
    }

    @Override
    public boolean next() {
        return ++this.index < this.count && !this.closed;
    }

    @Override
    public boolean nextObject() {
        while (this.next()) {
            block4: {
                try {
                    Slot slot = this.slot();
                    if (!slot.isProperty()) continue;
                    if (slot.asProperty().getTypeAccess() != 7) {
                    }
                    break block4;
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean nextComponent() {
        while (this.nextObject()) {
            if (!this.object.get(this.slot().asProperty()).isComponent()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean next(Class<?> cls) {
        while (this.next()) {
            block4: {
                try {
                    Property prop;
                    Slot slot = this.slot();
                    if (!slot.isProperty() || (prop = slot.asProperty()).getTypeAccess() != 7) continue;
                    if (!cls.isInstance(this.object.get(prop))) {
                    }
                    break block4;
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public Slot slot() {
        if (this.closed) {
            throw new CursorException("cursor was closed");
        }
        if (this.index < this.frozen.length) {
            return this.frozen[this.index];
        }
        return this.dynamic.slots[this.index - this.frozen.length];
    }

    @Override
    public Property property() {
        Slot s = this.slot();
        if (s.isProperty()) {
            return s.asProperty();
        }
        throw new CursorException("not a property");
    }

    @Override
    public int getTypeAccess() {
        return this.slot().asProperty().getTypeAccess();
    }

    @Override
    public BValue get() {
        return this.object.get(this.property());
    }

    @Override
    public boolean getBoolean() {
        return this.object.getBoolean(this.slot().asProperty());
    }

    @Override
    public int getInt() {
        return this.object.getInt(this.slot().asProperty());
    }

    @Override
    public long getLong() {
        return this.object.getLong(this.slot().asProperty());
    }

    @Override
    public float getFloat() {
        return this.object.getFloat(this.slot().asProperty());
    }

    @Override
    public double getDouble() {
        return this.object.getDouble(this.slot().asProperty());
    }

    @Override
    public String getString() {
        return this.object.getString(this.slot().asProperty());
    }

    @Override
    public Action action() {
        Slot s = this.slot();
        if (s.isAction()) {
            return s.asAction();
        }
        throw new CursorException("not an action");
    }

    @Override
    public Topic topic() {
        Slot s = this.slot();
        if (s.isTopic()) {
            return s.asTopic();
        }
        throw new CursorException("not a topic");
    }

    @Override
    public void close() {
        this.closed = true;
    }
}

