/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import com.tridium.sys.schema.NProperty;
import javax.baja.sys.Property;

final class DynamicTable {
    static final NProperty[] EMPTY = new NProperty[0];
    final int baseIndex;
    NProperty[] slots = EMPTY;
    NProperty[] alpha = EMPTY;
    int count = 0;

    DynamicTable(int baseIndex) {
        this.baseIndex = baseIndex;
    }

    final int size() {
        return this.count;
    }

    final NProperty get(String key) {
        NProperty[] s = this.alpha;
        int lo = -1;
        int hi = this.count;
        while (hi - lo > 1) {
            int i = (hi + lo) / 2;
            int cmp = key.compareTo(s[i].name);
            if (cmp < 0) {
                hi = i;
                continue;
            }
            if (cmp > 0) {
                lo = i;
                continue;
            }
            return s[i];
        }
        return null;
    }

    final void put(NProperty slot) {
        NProperty old;
        if (this.slots.length <= this.count) {
            this.ensureCapacity(Math.max(8, this.count * 2));
        }
        if ((old = this.insert(slot)) != null) {
            int i = old.index - this.baseIndex;
            System.arraycopy(this.slots, i + 1, this.slots, i, this.count - i - 1);
            --this.count;
        }
        this.slots[this.count] = slot;
        ++this.count;
        this.updateIndices();
    }

    private NProperty insert(NProperty slot) {
        NProperty[] s = this.alpha;
        String name = slot.name;
        if (this.count == 0) {
            s[0] = slot;
            return null;
        }
        if (this.count == 1) {
            int c = name.compareTo(s[0].name);
            if (c == 0) {
                NProperty old = s[0];
                s[0] = slot;
                return old;
            }
            if (c < 0) {
                s[1] = s[0];
                s[0] = slot;
            } else {
                s[1] = slot;
            }
            return null;
        }
        int first = 0;
        int last = this.count - 1;
        int i = (last - first) / 2;
        while (first <= last) {
            int c = name.compareTo(s[i].name);
            if (c == 0) {
                NProperty old = s[i];
                s[i] = slot;
                return old;
            }
            if (c < 0) {
                c = name.compareTo(s[first].name);
                if (c == 0) {
                    NProperty old = s[first];
                    s[first] = slot;
                    return old;
                }
                if (c < 0) {
                    i = first;
                    break;
                }
                last = i - 1;
            } else {
                c = name.compareTo(s[last].name);
                if (c == 0) {
                    NProperty old = s[last];
                    s[last] = slot;
                    return old;
                }
                if (c > 0) {
                    i = last + 1;
                    break;
                }
                first = i + 1;
            }
            i = first + (last - first) / 2;
        }
        System.arraycopy(s, i, s, i + 1, this.count - i);
        s[i] = slot;
        return null;
    }

    final void remove(NProperty slot) {
        this.remove(slot.name);
        int i = slot.index - this.baseIndex;
        System.arraycopy(this.slots, i + 1, this.slots, i, this.count - i - 1);
        this.slots[this.count - 1] = null;
        --this.count;
        this.updateIndices();
    }

    final void reorder(Property[] props) {
        System.arraycopy(props, 0, this.slots, 0, this.count);
        this.updateIndices();
    }

    private void remove(String key) {
        NProperty[] s = this.alpha;
        int lo = -1;
        int hi = this.count;
        while (hi - lo > 1) {
            int i = (hi + lo) / 2;
            int cmp = key.compareTo(s[i].name);
            if (cmp < 0) {
                hi = i;
                continue;
            }
            if (cmp > 0) {
                lo = i;
                continue;
            }
            System.arraycopy(s, i + 1, s, i, this.count - i - 1);
            s[this.count - 1] = null;
            return;
        }
        throw new IllegalStateException(key);
    }

    final void copyInto(Object[] array, int startIndex) {
        System.arraycopy(this.slots, 0, array, startIndex, this.count);
    }

    final void ensureCapacity(int capacity) {
        if (this.alpha.length < capacity) {
            NProperty[] temp = new NProperty[capacity];
            System.arraycopy(this.slots, 0, temp, 0, this.count);
            this.slots = temp;
            temp = new NProperty[capacity];
            System.arraycopy(this.alpha, 0, temp, 0, this.count);
            this.alpha = temp;
        }
    }

    final void clear() {
        this.slots = EMPTY;
        this.alpha = EMPTY;
        this.count = 0;
    }

    final boolean equivalent(DynamicTable x) {
        if (x == null) {
            return false;
        }
        if (this.count != x.count) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.alpha[i].equivalent(x.alpha[i])) continue;
            return false;
        }
        return true;
    }

    private void updateIndices() {
        for (int i = 0; i < this.count; ++i) {
            this.slots[i].index = this.baseIndex + i;
        }
    }
}

