/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.registry;

import com.tridium.sys.registry.NDependencyInfo;
import com.tridium.sys.registry.NTypeInfo;
import com.tridium.sys.registry.RegistryDatabase;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.security.AccessController;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.registry.DependencyInfo;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.TypeInfo;
import javax.baja.util.Version;

public class NModuleInfo
implements ModuleInfo {
    int id;
    String moduleName;
    String modulePartName;
    Version bajaVersion;
    String vendor;
    Version vendorVersion;
    boolean isTransientModule = false;
    boolean isAutoloadModule = true;
    boolean isReloadableModule = false;
    String description;
    RuntimeProfile runtimeProfile = RuntimeProfile.doc;
    NTypeInfo[] types = NTypeInfo.noTypes;
    DependencyInfo[] depends = null;
    boolean hasPalette = false;
    long buildTime;
    boolean isWar;
    private static final boolean UNIT_TEST_MODE = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.unitTestMode"));

    protected NModuleInfo(int id) {
        this.id = id;
    }

    @Override
    public RuntimeProfile getRuntimeProfile() {
        return this.runtimeProfile;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public String getModulePartName() {
        return this.modulePartName;
    }

    @Override
    public Version getBajaVersion() {
        return this.bajaVersion;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public Version getVendorVersion() {
        return this.vendorVersion;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public TypeInfo[] getTypes() {
        return (TypeInfo[])this.types.clone();
    }

    @Override
    public DependencyInfo[] getDependencies() {
        if (this.depends == null) {
            this.depends = NDependencyInfo.load(this.modulePartName);
        }
        return this.depends;
    }

    @Override
    public boolean isTransient() {
        return this.isTransientModule;
    }

    public boolean isAutoload() {
        return !UNIT_TEST_MODE && this.isAutoloadModule;
    }

    public boolean isReloadable() {
        return UNIT_TEST_MODE || this.isReloadableModule;
    }

    public boolean isWar() {
        return this.isWar;
    }

    public long getBuildTime() {
        return this.buildTime;
    }

    public boolean hasPalette() {
        return this.hasPalette;
    }

    void read(RegistryDatabase db, DataInputStream in) throws Exception {
        this.moduleName = in.readUTF();
        this.runtimeProfile = RuntimeProfile.valueOf((String)in.readUTF());
        this.modulePartName = in.readUTF();
        this.bajaVersion = new Version(in.readUTF());
        this.vendor = in.readUTF();
        this.vendorVersion = new Version(in.readUTF());
        this.description = in.readUTF();
        this.hasPalette = in.readBoolean();
        this.buildTime = in.readLong();
        this.types = NTypeInfo.readTypes(db, in);
        try {
            this.isAutoloadModule = in.readBoolean();
            this.isReloadableModule = in.readBoolean();
            this.isWar = in.readBoolean();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void write(RegistryDatabase db, DataOutputStream out) throws Exception {
        out.writeUTF(this.moduleName);
        out.writeUTF(this.runtimeProfile.name());
        out.writeUTF(this.modulePartName);
        out.writeUTF(this.bajaVersion.toString());
        out.writeUTF(this.vendor);
        out.writeUTF(this.vendorVersion.toString());
        out.writeUTF(this.description);
        out.writeBoolean(this.hasPalette);
        out.writeLong(this.buildTime);
        NTypeInfo.writeTypes(db, out, this.types);
        out.writeBoolean(this.isAutoloadModule);
        out.writeBoolean(this.isReloadableModule);
        out.writeBoolean(this.isWar);
    }

    public int hashCode() {
        return this.modulePartName.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof NModuleInfo)) {
            return false;
        }
        NModuleInfo info = (NModuleInfo)o;
        return this.moduleName.equals(info.moduleName) && this.modulePartName.equals(info.modulePartName) && this.vendor.equals(info.vendor) && this.vendorVersion.equals(info.vendorVersion);
    }

    public String toString() {
        return "NModuleInfo (" + this.moduleName + ')';
    }
}

