/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.net;

import com.tridium.nre.platform.PlatformUtil;
import com.tridium.nre.util.IPAddressUtil;
import com.tridium.nre.util.InterfaceNetworkSettings;
import com.tridium.sys.Nre;
import java.io.File;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;

public class NetworkInterfaceManager {
    static Logger log = Logger.getLogger("sys.net");

    public void postInit() {
        IPAddressUtil.getLocalHost();
        IPAddressUtil.getLocalHost(null);
        Nre.spySysManagers.add("networkInterfaceManager", new SummaryPage());
    }

    public boolean checkNetworkInterfaces() {
        boolean interfaceRefreshed = false;
        try {
            try {
                interfaceRefreshed = AccessController.doPrivileged(() -> {
                    boolean tempInterfacesRefreshed = false;
                    long tempNetworkInterfaceEventLastModified = NetworkInterfaceEventFileHolder.NETWORK_INTERFACE_EVENT_FILE.lastModified();
                    if (tempNetworkInterfaceEventLastModified != NetworkInterfaceEventFileHolder.networkInterfaceEventLastModified) {
                        if (NetworkInterfaceEventFileHolder.networkInterfaceEventLastModified == 0L || tempNetworkInterfaceEventLastModified != 0L) {
                            log.info("Network interface event encountered, refreshing local network interfaces...");
                            IPAddressUtil.clearLocalHostCache();
                            IPAddressUtil.getLocalHost();
                            IPAddressUtil.getLocalHost(null);
                            tempInterfacesRefreshed = true;
                            log.info("Network interface refresh complete");
                        }
                        NetworkInterfaceEventFileHolder.networkInterfaceEventLastModified = tempNetworkInterfaceEventLastModified;
                    }
                    return tempInterfacesRefreshed;
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Error occurred checking for network interface changes", t);
        }
        return interfaceRefreshed;
    }

    private static class NetworkInterfaceEventFileHolder {
        private static final File NETWORK_INTERFACE_EVENT_FILE = AccessController.doPrivileged(() -> new File(PlatformUtil.getPlatformProvider().getTempDirPath() + File.separatorChar + "niagara_network_interface_event"));
        private static long networkInterfaceEventLastModified = NETWORK_INTERFACE_EVENT_FILE.lastModified();

        private NetworkInterfaceEventFileHolder() {
        }
    }

    public static class SummaryPage
    extends SpyDir {
        @Override
        public Spy find(String name) {
            if (SpyWriter.verifyNameAndCsrfToken(name, "refresh")) {
                return new RefreshInterfacesPage();
            }
            return super.find(name);
        }

        @Override
        public void write(SpyWriter out) throws Exception {
            InterfaceNetworkSettings[] knownInterfaceNetworkSettings;
            out.startProps("Network Interface Manager");
            out.prop((Object)"Hostname", IPAddressUtil.getHostName());
            out.prop((Object)"Niagara IPv6 Enabled", AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.ipv6Enabled")));
            out.prop((Object)"Niagara Preferred Adapter", AccessController.doPrivileged(() -> System.getProperty("niagara.preferred.network.adapter", "")));
            out.prop((Object)"Niagara Virtual Adapter Patterns", AccessController.doPrivileged(() -> System.getProperty("niagara.virtual.network.adapters", "^docker[0-9]+;^virbr[0-9]+;^virt[0-9]+;^vnet[0-9]+")));
            out.prop((Object)"Niagara Excluded Adapter Patterns", AccessController.doPrivileged(() -> System.getProperty("niagara.excluded.network.adapters", "")));
            out.prop((Object)"Niagara Check Network Adapter Events", AccessController.doPrivileged(() -> System.getProperty("niagara.enable.network.interface.events", "false")));
            out.prop((Object)"Default IPv4 Address", IPAddressUtil.getLocalHost((boolean)false));
            out.prop((Object)"Default IPv6 Address", IPAddressUtil.getLocalHost((boolean)true));
            out.prop((Object)"Default Address Without Hint", IPAddressUtil.getLocalHost());
            out.prop((Object)"Default Address With null Hint", IPAddressUtil.getLocalHost(null));
            out.prop((Object)"Local host with IPv4 Hint", IPAddressUtil.getLocalHost((InetAddress)IPAddressUtil.getLocalHost((boolean)false)));
            out.prop((Object)"Local host with IPv6 Hint", IPAddressUtil.getLocalHost((InetAddress)IPAddressUtil.getLocalHost((boolean)true)));
            out.prop((Object)"Last Network Interface Event", new Date(NetworkInterfaceEventFileHolder.networkInterfaceEventLastModified));
            out.prop((Object)"", () -> out.mutatorButton("refresh", "Refresh Network Interfaces"));
            out.endProps();
            out.startTable(true);
            out.trTitle("Niagara Network Interfaces", 2);
            for (InterfaceNetworkSettings interfaceNetworkSettings : knownInterfaceNetworkSettings = IPAddressUtil.getLocalHostInterfaces()) {
                out.tr("Address", interfaceNetworkSettings.getNetworkInterface().getName() + " -> " + interfaceNetworkSettings.getInetAddress() + "/" + interfaceNetworkSettings.getInterfaceAddress().getNetworkPrefixLength());
            }
            out.endTable();
            out.w("<br>");
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface currentInterface = networkInterfaces.nextElement();
                if (currentInterface.getInterfaceAddresses().isEmpty()) continue;
                out.startTable(true);
                out.trTitle("Java Network Interface \"" + currentInterface.getName() + "\" (Addressed)", 2);
                out.tr("Display Name", currentInterface.getDisplayName());
                out.tr("Index", currentInterface.getIndex());
                out.tr("Hardware Address", TextUtil.toUpperCase((String)ByteArrayUtil.toHexString((byte[])currentInterface.getHardwareAddress())));
                out.tr("MTU", currentInterface.getMTU());
                for (InterfaceAddress interfaceAddress : currentInterface.getInterfaceAddresses()) {
                    out.tr("Address", interfaceAddress.getAddress() + "/" + interfaceAddress.getNetworkPrefixLength());
                }
                out.endTable();
            }
            out.w("<br>");
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface currentInterface = networkInterfaces.nextElement();
                if (!currentInterface.getInterfaceAddresses().isEmpty()) continue;
                out.startTable(true);
                out.trTitle("Java Network Interface \"" + currentInterface.getName() + "\" (No Address)", 2);
                out.tr("Display Name", currentInterface.getDisplayName());
                out.tr("Index", currentInterface.getIndex());
                out.tr("Hardware Address", TextUtil.toUpperCase((String)ByteArrayUtil.toHexString((byte[])currentInterface.getHardwareAddress())));
                out.tr("MTU", currentInterface.getMTU());
                out.endTable();
            }
        }

        public static class RefreshInterfacesPage
        extends Spy {
            @Override
            public void write(SpyWriter out) throws Exception {
                log.info("Manual network interface refresh request encountered, refreshing local network interfaces...");
                IPAddressUtil.clearLocalHostCache();
                IPAddressUtil.getLocalHost();
                IPAddressUtil.getLocalHost(null);
                log.info("Network interface refresh complete");
                out.w("Network interfaces refreshed");
            }
        }
    }
}

