/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license.dom;

import com.tridium.sys.license.LicenseUtil;
import com.tridium.sys.license.dom.VendorLicense;
import java.io.PrintWriter;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Clock;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;

public class Feature
implements Comparable<Feature> {
    private final VendorLicense parent;
    private final String name;
    private final String key;
    private XElem xml;

    static Feature make(VendorLicense parent, String name) {
        if (name.equalsIgnoreCase("brand")) {
            return new Brand(parent);
        }
        return new Feature(parent, name);
    }

    private Feature(VendorLicense parent, String name) {
        if (parent == null) {
            throw new NullPointerException();
        }
        this.parent = parent;
        this.name = name;
        this.key = Feature.toKey(name);
        this.xml = new XElem("feature");
        this.xml.setAttr("name", name);
    }

    static String toKey(String name) {
        return TextUtil.toLowerCase((String)name);
    }

    public VendorLicense getParent() {
        return this.parent;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public boolean isExpired() {
        return Clock.millis() > this.getExpiration() || this.parent.isExpired();
    }

    public long getExpiration() {
        String expValue = this.xml.get("expiration", null);
        return expValue == null ? Long.MAX_VALUE : LicenseUtil.parseDate(expValue, false);
    }

    public void setExpiration(long expiration) {
        this.modify();
        this.xml.setAttr("expiration", LicenseUtil.formatDate(expiration));
    }

    @Override
    public int compareTo(Feature obj) {
        String other = obj.name;
        if (this.name.equals("about")) {
            return -1;
        }
        if (this.name.equals("brand")) {
            return other.equals("about") ? 1 : -1;
        }
        return this.name.compareTo(other);
    }

    public String toString() {
        return this.parent.getVendor() + ":" + this.getName();
    }

    public String get(String name) {
        return this.xml.get(name, null);
    }

    public String get(String name, String def) {
        return this.xml.get(name, def);
    }

    public boolean getb(String name, boolean def) {
        return this.xml.getb(name, def);
    }

    public int geti(String name, int def) {
        return this.xml.geti(name, def);
    }

    public String[] list() {
        Array result = new Array(String.class, this.xml.attrSize());
        for (int i = 0; i < this.xml.attrSize(); ++i) {
            String name = this.xml.attrName(i);
            if (name.equals("name") || name.equals("expiration")) continue;
            result.add((Object)name);
        }
        return (String[])result.trim();
    }

    public void set(String name, String val) {
        this.xml.setAttr(name, val);
    }

    public final void set(String name, boolean val) {
        this.set(name, String.valueOf(val));
    }

    public final void set(String name, int val) {
        this.set(name, String.valueOf(val));
    }

    public final void remove(String name) {
        this.xml.removeAttr(name);
    }

    void load(XElem xml) throws Exception {
        if (!xml.qname().equals("feature")) {
            throw new XException("Root element must be <feature> element", xml);
        }
        this.xml = xml.copy();
    }

    XElem save() {
        return this.xml.copy();
    }

    public void dump(PrintWriter out) {
        out.println("    " + this.name);
        out.println("      expiration:         " + LicenseUtil.formatDate(this.getExpiration()));
        String[] names = this.list();
        for (int i = 0; i < names.length; ++i) {
            out.println("      " + TextUtil.pad((String)(names[i] + ": "), (int)20) + this.get(names[i]));
        }
        out.flush();
    }

    public void modify() {
        this.getParent().modify();
    }

    public static class Brand
    extends Feature {
        Brand(VendorLicense parent) {
            super(parent, "brand");
        }

        public String getBrandId() {
            return this.get("brandId");
        }

        public String getStationIn() {
            return this.get("accept.station.in");
        }

        public String getStationOut() {
            return this.get("accept.station.out");
        }

        public String getWbIn() {
            return this.get("accept.wb.in");
        }

        public String getWbOut() {
            return this.get("accept.wb.out");
        }
    }
}

