/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.engine;

import com.tridium.sys.engine.EngineManager;
import com.tridium.sys.schema.ComponentSlotMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.Action;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BRelation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Topic;

public final class EngineUtil {
    public static final Logger log = EngineManager.log;

    public static final void invoke(BComponent comp, Action action, BValue arg, Context cx) {
        try {
            comp.invoke(action, arg, cx);
        }
        catch (ActionInvokeException e) {
            log.log(Level.SEVERE, "Action failed: " + action, e.getCause());
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Action failed: " + action, e);
        }
    }

    public static final void doInvoke(BComponent comp, Action action, BValue arg, Context cx) {
        try {
            ((ComponentSlotMap)comp.fw(1)).invoke(action, arg, cx, true);
        }
        catch (ActionInvokeException e) {
            log.log(Level.SEVERE, "Action failed: " + action, e.getCause());
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Action failed: " + action, e);
        }
    }

    public static final void fire(BComponent comp, Topic topic, BValue arg) {
        try {
            comp.fire(topic, arg);
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Topic failed: " + topic, e);
        }
    }

    public static final void activate(BLink link) {
        try {
            if (link.isEnabled()) {
                link.activate();
            }
        }
        catch (UnresolvedException e) {
            log.log(Level.SEVERE, "Cannot activate link \"" + EngineUtil.toString(link) + "\": " + e.getMessage());
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Cannot activate link \"" + EngineUtil.toString(link) + "\"", e);
        }
    }

    public static final void activate(BRelation relation) {
        try {
            relation.activateRelation();
        }
        catch (UnresolvedException e) {
            log.log(Level.SEVERE, "Cannot activate relation \"" + EngineUtil.toString(relation) + "\": " + e.getMessage());
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Cannot activate relation \"" + EngineUtil.toString(relation) + "\"", e);
        }
    }

    public static final void deactivate(BLink link) {
        try {
            if (link.isActive()) {
                link.deactivate();
            }
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Cannot deactivate link \"" + EngineUtil.toString(link) + "\"", e);
        }
    }

    public static final void deactivate(BRelation relation) {
        try {
            relation.deactivateRelation();
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Cannot deactivate relation \"" + EngineUtil.toString(relation) + "\"", e);
        }
    }

    public static void started(BComponent component) {
        try {
            component.fw(11, null, null, null, null);
            component.started();
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Cannot start component: " + EngineUtil.toString(component), e);
        }
    }

    public static void stopped(BComponent component) {
        try {
            component.fw(12, null, null, null, null);
            component.stopped();
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Cannot stop component: " + EngineUtil.toString(component), e);
        }
    }

    public static void descendantsStarted(BComponent component) {
        try {
            component.fw(13, null, null, null, null);
            component.descendantsStarted();
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Cannot start component: " + EngineUtil.toString(component), e);
        }
    }

    public static void descendantsStopped(BComponent component) {
        try {
            component.fw(14, null, null, null, null);
            component.descendantsStopped();
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Cannot stop component: " + EngineUtil.toString(component), e);
        }
    }

    public static void stationStarted(BComponent component) {
        try {
            component.fw(23, null, null, null, null);
            component.stationStarted();
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Failed stationStarted: " + EngineUtil.toString(component), e);
        }
    }

    public static void atSteadyState(BComponent component) {
        try {
            component.fw(20, null, null, null, null);
            component.atSteadyState();
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Failed atSteadyState: " + EngineUtil.toString(component), e);
        }
    }

    public static void clockChanged(BComponent component, BRelTime shift) {
        try {
            component.clockChanged(shift);
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Failed clockChanged: " + EngineUtil.toString(component), e);
        }
    }

    public static String toString(Object x) {
        try {
            return String.valueOf(x);
        }
        catch (Throwable e) {
            return x.getClass().getName() + "???";
        }
    }

    public static void activateLinks(BComponent component) {
        try {
            SlotCursor<Property> c = component.getProperties();
            while (c.nextObject()) {
                BValue child = c.get();
                if (child instanceof BLink) {
                    EngineUtil.activate((BLink)child);
                } else if (child instanceof BRelation) {
                    EngineUtil.activate((BRelation)child);
                }
                if (!(child instanceof BComponent)) continue;
                EngineUtil.activateLinks((BComponent)child);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deactivateLinks(BComponent component) {
        try {
            SlotCursor<Property> c = component.getProperties();
            while (c.nextObject()) {
                BValue child = c.get();
                if (child instanceof BLink) {
                    EngineUtil.deactivate((BLink)child);
                } else if (child instanceof BRelation) {
                    EngineUtil.deactivate((BRelation)child);
                }
                if (!(child instanceof BComponent)) continue;
                EngineUtil.deactivateLinks((BComponent)child);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

