/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.engine;

import com.tridium.sys.Nre;
import com.tridium.sys.engine.ActionQueue;
import com.tridium.sys.engine.EngineUtil;
import com.tridium.sys.engine.NClockTicket;
import com.tridium.sys.engine.TicketQueue;
import com.tridium.sys.net.NetworkInterfaceManager;
import com.tridium.sys.resource.ResourceReport;
import java.security.AccessController;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.SortUtil;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BRelation;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Flags;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;

public class EngineManager {
    static DecimalFormat timeFormat = new DecimalFormat("#.000 ms");
    public static final Logger log = Logger.getLogger("sys.engine");
    private static final int SYSTEM_CLOCK_CHANGE_TOLERANCE = 1000;
    public static long engineSleepPeriod = 20L;
    private EngineThread engineThread;
    private final long startTicks;
    private volatile int scanCount;
    private long totalTicksInsideScan;
    private long lastTotalTicksInsideScan = 0L;
    private long deltaTicksInsideScan = 0L;
    private long endScanTicks = 0L;
    private long lastMillisVsTicksDelta;
    private final ActionQueue actionQueue = new ActionQueue();
    private BComponent currentComponent;
    private Action currentAction;
    private static final boolean CHECK_NETWORK_INTERFACE_EVENT_PROPERTY_VALUE = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.enable.network.interface.events"));
    private static final int NETWORK_INTERFACE_CHECK_TICKS = 10000;
    private long lastNetworkInterfaceCheckTicks = Clock.ticks();
    private boolean suspended = false;
    private int engineStateCount = 10;
    private final LinkedList<EngineStats> peakScanStats = new LinkedList();
    private final LinkedList<EngineStats> peakInterscanStats = new LinkedList();
    public static long shortTimerThreshold = 2100L;
    public static long mediumTimerThreshold = 61000L;
    public TicketQueue shortTimers = new TicketQueue(100, 1000);
    public TicketQueue mediumTimers = new TicketQueue(1000, 10000);
    public TicketQueue longTimers = new TicketQueue(1000, 30000);

    public EngineManager() {
        this.startTicks = Clock.ticks();
        this.lastMillisVsTicksDelta = this.getMillisVsTicksDelta();
        this.engineThread = new EngineThread();
        this.engineThread.start();
    }

    public void start(BComponent component) {
        if (!component.isRunning()) {
            throw new IllegalStateException();
        }
        this.activateLinks(component);
        this.activateRelations(component);
        EngineUtil.started(component);
        SlotCursor<Property> c = component.getProperties();
        while (c.nextComponent()) {
            if (Flags.isNoRun(component, c.property())) continue;
            c.get().asComponent().start();
        }
        EngineUtil.descendantsStarted(component);
    }

    private void activateLinks(BComponent component) {
        SlotCursor<Property> c = component.getProperties();
        while (c.nextObject()) {
            BValue child = c.get();
            if (!(child instanceof BLink)) continue;
            EngineUtil.activate((BLink)child);
        }
    }

    private void activateRelations(BComponent component) {
        SlotCursor<Property> c = component.getProperties();
        while (c.nextObject()) {
            BValue child = c.get();
            if (child instanceof BLink || !(child instanceof BRelation)) continue;
            EngineUtil.activate((BRelation)child);
        }
    }

    public void stop(BComponent component) {
        if (component.isRunning()) {
            throw new IllegalStateException();
        }
        this.deactivateLinks(component);
        EngineUtil.stopped(component);
        SlotCursor<Property> c = component.getProperties();
        while (c.nextComponent()) {
            c.get().asComponent().stop();
        }
        EngineUtil.descendantsStopped(component);
    }

    private void deactivateLinks(BComponent component) {
        SlotCursor<Property> c = component.getProperties();
        while (c.nextObject()) {
            BValue child = c.get();
            if (child instanceof BLink) {
                EngineUtil.deactivate((BLink)child);
                continue;
            }
            if (!(child instanceof BRelation)) continue;
            EngineUtil.deactivate((BRelation)child);
        }
    }

    public void stationStarted(BComponent component) {
        EngineUtil.stationStarted(component);
        SlotCursor<Property> c = component.getProperties();
        while (c.nextComponent()) {
            this.stationStarted(c.get().asComponent());
        }
    }

    public void atSteadyState(BComponent component) {
        if (!component.isRunning()) {
            log.warning("Not running: " + component);
            return;
        }
        EngineUtil.atSteadyState(component);
        SlotCursor<Property> c = component.getProperties();
        while (c.nextComponent()) {
            this.atSteadyState(c.get().asComponent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute() {
        long startScanTicks = Clock.ticks();
        long scanDelta = startScanTicks - this.endScanTicks;
        if (this.scanCount != 0 && Sys.atSteadyState() && scanDelta > this.peakInterscanStats.getLast().getTicks()) {
            LinkedList<EngineStats> linkedList = this.peakInterscanStats;
            synchronized (linkedList) {
                ListIterator<EngineStats> iter = this.peakInterscanStats.listIterator();
                while (iter.hasNext()) {
                    EngineStats s = (EngineStats)iter.next();
                    if (scanDelta < s.getTicks()) continue;
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("New Peak Delta entry " + scanDelta + " (peak " + this.peakInterscanStats.getFirst().getTicks() + ") ms");
                    }
                    iter.previous();
                    iter.add(new EngineStats(scanDelta, BAbsTime.now()));
                    break;
                }
                if (this.peakInterscanStats.size() > this.engineStateCount) {
                    this.peakInterscanStats.removeLast();
                }
            }
        }
        this.checkIfSystemClockChanged();
        if (CHECK_NETWORK_INTERFACE_EVENT_PROPERTY_VALUE && startScanTicks - this.lastNetworkInterfaceCheckTicks > 10000L) {
            this.checkIfNetworkInterfacesChanged();
            this.lastNetworkInterfaceCheckTicks = startScanTicks;
        }
        this.shortTimers.check();
        this.mediumTimers.check();
        this.longTimers.check();
        this.checkAsyncActions();
        this.endScanTicks = Clock.ticks();
        long scanTicks = this.endScanTicks - startScanTicks;
        if (scanTicks > this.peakScanStats.getLast().getTicks() && Sys.atSteadyState()) {
            LinkedList<EngineStats> linkedList = this.peakScanStats;
            synchronized (linkedList) {
                ListIterator<EngineStats> iter = this.peakScanStats.listIterator();
                while (iter.hasNext()) {
                    EngineStats s = (EngineStats)iter.next();
                    if (scanTicks < s.getTicks()) continue;
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("New Peak Scan entry " + scanTicks + " (peak " + this.peakScanStats.getFirst().getTicks() + ") ms");
                    }
                    iter.previous();
                    iter.add(new EngineStats(scanTicks, BAbsTime.now()));
                    break;
                }
                if (this.peakScanStats.size() > this.engineStateCount) {
                    this.peakScanStats.removeLast();
                }
            }
        }
        this.totalTicksInsideScan += scanTicks;
        ++this.scanCount;
        if (this.scanCount % 10 == 0) {
            this.deltaTicksInsideScan = this.totalTicksInsideScan - this.lastTotalTicksInsideScan;
            this.lastTotalTicksInsideScan = this.totalTicksInsideScan;
        }
    }

    private void checkIfNetworkInterfacesChanged() {
        NetworkInterfaceManager manager = AccessController.doPrivileged(Nre::getNetworkInterfaceManager);
        if (manager == null || manager.checkNetworkInterfaces()) {
            // empty if block
        }
    }

    private void checkIfSystemClockChanged() {
        long warp = this.getSystemClockWarp();
        if (warp != 0L) {
            log.warning("System clock modified: " + warp + "ms");
            this.clockChanged(Sys.getStation(), BRelTime.make(warp));
        }
    }

    private long getMillisVsTicksDelta() {
        long t1 = Clock.ticks();
        long millis = Clock.millis();
        long t2 = Clock.ticks();
        if (t2 - t1 > 1000L) {
            return 0L;
        }
        long delta = t2 - millis;
        return delta >= 0L ? delta : -delta;
    }

    private long getSystemClockWarp() {
        long thisDelta = this.getMillisVsTicksDelta();
        if (thisDelta == 0L) {
            return 0L;
        }
        long deltaDelta = thisDelta - this.lastMillisVsTicksDelta;
        if (Math.abs(deltaDelta) < 1000L) {
            return 0L;
        }
        this.lastMillisVsTicksDelta = thisDelta;
        return deltaDelta;
    }

    public void clockChanged(BComponent component, BRelTime shift) {
        try {
            if (component == null) {
                return;
            }
            EngineUtil.clockChanged(component, shift);
            SlotCursor<Property> c = component.getProperties();
            while (c.nextComponent()) {
                this.clockChanged(c.get().asComponent(), shift);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueAction(BComponent comp, Action action, BValue arg) {
        ActionQueue actionQueue = this.actionQueue;
        synchronized (actionQueue) {
            if (comp == this.currentComponent && action == this.currentAction && Thread.currentThread() instanceof EngineThread) {
                return;
            }
            this.actionQueue.enqueue(comp, action, arg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkAsyncActions() {
        ActionQueue.Entry entry = null;
        ActionQueue actionQueue = this.actionQueue;
        synchronized (actionQueue) {
            entry = this.actionQueue.reset();
        }
        while (entry != null) {
            this.currentComponent = entry.component;
            this.currentAction = entry.action;
            EngineUtil.doInvoke(entry.component, entry.action, entry.arg, null);
            ActionQueue.Entry old = entry;
            entry = entry.next;
            old.next = null;
        }
        this.currentComponent = null;
        this.currentAction = null;
    }

    public NClockTicket schedule(BComponent comp, BRelTime time, Action action, BValue arg) {
        if (!comp.isRunning()) {
            throw new NotRunningException();
        }
        if (action == null) {
            throw new NullPointerException("Null action");
        }
        long t = time.getMillis();
        if (t <= 0L) {
            throw new IllegalArgumentException("time <= 0");
        }
        NClockTicket ticket = new NClockTicket(comp, action, arg);
        ticket.nextUpdate = -(Clock.ticks() + t);
        ticket.period = 0L;
        this.enqueueTicket(ticket);
        return ticket;
    }

    public NClockTicket schedule(BComponent comp, BAbsTime time, Action action, BValue arg) {
        if (!comp.isRunning()) {
            throw new NotRunningException();
        }
        if (action == null) {
            throw new NullPointerException("Null action");
        }
        long t = time.getMillis();
        if (t <= 0L) {
            throw new IllegalArgumentException("time <= 0");
        }
        NClockTicket ticket = new NClockTicket(comp, action, arg);
        ticket.nextUpdate = t;
        ticket.period = 0L;
        this.enqueueTicket(ticket);
        return ticket;
    }

    public NClockTicket schedulePeriodically(BComponent comp, BRelTime relPeriod, Action action, BValue arg) {
        if (!comp.isRunning()) {
            throw new NotRunningException();
        }
        if (action == null) {
            throw new NullPointerException("Null action");
        }
        long p = relPeriod.getMillis();
        if (p <= 0L) {
            throw new IllegalArgumentException("period <= 0");
        }
        NClockTicket ticket = new NClockTicket(comp, action, arg);
        ticket.nextUpdate = -(Clock.ticks() + p);
        ticket.period = p;
        this.enqueueTicket(ticket);
        return ticket;
    }

    public NClockTicket schedulePeriodically(BComponent comp, BAbsTime start, BRelTime relPeriod, Action action, BValue arg) {
        if (!comp.isRunning()) {
            throw new NotRunningException();
        }
        if (action == null) {
            throw new NullPointerException("Null action");
        }
        long s = start.getMillis();
        long p = relPeriod.getMillis();
        if (s <= 0L) {
            throw new IllegalArgumentException("start <= 0");
        }
        if (p <= 0L) {
            throw new IllegalArgumentException("period <= 0");
        }
        NClockTicket ticket = new NClockTicket(comp, action, arg);
        ticket.nextUpdate = s;
        ticket.period = p;
        this.enqueueTicket(ticket);
        return ticket;
    }

    void enqueueTicket(NClockTicket ticket) {
        long ms = ticket.period;
        if (ms <= 0L) {
            ms = ticket.millisLeft();
        }
        if (ms < shortTimerThreshold) {
            this.shortTimers.enqueue(ticket);
        } else if (ms < mediumTimerThreshold) {
            this.mediumTimers.enqueue(ticket);
        } else {
            this.longTimers.enqueue(ticket);
        }
    }

    public void reportResources(ResourceReport r) {
        double avg = (double)this.totalTicksInsideScan / (double)this.scanCount;
        double last10Avg = (double)this.deltaTicksInsideScan / 10.0;
        double uptime = Clock.ticks() - this.startTicks;
        double usage = (double)this.totalTicksInsideScan / uptime * 100.0;
        r.put("engine.scan.lifetime", timeFormat.format(avg));
        EngineStats stats = this.peakScanStats.getFirst();
        r.put("engine.scan.peak", timeFormat.format(stats.getTicks()));
        r.put("engine.scan.timeOfPeak", stats.getTime().toString());
        stats = this.peakInterscanStats.getFirst();
        r.put("engine.scan.peakInterscan", timeFormat.format(stats.getTicks()));
        r.put("engine.scan.timeOfPeakInterscan", stats.getTime().toString());
        r.put("engine.scan.recent", timeFormat.format(last10Avg));
        r.put("engine.scan.usage", (int)usage + "%");
        r.put("engine.queue.shortTimers", this.shortTimers.size + " (Peak " + this.shortTimers.peak + ")");
        r.put("engine.queue.mediumTimers", this.mediumTimers.size + " (Peak " + this.mediumTimers.peak + ")");
        r.put("engine.queue.longTimers", this.longTimers.size + " (Peak " + this.longTimers.peak + ")");
        r.put("engine.queue.actions", this.actionQueue.size() + " (Peak " + this.actionQueue.peak() + ")");
    }

    public void postInit() {
        SummaryPage summary = new SummaryPage();
        Nre.spySysManagers.add("engineManager", summary);
        summary.add("shortTimers", new TicketQueuePage(this.shortTimers));
        summary.add("mediumTimers", new TicketQueuePage(this.mediumTimers));
        summary.add("longTimers", new TicketQueuePage(this.longTimers));
        summary.add("asyncQueue", new AsyncQueuePage());
        summary.add("hogs", new HogsPage());
        summary.add("resetHogs", new ResetHogsPage());
        summary.add("resetPeakScanTime", new ResetPeakScanTime());
    }

    static String timeStr(long t) {
        return "" + t + "ms [" + BRelTime.toString(t) + "]";
    }

    public void suspend() {
        this.suspended = true;
    }

    public void resume() {
        this.suspended = false;
    }

    public int getPriority() {
        return this.engineThread.getPriority();
    }

    public int getCycles() {
        return this.scanCount;
    }

    public long getTotalTicksInsideCycle() {
        return this.totalTicksInsideScan;
    }

    public float getAverageTicks() {
        double last10Avg = (double)this.deltaTicksInsideScan / 10.0;
        return (float)last10Avg;
    }

    public long getPeakTicksInsideScan() {
        return this.peakScanStats.getFirst().getTicks();
    }

    public void resetEngineStats() {
        this.initStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStats() {
        this.engineStateCount = AccessController.doPrivileged(() -> Integer.getInteger("niagara.engineStatCount", 10));
        LinkedList<EngineStats> linkedList = this.peakScanStats;
        synchronized (linkedList) {
            this.peakScanStats.clear();
            while (this.peakScanStats.size() < this.engineStateCount) {
                this.peakScanStats.add(new EngineStats(-1L, BAbsTime.END_OF_TIME));
            }
        }
        linkedList = this.peakInterscanStats;
        synchronized (linkedList) {
            this.peakInterscanStats.clear();
            while (this.peakInterscanStats.size() < this.engineStateCount) {
                this.peakInterscanStats.add(new EngineStats(-1L, BAbsTime.END_OF_TIME));
            }
        }
    }

    public LinkedList<EngineStats> getPeakScanStats() {
        return new LinkedList<EngineStats>(this.peakScanStats);
    }

    public LinkedList<EngineStats> getPeakInterscanStats() {
        return new LinkedList<EngineStats>(this.peakInterscanStats);
    }

    public class EngineStats {
        private long ticks;
        private BAbsTime time;

        public EngineStats(long ticks, BAbsTime time) {
            this.ticks = ticks;
            this.time = time;
        }

        public long getTicks() {
            return this.ticks;
        }

        public BAbsTime getTime() {
            return this.time;
        }

        public String toString() {
            return this.getTicks() + " @ " + this.getTime();
        }
    }

    class EngineThread
    extends Thread {
        public EngineThread() {
            super(Nre.mainThreadGroup, "Nre:Engine");
            this.setDaemon(true);
            EngineManager.this.initStats();
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(engineSleepPeriod);
                        if (EngineManager.this.suspended) continue;
                        EngineManager.this.execute();
                    }
                }
                catch (Throwable e) {
                    log.log(Level.SEVERE, "Error in run", e);
                    continue;
                }
                break;
            }
        }
    }

    public class ResetHogsPage
    extends Spy {
        @Override
        public void write(SpyWriter out) throws Exception {
            BComponent[] allComponents;
            BStation station = Sys.getStation();
            if (station == null) {
                out.w("Not station VM");
                return;
            }
            for (BComponent component : allComponents = station.getComponentSpace().getAllComponents()) {
                component.fw(32);
            }
            out.w("Hogs data reset");
        }
    }

    public class ResetPeakScanTime
    extends Spy {
        @Override
        public void write(SpyWriter out) throws Exception {
            BStation station = Sys.getStation();
            if (station == null) {
                out.w("Not station VM");
                return;
            }
            EngineManager.this.resetEngineStats();
            out.w("Peak Scan Time reset");
        }
    }

    public class HogsPage
    extends Spy {
        @Override
        public void write(SpyWriter out) throws Exception {
            int i;
            BStation station = Sys.getStation();
            if (station == null) {
                out.w("Not station VM");
                return;
            }
            Object[] c = station.getComponentSpace().getAllComponents();
            Object[] t = new Long[c.length];
            Long zero = 0L;
            for (i = 0; i < c.length; ++i) {
                t[i] = (Long)((BObject)c[i]).fw(22);
                if (t[i] != null) continue;
                t[i] = zero;
            }
            SortUtil.sort((Object[])t, (Object[])c, (boolean)false);
            out.startTable(true);
            out.trTitle("Engine Hogs", 4);
            out.w("<tr>").th("Rank").th("Component").th("Type").th("Total Time").th("Total Count").th("Avg time").w("</tr>\n");
            for (i = 0; i < 100 && i < c.length; ++i) {
                Object comp = c[i];
                if (Objects.equals(t[i], zero)) break;
                long time = (Long)t[i];
                Long xcount = (Long)((BObject)c[i]).fw(31);
                long xc = xcount;
                long avg = 0L;
                avg = xc == 0L ? 0L : time / xc;
                out.tr("" + i, ((BComponent)comp).toPathString(), ((BComponent)comp).getType(), EngineManager.timeStr(time / 1000000L), xcount.toString(), avg / 1000L + " us");
            }
            out.endTable();
        }
    }

    public class AsyncQueuePage
    extends Spy {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(SpyWriter out) throws Exception {
            out.startTable(true);
            out.trTitle("Async Action Queue", 2);
            out.w("<tr>").th("Component").th("Action").w("</tr>\n");
            ActionQueue actionQueue = EngineManager.this.actionQueue;
            synchronized (actionQueue) {
                int count = 0;
                Iterator<ActionQueue.Entry> it = EngineManager.this.actionQueue.iterator();
                while (it.hasNext()) {
                    if (++count > 1000) {
                        out.tr("more...", "");
                        break;
                    }
                    ActionQueue.Entry entry = it.next();
                    out.tr(entry.component.toDebugString(), entry.action);
                }
            }
            out.endTable();
        }
    }

    public class TicketQueuePage
    extends Spy {
        TicketQueue q;

        TicketQueuePage(TicketQueue q) {
            this.q = q;
        }

        @Override
        public void write(SpyWriter out) throws Exception {
            out.startTable(true);
            out.trTitle("Timer Clock.Ticket Queue: " + BAbsTime.make(), 6);
            out.w("<tr>").th("Mode").th("Next Update").th("Period").th("Component").th("Action").th("ActionArg").w("</tr>\n");
            int count = 0;
            NClockTicket ticket = this.q.head;
            while (ticket != null) {
                long left = ticket.millisLeft();
                if (++count > 1000) {
                    out.tr("more...", "", "", "", "", "");
                    break;
                }
                out.tr(ticket.nextUpdate < 0L ? "ticks" : "millis", EngineManager.timeStr(left), "" + ticket.period, ticket.component.toDebugString(), ticket.action, ticket.arg);
                ticket = ticket.next;
            }
            out.endTable();
        }
    }

    public class SummaryPage
    extends SpyDir {
        @Override
        public Spy find(String name) {
            if (SpyWriter.verifyNameAndCsrfToken(name, "resetHogs")) {
                return super.find("resetHogs");
            }
            if (SpyWriter.verifyNameAndCsrfToken(name, "resetPeakScanTime")) {
                return super.find("resetPeakScanTime");
            }
            return super.find(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(SpyWriter out) throws Exception {
            double avg = (double)EngineManager.this.totalTicksInsideScan / (double)EngineManager.this.scanCount;
            double last10Avg = (double)EngineManager.this.deltaTicksInsideScan / 10.0;
            BComponent curComp = EngineManager.this.currentComponent;
            Action curAction = EngineManager.this.currentAction;
            out.startProps();
            out.prop((Object)"atSteadyState", Sys.atSteadyState());
            out.prop((Object)"suspended", "" + EngineManager.this.suspended);
            out.prop((Object)"scanCount", "" + EngineManager.this.scanCount);
            out.prop((Object)"runtime", EngineManager.timeStr(Clock.ticks() - EngineManager.this.startTicks));
            out.prop((Object)"totalTicksInsideScan", EngineManager.timeStr(EngineManager.this.totalTicksInsideScan));
            out.prop((Object)"averageTime/scan", avg + "ms");
            out.prop((Object)"averageTimeLast10Scan", last10Avg + "ms");
            out.trTitle("Peak Scan Stats (time in scan)", 2);
            BFacets showMsFacets = BFacets.make("showMilliseconds", true);
            int i = 0;
            LinkedList linkedList = EngineManager.this.peakScanStats;
            synchronized (linkedList) {
                for (EngineStats stats : EngineManager.this.peakScanStats) {
                    out.prop((Object)("engine.scan.peak[" + i + "]"), EngineManager.timeStr(stats.getTicks()) + " @ " + stats.getTime().toString(showMsFacets));
                    ++i;
                }
            }
            out.trTitle("Peak Interscan Stats (time in between scans)", 2);
            i = 0;
            linkedList = EngineManager.this.peakInterscanStats;
            synchronized (linkedList) {
                for (EngineStats stats : EngineManager.this.peakInterscanStats) {
                    out.prop((Object)("engine.scan.peakInterscan[" + i + "]"), EngineManager.timeStr(stats.getTicks()) + " @ " + stats.getTime().toString(showMsFacets));
                    ++i;
                }
            }
            out.trTitle("Actions", 2);
            out.prop((Object)"currentComponent", curComp == null ? "null" : curComp.toDebugString());
            out.prop((Object)"currentAction", curAction);
            out.propNameLink("asyncQueue", "Async ActionQueue", EngineManager.this.actionQueue.size() + " (Peak " + EngineManager.this.actionQueue.peak() + ")");
            out.propNameLink("hogs", "Engine Hogs", "");
            out.prop((Object)"", () -> out.mutatorButton("resetHogs", "Reset Engine Hogs"));
            out.prop((Object)"", () -> out.mutatorButton("resetPeakScanTime", "Reset Peak Scan Time"));
            out.trTitle("Short Timers (" + shortTimerThreshold + "ms or less)", 2);
            EngineManager.this.shortTimers.writeSummary(out, "shortTimers");
            out.trTitle("Medium Timers (" + shortTimerThreshold + "ms to " + mediumTimerThreshold + "ms)", 2);
            EngineManager.this.mediumTimers.writeSummary(out, "mediumTimers");
            out.trTitle("Long Timers (" + mediumTimerThreshold + "ms or greater)", 2);
            EngineManager.this.longTimers.writeSummary(out, "longTimers");
            out.endProps();
        }
    }
}

