/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys;

import com.tridium.nre.platform.IPlatformProvider;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.nre.util.IPAddressUtil;
import java.net.InetAddress;
import java.security.AccessController;

public class NreLib {
    private static final boolean NIAGARA_IPV6_ENABLED = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.ipv6Enabled"));

    public static void dumpThreads() {
        PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.dumpThreads();
    }

    public static String getHostId() {
        return PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.getHostId();
    }

    public static String getHostModel() {
        return PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.getHostModel();
    }

    public static String getHostModelVersion() {
        return PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.getHostModelVersion();
    }

    public static String getHostProduct() {
        return PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.getHostProduct();
    }

    public static String getenv(String name) {
        return AccessController.doPrivileged(() -> System.getenv(name));
    }

    public static InetAddress getLocalHost() {
        return NreLib.getLocalHost(NIAGARA_IPV6_ENABLED);
    }

    public static InetAddress getLocalHost(boolean isIPv6) {
        return IPAddressUtil.getLocalHost((boolean)isIPv6);
    }

    public static String getHostName() {
        return IPAddressUtil.getHostName();
    }

    public static InetAddress getLocalHost(InetAddress hintAddress) {
        return IPAddressUtil.getLocalHost((InetAddress)hintAddress);
    }

    private static final class PlatformProviderHolder {
        private static final IPlatformProvider PLATFORM_PROVIDER_INSTANCE = AccessController.doPrivileged(PlatformUtil::getPlatformProvider);

        private PlatformProviderHolder() {
        }
    }
}

