/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.session;

import com.tridium.authn.LoginFailureCause;
import com.tridium.session.NiagaraSession;
import com.tridium.session.SessionManager;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.baja.session.CsrfException;
import javax.baja.session.INiagaraSuperSession;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.user.BAutoLogoffSettings;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.security.auth.Subject;

public class NiagaraSuperSession
implements INiagaraSuperSession {
    public static final int CSRF_TOKEN_BIT_LEN = 192;
    private static final SecureRandom rand = new SecureRandom();
    private boolean invalidating = false;
    private String sessionId;
    private String csrfToken = null;
    private final String remoteHost;
    private final long creationTime;
    private Set<NiagaraSession> sessions = null;
    private NiagaraSession masterSession = null;
    private AuthenticationInfo authnInfo = new AuthenticationInfo();
    private ScheduledFuture<?> timeoutScheduledFuture;
    private volatile long logoffPeriod = -1L;
    long lastActivity = Long.MIN_VALUE;
    private final Set<Object> pauseSet = Collections.synchronizedSet(new HashSet());
    private static final ThreadFactory daemonThreadFactory = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            t.setName("SessionTimeout");
            return t;
        }
    };
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(daemonThreadFactory);

    protected NiagaraSuperSession(String sessionId, String remoteHost) {
        if (!SessionManager.idReserved(sessionId)) {
            throw new IllegalArgumentException("Cannot create new NiagaraSuperSession: requested sessionId has not been reserved.");
        }
        this.sessionId = sessionId;
        this.remoteHost = remoteHost;
        this.creationTime = System.currentTimeMillis();
        this.sessions = new HashSet<NiagaraSession>();
    }

    public void addSession(NiagaraSession session) {
        if (!this.sessionId.equals(session.getSuperId())) {
            throw new IllegalArgumentException("Cannot add NiagaraSession to NiagaraSuperSession: session IDs do not match.");
        }
        if (!this.sessions.contains(session)) {
            if (this.sessions.isEmpty()) {
                this.masterSession = session;
            }
            this.sessions.add(session);
        }
    }

    protected boolean removeSession(NiagaraSession session) {
        if (!this.sessionId.equals(session.getSuperId())) {
            throw new IllegalArgumentException("Cannot remove NiagaraSession from NiagaraSuperSession: session IDs do not match.");
        }
        boolean removed = this.sessions.remove(session);
        if (this.sessions.isEmpty() || session.equals(this.masterSession)) {
            this.invalidate();
        }
        return removed;
    }

    protected void invalidate() {
        this.invalidate(null);
    }

    protected void invalidate(LoginFailureCause cause) {
        Object[] sessArray;
        if (this.invalidating) {
            return;
        }
        this.invalidating = true;
        for (Object session : sessArray = this.sessions.toArray()) {
            ((NiagaraSession)session).invalidate(cause);
        }
        SessionManager.removeSession(this);
    }

    protected boolean isValid() {
        return !this.invalidating;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.sessionId;
    }

    public <T extends NiagaraSession> T getSession(Class<T> t) {
        if (this.sessions == null || this.sessions.isEmpty()) {
            return null;
        }
        for (NiagaraSession session : this.sessions) {
            if (!t.isInstance(session)) continue;
            NiagaraSession x = session;
            return (T)x;
        }
        return null;
    }

    public Set<NiagaraSession> getSessions() {
        return this.sessions;
    }

    void setAuthentication(Subject subject) {
        if (subject != null && BUser.getUserFromSubject(subject) != null) {
            this.authnInfo.authenticated = true;
        } else {
            this.authnInfo.authenticated = false;
        }
        this.authnInfo.subject = subject;
        this.logoffPeriod = this.getLogoffPeriod();
        this.resetSessionTimeout();
        this.scheduleTimeout();
    }

    boolean isAuthenticated() {
        return this.authnInfo.authenticated && this.authnInfo.subject != null;
    }

    Subject getAuthenticatedSubject() {
        if (this.authnInfo.authenticated) {
            return this.authnInfo.subject;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCsrfToken() {
        NiagaraSuperSession niagaraSuperSession = this;
        synchronized (niagaraSuperSession) {
            if (this.csrfToken == null) {
                byte[] bytes = new byte[24];
                rand.nextBytes(bytes);
                this.csrfToken = Base64.getEncoder().encodeToString(bytes);
            }
            return this.csrfToken;
        }
    }

    @Override
    public void verifyCsrfToken(String srcCsrfToken) throws CsrfException {
        if (Objects.isNull(srcCsrfToken) || Objects.isNull(this.csrfToken)) {
            throw new CsrfException("csrf token missing");
        }
        if (!this.csrfToken.equals(srcCsrfToken)) {
            throw new CsrfException("invalid csrf token");
        }
    }

    long getSessionTimeRemaining() {
        if (!this.pauseSet.isEmpty()) {
            return this.logoffPeriod;
        }
        if (this.logoffPeriod == -1L) {
            return -1L;
        }
        return Math.max(this.logoffPeriod - Clock.ticks() + this.lastActivity, 0L);
    }

    void resetSessionTimeout() {
        this.resetSessionTimeout(0L);
    }

    void resetSessionTimeout(long offset) {
        this.lastActivity = Math.max(Clock.ticks() - Math.max(offset, 0L), this.lastActivity);
    }

    Object pauseSessionTimeout() {
        Object token = new Object();
        this.pauseSet.add(token);
        return token;
    }

    void resumeSessionTimeout(Object token) {
        this.pauseSet.remove(token);
        if (this.pauseSet.isEmpty()) {
            this.resetSessionTimeout();
        }
    }

    long getLastActivity() {
        return this.lastActivity;
    }

    private long getLogoffPeriod() {
        BRelTime logoffPeriod;
        for (NiagaraSession session : this.sessions) {
            if (!session.getAutoLogoffDisabled()) continue;
            return -1L;
        }
        BUser user = BUser.getUserFromSubject(this.getAuthenticatedSubject());
        if (user == null) {
            return -1L;
        }
        BAutoLogoffSettings settings = user.getAutoLogoffSettings();
        if (!settings.getAutoLogoffEnabled()) {
            return -1L;
        }
        if (settings.getUseDefaultAutoLogoffPeriod()) {
            try {
                BUserService service = (BUserService)Sys.getService(BUserService.TYPE);
                logoffPeriod = service.getDefaultAutoLogoffPeriod();
            }
            catch (ServiceNotFoundException e) {
                logoffPeriod = settings.getAutoLogoffPeriod();
            }
        } else {
            logoffPeriod = settings.getAutoLogoffPeriod();
        }
        return logoffPeriod.getMillis();
    }

    void updateSessionTimeout() {
        long lastLogoffPeriod = this.logoffPeriod;
        this.logoffPeriod = this.getLogoffPeriod();
        this.resetSessionTimeout();
        if (this.logoffPeriod < lastLogoffPeriod && this.logoffPeriod > -1L) {
            if (this.timeoutScheduledFuture != null) {
                this.timeoutScheduledFuture.cancel(false);
            }
            this.scheduleTimeout();
        }
    }

    private void scheduleTimeout() {
        long timeout = this.getSessionTimeRemaining();
        if (timeout > 0L) {
            SessionTimeoutRunnable runnable = new SessionTimeoutRunnable();
            this.timeoutScheduledFuture = executor.schedule(runnable, timeout, TimeUnit.MILLISECONDS);
        }
    }

    private class SessionTimeoutRunnable
    implements Runnable {
        private SessionTimeoutRunnable() {
        }

        @Override
        public void run() {
            if (!NiagaraSuperSession.this.isValid()) {
                return;
            }
            if (NiagaraSuperSession.this.getSessionTimeRemaining() == 0L) {
                NiagaraSuperSession.this.invalidate(LoginFailureCause.SESSION_TIMEOUT);
            } else {
                NiagaraSuperSession.this.scheduleTimeout();
            }
        }
    }

    private class AuthenticationInfo {
        private Subject subject = null;
        private boolean authenticated = false;

        private AuthenticationInfo() {
        }
    }
}

