/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import com.tridium.nre.security.policy.NiagaraPermissionGroup;
import com.tridium.nre.security.policy.ParsingException;
import com.tridium.nre.util.TextExpander;
import com.tridium.security.BasePermissionGroup;
import java.io.File;
import java.io.FilePermission;
import java.security.AccessController;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;

public class RuntimeExecPermissionGroup
extends BasePermissionGroup {
    protected static final RuntimeExecPermissionGroup DUMMY = new RuntimeExecPermissionGroup();
    public static final String TYPE = "RUNTIME_EXECUTION";
    private Map<String, String> savedParameters;
    private static final String FILES_XML = "files";
    private static final String FILES_KEY = "permissions.runtimeExec.files";
    private static final String RISK_KEY = "permissions.runtimeExec.riskDescription";
    private final Set<Permission> permissions;
    private static final List<BasePermissionGroup.ParameterInfo> parameterInfoList = new ArrayList<BasePermissionGroup.ParameterInfo>();
    private static final TextExpander expander;

    private RuntimeExecPermissionGroup() {
        super(NiagaraPermissionGroup.RiskLevel.SEVERE, EnumSet.noneOf(NiagaraPermissionGroup.Flags.class), RISK_KEY);
        this.permissions = new HashSet<Permission>();
    }

    protected RuntimeExecPermissionGroup(String purposeKey, EnumSet<NiagaraPermissionGroup.Flags> flags, Map<String, String> parameters) throws ParsingException {
        super(NiagaraPermissionGroup.RiskLevel.SEVERE, flags, purposeKey, parameters, RISK_KEY);
        this.savedParameters = new HashMap<String, String>(parameters);
        this.permissions = new HashSet<Permission>();
        String files = parameters.get(FILES_XML);
        try {
            if (files != null && files.contains("${") && files.contains("}")) {
                files = expander.expand(files);
            }
            Arrays.asList(files.split(File.pathSeparator)).forEach(name -> {
                if (name != null && !name.isEmpty()) {
                    this.permissions.add(new FilePermission(name.trim(), "execute"));
                }
            });
        }
        catch (IllegalArgumentException | NoSuchElementException e) {
            throw new ParsingException("Could not parse file path: path could not be expanded: " + e.getMessage(), (Throwable)e);
        }
    }

    public String getType() {
        return TYPE;
    }

    public Set<Permission> getImpliedPermissions() {
        return this.permissions;
    }

    protected NiagaraPermissionGroup copy() {
        try {
            return new RuntimeExecPermissionGroup(this.requestingModuleName + ":" + this.purposeKey, (EnumSet<NiagaraPermissionGroup.Flags>)this.getFlags(), this.savedParameters);
        }
        catch (ParsingException parsingException) {
            return null;
        }
    }

    @Override
    public List<BasePermissionGroup.ParameterInfo> getParameterInfo() {
        return parameterInfoList;
    }

    private static String mapper(String key) {
        if ("/".equals(key)) {
            return File.separator;
        }
        if (":".equals(key)) {
            return File.pathSeparator;
        }
        String propertyValue = AccessController.doPrivileged(() -> System.getProperty(key));
        return Optional.ofNullable(propertyValue).orElseThrow(() -> new NoSuchElementException(key + " not found"));
    }

    static {
        parameterInfoList.add(new BasePermissionGroup.ParameterInfo(FILES_XML, FILES_KEY, "Files"));
        expander = new TextExpander(RuntimeExecPermissionGroup::mapper);
    }
}

