/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import com.tridium.nre.security.policy.NiagaraPermissionGroup;
import com.tridium.nre.security.policy.ParsingException;
import com.tridium.security.BasePermissionGroup;
import java.security.Permission;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.management.MBeanPermission;
import javax.management.MBeanServerPermission;
import javax.management.MBeanTrustPermission;

public final class MBeanPermissionGroup
extends BasePermissionGroup {
    protected static final MBeanPermissionGroup DUMMY = new MBeanPermissionGroup();
    public static final String TYPE = "MBEAN_PERMISSION";
    private static final String RISK_KEY = "permissions.mbean.riskDescription";
    private static final String SERVER_TYPE = "server";
    private static final String TRUST_TYPE = "trust";
    private static final String BEAN_TYPE = "bean";
    private static final String TYPE_XML = "type";
    private static final String CLASS_NAME_XML = "className";
    private static final String MEMBER_XML = "member";
    private static final String OBJECT_NAME_XML = "objectName";
    private static final String ACTIONS_XML = "actions";
    private static final String TYPE_KEY = "permissions.mbean.type";
    private static final String CLASS_NAME_KEY = "permissions.mbean.className";
    private static final String MEMBER_KEY = "permissions.mbean.member";
    private static final String OBJECT_NAME_KEY = "permissions.mbean.objectName";
    private static final String ACTIONS_KEY = "permissions.mbean.actions";
    private static final List<BasePermissionGroup.ParameterInfo> parameterInfoList = Arrays.asList(new BasePermissionGroup.ParameterInfo("type", "permissions.mbean.type", "Type"), new BasePermissionGroup.ParameterInfo("className", "permissions.mbean.className", "Class Name"), new BasePermissionGroup.ParameterInfo("member", "permissions.mbean.member", "Member"), new BasePermissionGroup.ParameterInfo("objectName", "permissions.mbean.objectName", "Object Name"), new BasePermissionGroup.ParameterInfo("actions", "permissions.mbean.actions", "Actions"));
    private static final Set<String> mBeanPermissionActionsWhitelist = new TreeSet<String>(Arrays.asList("addNotificationListener", "getAttribute", "getDomains", "getMBeanInfo", "getObjectInstance", "instantiate", "invoke", "isInstanceOf", "queryMBeans", "queryNames", "registerMBean", "removeNotificationListener", "setAttribute", "unregisterMBean"));
    private final Set<Permission> permissions = new HashSet<Permission>();
    private static Logger logger = Logger.getLogger("security.niagaraPolicy.permissions");

    private MBeanPermissionGroup() {
        super(NiagaraPermissionGroup.RiskLevel.SEVERE, EnumSet.noneOf(NiagaraPermissionGroup.Flags.class), RISK_KEY);
    }

    protected MBeanPermissionGroup(String purposeKey, EnumSet<NiagaraPermissionGroup.Flags> flags, Map<String, String> parameters) throws ParsingException {
        super(NiagaraPermissionGroup.RiskLevel.SEVERE, flags, purposeKey, parameters, RISK_KEY);
        String type = parameters.get(TYPE_XML);
        if (type == null) {
            type = BEAN_TYPE;
        }
        switch (type.toLowerCase(Locale.ENGLISH)) {
            case "server": {
                this.permissions.add(new MBeanServerPermission("createMBeanServer"));
                this.permissions.add(new MBeanServerPermission("releaseMBeanServer"));
                break;
            }
            case "trust": {
                this.permissions.add(new MBeanTrustPermission("register"));
                break;
            }
            case "bean": {
                String objectName;
                String member;
                String actions = parameters.get(ACTIONS_XML);
                if (actions == null) {
                    throw new ParsingException("Missing parameter <actions> for <MBEAN_PERMISSION> permission group");
                }
                Set invalidActions = Arrays.asList((actions = actions.replaceAll("\\s+", "")).split(",")).stream().filter(action -> !mBeanPermissionActionsWhitelist.contains(action)).collect(Collectors.toCollection(TreeSet::new));
                if (!invalidActions.isEmpty()) {
                    throw new ParsingException("Invalid action(s) " + invalidActions + " for <" + TYPE + ">. Valid actions are " + mBeanPermissionActionsWhitelist);
                }
                String className = parameters.get(CLASS_NAME_XML);
                if (className == null) {
                    className = "-";
                }
                if ((member = parameters.get(MEMBER_XML)) == null) {
                    member = "-";
                }
                if ((objectName = parameters.get(OBJECT_NAME_XML)) == null) {
                    objectName = "-";
                }
                String permissionName = className + "#" + member + "[" + objectName + "]";
                try {
                    MBeanPermission permission = new MBeanPermission(permissionName, actions);
                    this.permissions.add(permission);
                    break;
                }
                catch (Throwable t) {
                    throw new ParsingException("\n\t" + t.getMessage() + " for <" + TYPE + "> permission group\n\tClassName=" + className + " Member=" + member + " ObjectName=" + objectName + " Actions=" + actions);
                }
            }
            default: {
                throw new ParsingException("Invalid parameter <type = " + type + "> for <" + TYPE + "> permission group");
            }
        }
    }

    public String getType() {
        return TYPE;
    }

    public Set<Permission> getImpliedPermissions() {
        return this.permissions;
    }

    protected NiagaraPermissionGroup copy() {
        try {
            return new MBeanPermissionGroup(this.requestingModuleName + ":" + this.purposeKey, (EnumSet<NiagaraPermissionGroup.Flags>)this.getFlags(), this.parameters);
        }
        catch (ParsingException parsingException) {
            return null;
        }
    }

    public boolean requiresSignature() {
        return true;
    }

    @Override
    public List<BasePermissionGroup.ParameterInfo> getParameterInfo() {
        return parameterInfoList;
    }
}

