/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.collection;

import com.tridium.collection.EmptyColumnList;
import java.util.List;
import javax.baja.collection.AbstractRow;
import javax.baja.collection.AbstractTableCursor;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Row;
import javax.baja.collection.TableCursor;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BListTable<T extends BIObject>
extends BObject
implements BIRandomAccessTable<T> {
    @Generated
    public static final Type TYPE = Sys.loadType(BListTable.class);
    private static final ColumnList EMPTY = new EmptyColumnList();
    private final List<T> rowObjects;
    private final Context cursorContext;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BListTable(List<T> rowObjects) {
        this(rowObjects, Context.NULL);
    }

    public BListTable(List<T> rowObjects, Context cursorContext) {
        this.rowObjects = rowObjects;
        this.cursorContext = cursorContext;
    }

    @Override
    public Row<T> get(int row) {
        return new AbstractRow<T>(this, (BIObject)this.rowObjects.get(row)){

            @Override
            public BIObject cell(Column column) {
                throw new IllegalStateException("list table has no columns");
            }

            @Override
            public Row<T> safeCopy() {
                return this;
            }
        };
    }

    @Override
    public int size() {
        return this.rowObjects.size();
    }

    @Override
    public TableCursor<T> cursor() {
        return new AbstractTableCursor<T>(this){
            int i;
            {
                this.i = -1;
            }

            @Override
            protected boolean advanceCursor() {
                if (this.i < BListTable.this.size()) {
                    ++this.i;
                }
                return this.i < BListTable.this.size();
            }

            @Override
            public Row<T> row() {
                return BListTable.this.get(this.i);
            }

            @Override
            public Context getContext() {
                return BListTable.this.cursorContext;
            }
        };
    }

    @Override
    public final ColumnList getColumns() {
        return EMPTY;
    }

    @Override
    public BFacets getTableFacets() {
        return BFacets.NULL;
    }
}

