/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.authn;

import com.tridium.authn.NiagaraFailedLoginException;
import com.tridium.authn.NiagaraLoginModule;
import com.tridium.authn.SessionIdCallback;
import com.tridium.session.NiagaraSession;
import com.tridium.session.SessionManager;
import java.security.AccessController;
import java.util.logging.Level;
import javax.baja.authn.AuthenticationUtil;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;

public class SessionIdLoginModule
extends NiagaraLoginModule {
    private String superSessionId;
    private NiagaraSession session;

    @Override
    public boolean login() throws LoginException {
        FailedLoginException e;
        String username;
        if (this.callbackHandler == null) {
            throw new LoginException("CallbackHandler cannot be null for sessionId login");
        }
        Callback[] callbacks = new Callback[]{new SessionIdCallback()};
        try {
            this.callbackHandler.handle(callbacks);
            this.session = ((SessionIdCallback)callbacks[0]).getSession();
            this.superSessionId = ((SessionIdCallback)callbacks[0]).getSessionId();
            username = ((SessionIdCallback)callbacks[0]).getUsername();
        }
        catch (UnsupportedCallbackException e2) {
            String msg = "Provided callback handler could not handle: " + e2.getCallback().toString();
            AuthenticationUtil.debug(Level.SEVERE, msg, e2);
            throw new LoginException(msg);
        }
        catch (Exception e3) {
            String msg = "Error handling callbacks:" + e3.toString();
            AuthenticationUtil.debug(Level.SEVERE, msg, e3);
            throw new LoginException(msg);
        }
        this.user = AccessController.doPrivileged(() -> SessionManager.getAuthenticatedUserFromSession(this.superSessionId));
        if (this.user != null && this.user.getUsername().equals(username)) {
            this.succeeded = true;
            return true;
        }
        if (this.user != null) {
            e = new NiagaraFailedLoginException(this.user.getName(), "Login failed: Invalid username or password.");
            this.user = null;
        } else {
            e = new FailedLoginException("Login failed: Invalid username or password.");
        }
        throw e;
    }

    @Override
    public boolean commit() throws LoginException {
        try {
            SessionManager.changeSuperSessionId(this.session, this.superSessionId);
        }
        catch (SecurityException e) {
            throw new LoginException("SessionId LoginModule commit failed. Cause is: " + e.toString());
        }
        return super.commit();
    }
}

