/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.ui.region;

import com.tridium.aapup.BPupDevice;
import com.tridium.aapup.datatypes.BDownloadRegionParams;
import com.tridium.aapup.datatypes.BPupRegionRecord;
import com.tridium.aapup.datatypes.BUploadRegionParams;
import com.tridium.aapup.job.BPupDownloadRegionJob;
import com.tridium.aapup.job.BPupLearnRegionsJob;
import com.tridium.aapup.job.BPupUploadRegionJob;
import com.tridium.aapup.util.AaPupSplUtil;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.job.BJobBar;
import java.io.IOException;
import java.util.Vector;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"aapup:PupDevice"})})
public class BPupRegionManager
extends BWbComponentView {
    @Generated
    public static final Type TYPE = Sys.loadType(BPupRegionManager.class);
    static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BPupRegionManager.class);
    static final BImage icon = BImage.make((String)"module://icons/x16/backup.png");
    BJobBar jobBar;
    BTable table;
    DiscoverRegions cmdDiscoverRegions = new DiscoverRegions((BWidget)this);
    DownloadProgram cmdDownloadProgram = new DownloadProgram((BWidget)this);
    UploadProgram cmdUploadProgram = new UploadProgram((BWidget)this);
    FreeRegion cmdFreeRegion = new FreeRegion((BWidget)this);
    UnlockRegion cmdUnlockRegion = new UnlockRegion((BWidget)this);
    BPupDevice device;
    BPupRegionRecord[] recs;
    static BOrd defaultDir = null;
    boolean discRegionsJobComplete = false;
    boolean downloadJobComplete = false;
    boolean uploadJobComplete = false;
    Vector<BPupRegionRecord> discoveredRegions = new Vector();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPupRegionManager() {
        this.jobBar = new BJobBar();
        this.attach((BWbComponentView.Attachable)this.jobBar);
        BBorderPane jobPane = new BBorderPane((BWidget)this.jobBar, BBorder.solid, BInsets.make((double)0.0, (double)5.0, (double)0.0, (double)5.0));
        jobPane.setFill(Theme.widget().getWindowBackground());
        jobPane = new BBorderPane((BWidget)jobPane, BBorder.inset, BInsets.DEFAULT);
        this.table = new BTable((TableModel)new Model());
        this.table.setMultipleSelection(false);
        this.table.setSelection((TableSelection)new Selection());
        BTitlePane tablePane = BTitlePane.makePane((String)lexicon.getText("region.manager.title"), (BTable)this.table);
        BGridPane buttonPane = new BGridPane();
        buttonPane.setColumnCount(5);
        buttonPane.add(null, (BValue)new BButton((Command)this.cmdDiscoverRegions));
        buttonPane.add(null, (BValue)new BButton((Command)this.cmdDownloadProgram));
        buttonPane.add(null, (BValue)new BButton((Command)this.cmdUploadProgram));
        buttonPane.add(null, (BValue)new BButton((Command)this.cmdFreeRegion));
        buttonPane.add(null, (BValue)new BButton((Command)this.cmdUnlockRegion));
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BBorderPane((BWidget)jobPane, BInsets.make((double)0.0, (double)0.0, (double)5.0, (double)0.0)));
        edge.setCenter((BWidget)tablePane);
        edge.setBottom((BWidget)new BBorderPane((BWidget)buttonPane, 10.0, 0.0, 0.0, 0.0));
        this.setContent((BWidget)edge);
        this.registerForComponentEvents((BComponent)this.table);
    }

    public void doLoadValue(BObject object, Context cx) {
        this.device = (BPupDevice)object;
        this.reload();
    }

    public void handleComponentEvent(BComponentEvent event) {
        super.handleComponentEvent(event);
        DiscoverRegions discReg = this.cmdDiscoverRegions;
        BJob discRegJob = discReg.getJob();
        if (discRegJob != null & event.getSourceComponent() == discRegJob) {
            String slotName;
            if (event.getId() == 5 && "regionLearned".equalsIgnoreCase(slotName = event.getSlotName())) {
                BPupRegionRecord value = (BPupRegionRecord)event.getValue();
                this.discoveredRegions.addElement(value);
                this.reload();
            }
            if (discRegJob.getJobState().isComplete() && !this.discRegionsJobComplete) {
                this.discRegionsJobComplete = true;
                this.reload();
            }
            return;
        }
        DownloadProgram dlReg = this.cmdDownloadProgram;
        BJob dlRegJob = dlReg.getJob();
        if (dlRegJob != null & event.getSourceComponent() == dlRegJob) {
            if (dlRegJob.getJobState().isComplete() && !this.downloadJobComplete) {
                this.downloadJobComplete = true;
                this.reload();
            }
            return;
        }
        UploadProgram ulReg = this.cmdUploadProgram;
        BJob ulRegJob = ulReg.getJob();
        if (ulRegJob != null & event.getSourceComponent() == ulRegJob) {
            if (!ulRegJob.getJobState().equals((Object)BJobState.running) && !this.uploadJobComplete) {
                BFoxSession session = (BFoxSession)BOrd.toSession((BObject)ulRegJob);
                session.getConnection().getChannels().getFileChannel().fw(902, (Object)BPupRegionManager.toFilePath(defaultDir), null, null, null);
                this.uploadJobComplete = true;
                this.reload();
            }
            return;
        }
        if (event.getSourceComponent() == this.device) {
            if (event.getId() == 5) {
                String slotName = event.getSlotName();
                if (slotName == "tableUpdated") {
                    this.reload();
                } else if (slotName == "regionChanged") {
                    this.cmdDiscoverRegions.invoke();
                }
            }
            return;
        }
    }

    public void reload() {
        this.recs = new BPupRegionRecord[this.discoveredRegions.size()];
        this.discoveredRegions.copyInto(this.recs);
        this.table.getModel().updateTable();
        this.updateCommands();
    }

    private void disableCommands() {
        this.cmdDiscoverRegions.setEnabled(false);
        this.cmdDownloadProgram.setEnabled(false);
        this.cmdUploadProgram.setEnabled(false);
        this.cmdFreeRegion.setEnabled(false);
        this.cmdUnlockRegion.setEnabled(false);
    }

    private void updateCommands() {
        boolean discoverJobRunning = this.cmdDiscoverRegions.getJob() != null & !this.discRegionsJobComplete;
        boolean downloadJobRunning = this.cmdDownloadProgram.getJob() != null & !this.downloadJobComplete;
        boolean uploadJobRunning = this.cmdUploadProgram.getJob() != null & !this.uploadJobComplete;
        if (discoverJobRunning || downloadJobRunning || uploadJobRunning) {
            this.disableCommands();
            return;
        }
        int selectionRowCount = this.table.getSelection().getRowCount();
        int modelRowCount = this.table.getModel().getRowCount();
        this.cmdDiscoverRegions.setEnabled(true);
        this.cmdDownloadProgram.setEnabled(modelRowCount > 0);
        if (selectionRowCount == 1) {
            int row = this.table.getSelection().getRow();
            BString regionName = (BString)this.table.getModel().getValueAt(row, 6);
            BBoolean regionLock = (BBoolean)this.table.getModel().getValueAt(row, 9);
            this.cmdUploadProgram.setEnabled(regionName.getString() != "");
            this.cmdFreeRegion.setEnabled(regionName.getString() != "");
            this.cmdUnlockRegion.setEnabled(regionLock.getBoolean());
        } else {
            this.cmdUploadProgram.setEnabled(false);
            this.cmdFreeRegion.setEnabled(false);
            this.cmdUnlockRegion.setEnabled(false);
        }
    }

    static FilePath toFilePath(BOrd ord) {
        OrdQuery[] q = ord.parse();
        for (int i = 0; i < q.length; ++i) {
            if (!(q[i] instanceof FilePath)) continue;
            return (FilePath)q[i];
        }
        throw new IllegalStateException();
    }

    class UnlockRegion
    extends Command {
        UnlockRegion(BWidget owner) {
            super(owner, (Lexicon)lexicon, "region.manager.unlockRegion");
        }

        public CommandArtifact doInvoke() throws Exception {
            int row = BPupRegionManager.this.table.getSelection().getRow();
            BInteger regionNum = (BInteger)BPupRegionManager.this.table.getModel().getValueAt(row, 4);
            int answer = BDialog.confirm((BWidget)BPupRegionManager.this, (Object)("Unlock region " + regionNum.getInt() + " ?"));
            if (answer == 8) {
                return null;
            }
            BPupRegionManager.this.device.getComponentSpace().sync();
            BPupRegionManager.this.device.lease(2, 60000L);
            BPupRegionManager.this.device.unlockRegion(regionNum);
            return null;
        }
    }

    class FreeRegion
    extends Command {
        FreeRegion(BWidget owner) {
            super(owner, (Lexicon)lexicon, "region.manager.freeRegion");
        }

        public CommandArtifact doInvoke() throws Exception {
            int[] rows = BPupRegionManager.this.table.getSelection().getRows();
            if (rows.length != 1) {
                return null;
            }
            BInteger regionNum = (BInteger)BPupRegionManager.this.table.getModel().getValueAt(rows[0], 4);
            int answer = BDialog.confirm((BWidget)BPupRegionManager.this, (Object)("Free region " + regionNum.getInt() + " ?"));
            if (answer == 8) {
                return null;
            }
            BPupRegionManager.this.device.lease();
            BPupRegionManager.this.device.freeRegion(regionNum);
            return null;
        }
    }

    class UploadProgram
    extends Command {
        private BPupUploadRegionJob job;

        UploadProgram(BWidget owner) {
            super(owner, (Lexicon)lexicon, "region.manager.upload");
        }

        public CommandArtifact doInvoke() throws Exception {
            int row = BPupRegionManager.this.table.getSelection().getRow();
            BString regionName = (BString)BPupRegionManager.this.table.getModel().getValueAt(row, 6);
            BInteger regionNumber = (BInteger)BPupRegionManager.this.table.getModel().getValueAt(row, 4);
            BInteger regionSize = (BInteger)BPupRegionManager.this.table.getModel().getValueAt(row, 7);
            BUploadRegionParams config = new BUploadRegionParams();
            config.setRegionName(regionName.getString());
            config.setRegionNumber(regionNumber.getInt());
            config.setRegionSize(regionSize.getInt());
            String fileName = "Upload of " + regionName.getString() + ".PLB";
            if (defaultDir == null) {
                FilePath dirPath = new FilePath("!spl_backups");
                defaultDir = BOrd.make((OrdQuery)dirPath);
            }
            BFileChooser chooser = BFileChooser.makeSave((BWidget)this.getOwner());
            chooser.setCurrentDirectory(defaultDir);
            chooser.setDefaultFileName(fileName);
            chooser.addFilter((IFileFilter)new ExtFileFilter("PLB Files", new String[]{"plb", "PLB"}));
            BOrd ord = chooser.show();
            if (ord == null) {
                return null;
            }
            defaultDir = chooser.getCurrentDirectory();
            BFoxSession session = (BFoxSession)BOrd.toSession((BObject)BPupRegionManager.this.device);
            session.getConnection().getChannels().getFileChannel().fw(901, (Object)BPupRegionManager.toFilePath(ord).getBody(), null, null, null);
            try {
                String remoteId = session.getConnection().session().getRemoteId();
                config.setPostSessionId(remoteId);
                config.setPostPath(BPupRegionManager.toFilePath(ord).getBody());
                BOrd jobOrd = BPupRegionManager.this.device.submitUploadRegionJob(config);
                BPupRegionManager.this.device.getComponentSpace().sync();
                this.job = (BPupUploadRegionJob)jobOrd.get((BObject)BPupRegionManager.this.device);
                BPupRegionManager.this.registerForComponentEvents((BComponent)this.job);
                BPupRegionManager.this.jobBar.load((BJob)this.job);
                BPupRegionManager.this.uploadJobComplete = false;
            }
            catch (Exception e) {
                session.getConnection().getChannels().getFileChannel().fw(902, (Object)BPupRegionManager.toFilePath(defaultDir), null, null, null);
                throw e;
            }
            BPupRegionManager.this.table.getSelection().deselectAll();
            return null;
        }

        public void setJob(BJob job) {
            this.job = (BPupUploadRegionJob)job;
        }

        public BJob getJob() {
            return this.job;
        }
    }

    class DownloadProgram
    extends Command {
        private BJob job;

        DownloadProgram(BWidget owner) {
            super(owner, (Lexicon)lexicon, "region.manager.download");
        }

        public CommandArtifact doInvoke() throws Exception {
            if (defaultDir == null) {
                FilePath dirPath = new FilePath("!spl_backups");
                defaultDir = BOrd.make((OrdQuery)dirPath);
            }
            BFileChooser chooser = BFileChooser.makeSave((BWidget)this.getOwner());
            chooser.setCurrentDirectory(defaultDir);
            chooser.setConfirmOverwrite(false);
            chooser.addFilter((IFileFilter)new ExtFileFilter("PLB Files", new String[]{"plb", "PLB"}));
            BOrd ord = chooser.show();
            if (ord == null) {
                return null;
            }
            BDownloadRegionParams config = new BDownloadRegionParams();
            config.setSplFile(ord);
            BIFile tmpFile = (BIFile)ord.resolve().get();
            String fileName = FileUtil.getBase((String)tmpFile.getFileName());
            String newRegionName = fileName.length() > 8 ? fileName.substring(0, 8) : fileName;
            config.setRegionName(newRegionName);
            BDownloadRegionParams params = (BDownloadRegionParams)BWbFieldEditor.dialog((BWidget)BPupRegionManager.this, (String)lexicon.get("region.manager.download.regionPromptTitle"), (BObject)config);
            if (params == null) {
                return null;
            }
            BPupRegionManager.this.device.getComponentSpace().sync();
            BPupRegionManager.this.device.lease(2, 60000L);
            try {
                params.setSplBlob(AaPupSplUtil.getSplBlob((BOrd)params.getSplFile()));
            }
            catch (UnresolvedException unresolvedException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            BPupRegionManager.this.device.setSplFile(ord);
            BOrd jobOrd = BPupRegionManager.this.device.submitDownloadSplJob(params);
            BPupRegionManager.this.device.getComponentSpace().sync();
            this.job = (BPupDownloadRegionJob)jobOrd.get((BObject)BPupRegionManager.this.device);
            BPupRegionManager.this.registerForComponentEvents((BComponent)this.job);
            BPupRegionManager.this.jobBar.load(this.job);
            BPupRegionManager.this.downloadJobComplete = false;
            BPupRegionManager.this.table.getSelection().deselectAll();
            this.job.lease();
            return null;
        }

        public BJob getJob() {
            return this.job;
        }
    }

    class DiscoverRegions
    extends Command {
        private BJob job;

        DiscoverRegions(BWidget owner) {
            super(owner, (Lexicon)lexicon, "region.manager.discoverRegions");
        }

        public CommandArtifact doInvoke() throws Exception {
            BOrd jobOrd = BPupRegionManager.this.device.submitLearnRegionsJob(BInteger.make((int)BPupRegionManager.this.device.getUnitNumber()));
            BPupRegionManager.this.discoveredRegions.removeAllElements();
            BPupRegionManager.this.device.getComponentSpace().sync();
            this.job = (BPupLearnRegionsJob)jobOrd.get((BObject)BPupRegionManager.this.device);
            BPupRegionManager.this.registerForComponentEvents((BComponent)this.job);
            this.job.lease();
            BPupRegionManager.this.jobBar.load(this.job);
            BPupRegionManager.this.discRegionsJobComplete = false;
            BPupRegionManager.this.disableCommands();
            return null;
        }

        public BJob getJob() {
            return this.job;
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getRowCount() {
            return BPupRegionManager.this.recs.length;
        }

        public int getColumnCount() {
            return 10;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return BPupRegionRecord.unitNumber.getDefaultDisplayName(null);
                }
                case 1: {
                    return BPupRegionRecord.serialNumber.getDefaultDisplayName(null);
                }
                case 2: {
                    return BPupRegionRecord.controllerType.getDefaultDisplayName(null);
                }
                case 3: {
                    return BPupRegionRecord.firmwareVersion.getDefaultDisplayName(null);
                }
                case 4: {
                    return BPupRegionRecord.regionNumber.getDefaultDisplayName(null);
                }
                case 5: {
                    return BPupRegionRecord.regionType.getDefaultDisplayName(null);
                }
                case 6: {
                    return BPupRegionRecord.regionName.getDefaultDisplayName(null);
                }
                case 7: {
                    return BPupRegionRecord.regionSize.getDefaultDisplayName(null);
                }
                case 8: {
                    return BPupRegionRecord.availableBufferSize.getDefaultDisplayName(null);
                }
                case 9: {
                    return BPupRegionRecord.regionLock.getDefaultDisplayName(null);
                }
            }
            return "???";
        }

        public Object getValueAt(int row, int col) {
            BPupRegionRecord rec = BPupRegionManager.this.recs[row];
            switch (col) {
                case 0: {
                    return BInteger.make((int)rec.getUnitNumber());
                }
                case 1: {
                    return BInteger.make((int)rec.getSerialNumber());
                }
                case 2: {
                    return BInteger.make((int)rec.getControllerType());
                }
                case 3: {
                    return BDouble.toString((double)rec.getFirmwareVersion(), (Context)BFacets.makeNumeric((int)2));
                }
                case 4: {
                    return BInteger.make((int)rec.getRegionNumber());
                }
                case 5: {
                    return BInteger.make((int)rec.getRegionType());
                }
                case 6: {
                    return BString.make((String)rec.getRegionName());
                }
                case 7: {
                    return BInteger.make((int)rec.getRegionSize());
                }
                case 8: {
                    return BInteger.make((int)rec.getAvailableBufferSize());
                }
                case 9: {
                    return BBoolean.make((boolean)rec.getRegionLock());
                }
            }
            return "???";
        }

        public BImage getRowIcon(int row) {
            return icon;
        }

        public void updateTable() {
            super.updateTable();
        }
    }

    class Selection
    extends TableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            BPupRegionManager.this.updateCommands();
        }
    }
}

