/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.ui.point;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.BPupDevice;
import com.tridium.aapup.BPupNetwork;
import com.tridium.aapup.datatypes.BPupPointDiscoveryConfig;
import com.tridium.aapup.job.BPupDiscoverPointsJob;
import com.tridium.aapup.job.BPupDiscoveryPoint;
import com.tridium.aapup.point.BPupBooleanProxyExt;
import com.tridium.aapup.point.BPupEnumProxyExt;
import com.tridium.aapup.point.BPupNumericProxyExt;
import com.tridium.aapup.point.BPupPointDeviceExt;
import com.tridium.aapup.point.BPupProxyExt;
import com.tridium.aapup.point.BPupStringProxyExt;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"aapup:PupPointDeviceExt", "aapup:PupPointFolder"}, requiredPermissions="W")})
public class BPupPointManager
extends BPointManager
implements AaPupConst {
    @Generated
    public static final Type TYPE = Sys.loadType(BPupPointManager.class);
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type(3);
    MgrColumn colValue = new MgrColumn.ToString(lexicon.getText("point.columnTitle.value"), 0);
    MgrColumn colFacets = new MgrColumn.Prop(BControlPoint.facets, 3);
    MgrColumn colFaultCause = new MgrColumn.PropPath(lexicon.getText("point.columnTitle.faultCause"), new Property[]{BControlPoint.proxyExt, BPupProxyExt.faultCause}, 4);
    MgrColumn colEnabled = new MgrColumn.PropPath(lexicon.getText("point.columnTitle.enabled"), new Property[]{BControlPoint.proxyExt, BPupProxyExt.enabled}, 6);
    MgrColumn colReadValue = new MgrColumn.PropPath(lexicon.getText("point.columnTitle.readValue"), new Property[]{BControlPoint.proxyExt, BPupProxyExt.readValue}, 6);
    MgrColumn colWriteValue = new MgrColumn.PropPath(lexicon.getText("point.columnTitle.writeValue"), new Property[]{BControlPoint.proxyExt, BPupProxyExt.writeValue}, 6);
    MgrColumn colChannel = new MgrColumn.PropPath(lexicon.getText("point.columnTitle.channel"), new Property[]{BControlPoint.proxyExt, BPupProxyExt.channel}, 1);
    MgrColumn colChannelDesc = new MgrColumn.PropPath(lexicon.getText("point.columnTitle.channelDescription"), new Property[]{BControlPoint.proxyExt, BPupProxyExt.channelDescription}, 1);
    MgrColumn colAttribute = new MgrColumn.PropPath(lexicon.getText("point.columnTitle.attribute"), new Property[]{BControlPoint.proxyExt, BPupProxyExt.attribute}, 1);
    MgrColumn colAttributeType = new MgrColumn.PropPath(lexicon.getText("point.columnTitle.attributeType"), new Property[]{BControlPoint.proxyExt, BPupProxyExt.attributeType}, 1);
    MgrColumn colAttributeValue = new MgrColumn.PropPath(lexicon.getText("point.columnTitle.attributeValue"), new Property[]{BControlPoint.proxyExt, BPupProxyExt.attributeValue}, 1);
    MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colType, this.colValue, this.colFacets, this.colFaultCause, this.colEnabled, this.colReadValue, this.colWriteValue, this.colChannel, this.colChannelDesc, this.colAttribute, this.colAttributeType, this.colAttributeValue};
    private static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BPupPointManager.class);
    private BPupPointDeviceExt deviceExt;
    private Vector<BPupDiscoveryPoint> discoveredPoints = new Vector();

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new PupPointModel(this);
    }

    protected MgrLearn makeLearn() {
        return new PupPointLearn();
    }

    protected MgrState makeState() {
        return new PupMgrState();
    }

    protected MgrController makeController() {
        return new PupPointController(this);
    }

    public void handleComponentEvent(BComponentEvent event) {
        String slotName;
        super.handleComponentEvent(event);
        BJob discJob = this.getLearn().getJob();
        if (discJob != null & event.getSourceComponent() == discJob && event.getId() == 5 && "channelLearned".equalsIgnoreCase(slotName = event.getSlotName())) {
            BPupDiscoveryPoint value = (BPupDiscoveryPoint)event.getValue();
            try {
                BPupDiscoveryPoint lastPoint = this.discoveredPoints.lastElement();
                if (lastPoint.getChannel() == value.getChannel()) {
                    this.discoveredPoints.removeElement(lastPoint);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            this.discoveredPoints.addElement(value);
            this.updateDiscoveryRows();
        }
    }

    private void updateDiscoveryRows() {
        if (this.discoveredPoints.size() > 0) {
            Object[] discoveredRows = new BPupDiscoveryPoint[this.discoveredPoints.size()];
            this.discoveredPoints.copyInto(discoveredRows);
            this.getLearn().updateRoots(discoveredRows);
        }
    }

    public void doLoadValue(BObject obj, Context cx) {
        try {
            this.deviceExt = (BPupPointDeviceExt)((BIPointFolder)obj).getDeviceExt();
            super.doLoadValue(obj, cx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BPupPointDeviceExt getDeviceExt() {
        if (this.deviceExt == null) {
            this.deviceExt = (BPupPointDeviceExt)((BIPointFolder)this.getCurrentValue()).getDeviceExt();
        }
        return this.deviceExt;
    }

    public BPupDevice getDevice() {
        return (BPupDevice)this.getDeviceExt().getDevice();
    }

    private static BPupNetwork findNetwork(BComplex obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BPupNetwork) {
            return (BPupNetwork)obj;
        }
        return BPupPointManager.findNetwork(obj.getParent());
    }

    class PupPointController
    extends PointController {
        public PupPointController(BPupPointManager manager) {
            super((BPointManager)manager);
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            BPupPointDiscoveryConfig config = new BPupPointDiscoveryConfig();
            config.setCm(BPupPointManager.this.getDevice().getManufacturer());
            config.setCt(BPupPointManager.this.getDevice().getControllerType());
            BPupNetwork network = BPupPointManager.findNetwork((BComplex)BPupPointManager.this.getDevice());
            config.setChannelList(network.getDeviceTypesFile());
            BPupPointDiscoveryConfig params = (BPupPointDiscoveryConfig)BWbFieldEditor.dialog((BWidget)this.getManager(), (String)lexicon.get("point.discover.configDialog"), (BObject)config);
            if (params == null) {
                return null;
            }
            BPupPointManager.this.discoveredPoints.removeAllElements();
            network.setDeviceTypesFile(params.getChannelList());
            BOrd ordToDiscoveryJob = BPupPointManager.this.getDevice().submitPointDiscoveryJob(params);
            BPupPointManager.this.getLearn().setJob(ordToDiscoveryJob);
            return null;
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            MgrController.IMgrCommand[] ancestor = super.makeCommands();
            Vector<MgrController.IMgrCommand> vret = new Vector<MgrController.IMgrCommand>(ancestor.length - 1);
            for (int i = 0; i < ancestor.length; ++i) {
                if (ancestor[i] == this.match || ancestor[i] == this.quickMatch) continue;
                vret.addElement(ancestor[i]);
            }
            Object[] ret = new MgrController.IMgrCommand[vret.size()];
            vret.copyInto(ret);
            return ret;
        }
    }

    class PupPointLearn
    extends MgrLearn {
        PupPointLearn(BPupPointManager mgr) {
            super((BAbstractManager)mgr);
        }

        PupPointLearn() {
            super((BAbstractManager)BPupPointManager.this);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Prop(BPupDiscoveryPoint.channel, 0), new MgrColumn.Prop(BPupDiscoveryPoint.channelDescription, 0), new MgrColumn.Prop(BPupDiscoveryPoint.attribute, 0), new MgrColumn.Prop(BPupDiscoveryPoint.attributeType, 0), new MgrColumn.Prop(BPupDiscoveryPoint.attributeValue, 0)};
        }

        public MgrTypeInfo[] toTypes(Object discovery) {
            BPupDiscoveryPoint disc = (BPupDiscoveryPoint)discovery;
            switch (disc.getAttributeType()) {
                case 223: 
                case 256: {
                    return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BStringPoint.TYPE), MgrTypeInfo.make((Type)BStringWritable.TYPE)};
                }
                case 0: 
                case 1: 
                case 2: 
                case 224: 
                case 229: 
                case 232: 
                case 233: 
                case 234: 
                case 235: 
                case 236: 
                case 237: 
                case 238: 
                case 239: 
                case 240: 
                case 241: 
                case 242: 
                case 243: 
                case 244: 
                case 245: 
                case 246: 
                case 247: 
                case 248: 
                case 249: 
                case 250: 
                case 251: 
                case 252: 
                case 253: 
                case 254: 
                case 255: {
                    return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BNumericPoint.TYPE), MgrTypeInfo.make((Type)BNumericWritable.TYPE), MgrTypeInfo.make((Type)BBooleanPoint.TYPE), MgrTypeInfo.make((Type)BBooleanWritable.TYPE), MgrTypeInfo.make((Type)BEnumPoint.TYPE), MgrTypeInfo.make((Type)BEnumWritable.TYPE)};
                }
                case 7: {
                    return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BBooleanPoint.TYPE), MgrTypeInfo.make((Type)BBooleanWritable.TYPE)};
                }
                case 230: 
                case 231: {
                    return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BStringPoint.TYPE)};
                }
            }
            return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BStringPoint.TYPE)};
        }

        public boolean isDepthExpandable(int depth) {
            return true;
        }

        public boolean hasChildren(Object discovery) {
            return this.getChildren(discovery).length > 0;
        }

        public Object[] getChildren(Object discovery) {
            Object[] a = ((BPupDiscoveryPoint)discovery).getChildren(BPupDiscoveryPoint.class);
            if (a == null) {
                return new Object[0];
            }
            return a;
        }

        public void toRow(Object discovered, MgrEditRow row) {
            BPupDiscoveryPoint discPt = (BPupDiscoveryPoint)discovered;
            String prefix = TextUtil.capitalize((String)discPt.getPrefix()) + discPt.getAttribute();
            row.setDefaultName(SlotPath.escape((String)prefix));
            row.setCell(BPupPointManager.this.colChannel, (BValue)BInteger.make((int)discPt.getChannel()));
            row.setCell(BPupPointManager.this.colChannelDesc, (BValue)BString.make((String)discPt.getChannelDescription()));
            row.setCell(BPupPointManager.this.colAttribute, (BValue)BString.make((String)discPt.getAttribute()));
            row.setCell(BPupPointManager.this.colAttributeType, (BValue)BInteger.make((int)discPt.getAttributeType()));
            row.setCell(BPupPointManager.this.colAttributeValue, (BValue)BString.make((String)discPt.getAttributeValue()));
        }

        public boolean isMatchable(Object discovery, BComponent database) {
            return false;
        }

        public boolean isExisting(Object dis, BComponent comp) {
            if (comp instanceof BControlPoint) {
                BPupDiscoveryPoint dp = (BPupDiscoveryPoint)dis;
                BControlPoint cp = (BControlPoint)comp;
                BAbstractProxyExt p = cp.getProxyExt();
                if (p instanceof BPupProxyExt) {
                    BPupProxyExt ppe = (BPupProxyExt)p;
                    return ppe.getChannel() == dp.getChannel() && ppe.getAttribute() == dp.getAttribute();
                }
            }
            return false;
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
            BPupPointManager.this.updateDiscoveryRows();
        }
    }

    class PupPointModel
    extends PointModel {
        PupPointModel() {
            super((BPointManager)BPupPointManager.this);
        }

        PupPointModel(BPupPointManager mgr) {
            super((BPointManager)mgr);
        }

        public int getSubscribeDepth() {
            return 3;
        }

        protected MgrColumn[] makeColumns() {
            return BPupPointManager.this.cols;
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BControlPoint pt = (BControlPoint)type.newInstance();
            BNullProxyExt ext = new BNullProxyExt();
            if (pt instanceof BBooleanPoint) {
                ext = new BPupBooleanProxyExt();
            } else if (pt instanceof BNumericPoint) {
                ext = new BPupNumericProxyExt();
            } else if (pt instanceof BEnumPoint) {
                ext = new BPupEnumProxyExt();
            } else if (pt instanceof BStringPoint) {
                ext = new BPupStringProxyExt();
            }
            if (ext instanceof BProxyExt) {
                BFacets deviceFacets = (BFacets)pt.getFacets().newCopy();
                ((BProxyExt)ext).setDeviceFacets(deviceFacets);
            }
            pt.setProxyExt((BAbstractProxyExt)ext);
            return pt;
        }

        public String hexInt(int b) {
            String s = Integer.toHexString(b).toUpperCase();
            if (s.length() == 1) {
                return "000" + s;
            }
            if (s.length() == 2) {
                return "00" + s;
            }
            if (s.length() == 3) {
                return "0" + s;
            }
            return s;
        }
    }

    class PupMgrState
    extends MgrState {
        BJob lastJob;

        PupMgrState() {
        }

        protected void saveForOrd(BAbstractManager manager) {
            super.saveForOrd(manager);
            BPupPointManager ptManager = (BPupPointManager)manager;
            this.lastJob = ptManager.getLearn().getJob();
        }

        protected void restoreForOrd(BAbstractManager manager) {
            super.restoreForOrd(manager);
            BPupPointManager ptManager = (BPupPointManager)manager;
            if (this.lastJob != null && this.lastJob.isMounted()) {
                BPupDiscoverPointsJob discJob = (BPupDiscoverPointsJob)this.lastJob;
                ptManager.getLearn().setJob(this.lastJob);
                ptManager.discoveredPoints.removeAllElements();
                BPupDiscoveryPoint[] jobPoints = (BPupDiscoveryPoint[])discJob.getLearnedPoints().getChildren(BPupDiscoveryPoint.class);
                if (jobPoints.length > 0) {
                    for (int i = 0; i < jobPoints.length; ++i) {
                        ptManager.discoveredPoints.addElement(jobPoints[i]);
                    }
                    ptManager.updateDiscoveryRows();
                }
            }
        }
    }
}

