/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.client.backup.ui;

import com.tridium.cloud.client.backup.BCloudBackupDownloadInfo;
import com.tridium.cloud.client.backup.crypto.CipherStreams;
import com.tridium.cloud.client.backup.file.BEncryptedDistributionFile;
import com.tridium.cloud.util.HttpUtils;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.json.JSONUtil;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLEncoder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.IRectGeom;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.security.BPassword;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.util.BNotification;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.util.BNotificationHandler;

@NiagaraType(agent={@AgentOn(types={"cloudBackup:CloudBackupDownloadNotification"})})
public final class BCloudBackupDownloadNotificationHandler
extends BNotificationHandler {
    public static final Type TYPE = Sys.loadType(BCloudBackupDownloadNotificationHandler.class);
    private static final Pattern securePattern = Pattern.compile("^https", 2);
    private static final Lexicon lex = Lexicon.make(BCloudBackupDownloadNotificationHandler.class);
    private static final Logger log = Logger.getLogger("cloudBackup");
    private static final String JSESSIONID = "JSESSIONID";
    private static final String LAST_SUPER_SESSION_ADD = "lastSuperSessionAdd";

    public Type getType() {
        return TYPE;
    }

    public void handle(BWbShell shell, BNotification notify, Context cx) {
        BDirectoryChooser chooser = BDirectoryChooser.make((BWidget)shell);
        chooser.setTitle(lex.get("backupDownload.title"));
        BOrd directoryOrd = chooser.show();
        if (directoryOrd == null || directoryOrd.isNull()) {
            return;
        }
        String _passphrase = "";
        boolean _decrypt = false;
        List<Object> downloadList = Arrays.asList(notify.getChildren(BCloudBackupDownloadInfo.class));
        if (BCloudBackupDownloadNotificationHandler.isSecure(downloadList)) {
            DownloadOption option = BCloudBackupDownloadNotificationHandler.downloadOption((BWidget)shell);
            if (option == DownloadOption.cancelled) {
                return;
            }
            if (option == DownloadOption.decrypted) {
                _decrypt = true;
                Optional<String> pp = BCloudBackupDownloadNotificationHandler.enterPassphrase((BWidget)shell);
                if (!pp.isPresent()) {
                    return;
                }
                _passphrase = pp.get();
            }
        }
        String passphrase = _passphrase;
        boolean decrypt = _decrypt;
        boolean success = BProgressDialog.openIndeterminate((BWidget)shell, (String)lex.get("backupDownload.downloading"), dlg -> {
            IRectGeom rect = dlg.getScreenBounds();
            double wi = 200.0;
            dlg.setScreenBounds(rect.x() - wi / 2.0, rect.y(), rect.width() + wi, rect.height());
            BIFile dir = (BIFile)directoryOrd.get();
            for (int i = 0; i < downloadList.size(); ++i) {
                BCloudBackupDownloadInfo info = (BCloudBackupDownloadInfo)downloadList.get(i);
                int count = i + 1;
                Consumer<Long> listener = totalBytes -> {
                    String message = lex.getText("backupDownload.downloadingFile", new Object[]{Long.toString(totalBytes / 1024L), count, downloadList.size() - count});
                    dlg.getMessageLabel().setText(message);
                    dlg.getMessageLabel().relayout();
                    dlg.relayout();
                };
                listener.accept(0L);
                try {
                    Throwable throwable;
                    Object reader;
                    URI downloadUri = this.makeUri(shell, info);
                    String key = "";
                    if (decrypt) {
                        HttpURLConnection keyInfoConn = AccessController.doPrivileged(() -> HttpUtils.makeConnection((URI)new URI(downloadUri + "?filter=keyinfo")));
                        keyInfoConn.setInstanceFollowRedirects(false);
                        keyInfoConn.setRequestMethod("GET");
                        keyInfoConn.setDoOutput(false);
                        AccessController.doPrivileged(() -> {
                            log.fine("super session id for uri '" + downloadUri + "' from cookieMgr: " + this.getCookieValue(downloadUri, "super_session_id"));
                            keyInfoConn.setRequestProperty(JSESSIONID, this.getCookieValue(downloadUri, "super_session_id").get());
                            return null;
                        });
                        int keyInfoRespCode = keyInfoConn.getResponseCode();
                        if (keyInfoRespCode != 200) {
                            throw new IOException(lex.getText("invalidResponse", new Object[]{keyInfoRespCode}));
                        }
                        reader = new InputStreamReader(new BufferedInputStream(keyInfoConn.getInputStream()));
                        throwable = null;
                        try {
                            JSONObject obj = new JSONObject(new JSONTokener((Reader)reader));
                            byte[] salt = Base64.getDecoder().decode(JSONUtil.getString((JSONObject)obj, (String)"salt"));
                            int iterationCount = obj.getInt("iterationCount");
                            int keySize = obj.getInt("keySize");
                            String keyFactory = JSONUtil.getString((JSONObject)obj, (String)"keyFactory");
                            key = Base64.getEncoder().encodeToString(CipherStreams.createPasskey((char[])passphrase.toCharArray(), (byte[])salt, (int)iterationCount, (int)keySize, (String)keyFactory));
                        }
                        catch (Throwable obj) {
                            throwable = obj;
                            throw obj;
                        }
                        finally {
                            if (reader != null) {
                                if (throwable != null) {
                                    try {
                                        ((InputStreamReader)reader).close();
                                    }
                                    catch (Throwable obj) {
                                        throwable.addSuppressed(obj);
                                    }
                                } else {
                                    ((InputStreamReader)reader).close();
                                }
                            }
                        }
                    }
                    HttpURLConnection downloadConn = AccessController.doPrivileged(() -> HttpUtils.makeConnection((URI)downloadUri));
                    downloadConn.setInstanceFollowRedirects(false);
                    downloadConn.setRequestMethod("POST");
                    downloadConn.setDoOutput(true);
                    OutputStream out = downloadConn.getOutputStream();
                    reader = null;
                    try {
                        String value = String.format("value=%s&process=%s", URLEncoder.encode(key, "UTF-8"), decrypt);
                        out.write(value.getBytes("UTF-8"));
                    }
                    catch (Throwable throwable2) {
                        reader = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (out != null) {
                            if (reader != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)reader).addSuppressed(throwable3);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                    int downloadRespCode = downloadConn.getResponseCode();
                    if (downloadRespCode != 200) {
                        if (downloadRespCode == 302) {
                            throw new IOException(lex.getText("invalidPassphraseTryAgain"));
                        }
                        throw new IOException(lex.getText("invalidResponse", new Object[]{downloadRespCode}));
                    }
                    throwable = null;
                    try (BufferedInputStream in = new BufferedInputStream(downloadConn.getInputStream());){
                        String distFileName = decrypt ? BEncryptedDistributionFile.toDistFileName((String)info.getFileName()) : info.getFileName();
                        FilePath distFilePath = dir.getFilePath().merge(distFileName);
                        BIFile newDistFile = dir.getFileSpace().makeFile(distFilePath);
                        try (BytesWrittenOutputStream out2 = new BytesWrittenOutputStream(listener, new BufferedOutputStream(newDistFile.getOutputStream()));){
                            FileUtil.pipe((InputStream)in, (OutputStream)out2);
                            continue;
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                }
                catch (Exception e) {
                    BDialog.error((BWidget)shell, (String)lex.get("backupDownload.error"), (Object)Objects.toString(e.getMessage(), "Unknown error"), (Throwable)e);
                    return false;
                }
            }
            return true;
        }).orElse(false);
        if (success) {
            BDialog.message((BWidget)shell, (String)lex.get("backupDownload.success"), (Object)lex.getText("backupDownload.successfullyDownloaded", new Object[]{downloadList.size()}));
        }
    }

    private URI makeUri(BWbShell shell, BCloudBackupDownloadInfo info) throws Exception {
        BFoxSession foxSession;
        URI downloadUri = new URI(info.getDownloadUrl());
        BISession session = shell.getActiveView().getCurrentValueSession();
        BFoxSession bFoxSession = foxSession = session instanceof BFoxSession ? (BFoxSession)session : null;
        if (foxSession != null) {
            try {
                AccessController.doPrivileged(() -> {
                    Optional expectedSessionId;
                    FoxSession sess = foxSession.getConnection().session();
                    if (!(sess == null || (expectedSessionId = sess.getFromCache("jsession")).isPresent() && this.isCookiePresent(downloadUri, JSESSIONID, (String)expectedSessionId.get()))) {
                        String superSessionId = sess.getRemoteSuperId();
                        this.removeCookie(downloadUri, JSESSIONID);
                        this.addCookie(downloadUri, "super_session_id", superSessionId);
                        sess.getFromCache(LAST_SUPER_SESSION_ADD, v -> superSessionId);
                    }
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        return downloadUri;
    }

    private static boolean isSecure(List<BCloudBackupDownloadInfo> downloadList) {
        return downloadList.stream().map(BCloudBackupDownloadInfo::getDownloadUrl).allMatch(url -> securePattern.matcher((CharSequence)url).find());
    }

    private static Optional<String> enterPassphrase(BWidget parent) {
        BPasswordFE passwordFe = new BPasswordFE();
        passwordFe.loadValue((BObject)BPassword.DEFAULT);
        BEdgePane content = new BEdgePane();
        content.setTop(BCloudBackupDownloadNotificationHandler.makeMessageWidget("enterPassphrase.description"));
        content.setCenter((BWidget)new BBorderPane((BWidget)passwordFe));
        if (BDialog.open((BWidget)parent, (String)lex.get("enterPassphrase.title"), (Object)content, (int)3) == 2) {
            return Optional.empty();
        }
        return Optional.of(((BTextEditor)passwordFe.getContent()).getText());
    }

    private static DownloadOption downloadOption(BWidget parent) {
        BEdgePane content = new BEdgePane();
        content.setTop(BCloudBackupDownloadNotificationHandler.makeMessageWidget("downloadDecrypted.message"));
        ToggleCommandGroup group = new ToggleCommandGroup();
        BRadioButton encryptedButton = new BRadioButton(group, lex.get("downloadDecrypted.edist"), true);
        BRadioButton decryptedButton = new BRadioButton(group, lex.get("downloadDecrypted.dist"), false);
        BGridPane buttonPane = new BGridPane(1, new BWidget[]{encryptedButton, decryptedButton});
        buttonPane.setRowGap(10.0);
        content.setCenter((BWidget)new BBorderPane((BWidget)buttonPane));
        int res = BDialog.open((BWidget)parent, (String)lex.get("downloadDecrypted.title"), (Object)content, (int)3);
        if (res == 2) {
            return DownloadOption.cancelled;
        }
        return group.getSelected().equals(encryptedButton.getCommand()) ? DownloadOption.encrypted : DownloadOption.decrypted;
    }

    private static BWidget makeMessageWidget(String lexKey) {
        BLabel label = new BLabel(lex.get(lexKey));
        BEdgePane edgePane = new BEdgePane();
        edgePane.setLeft((BWidget)label);
        return new BBorderPane((BWidget)edgePane);
    }

    public boolean isCookiePresent(URI uri, String name, String value) {
        return BCloudBackupDownloadNotificationHandler.getCookieManager().getCookieStore().get(uri).stream().anyMatch(cookie -> cookie.getName().equals(name) && cookie.getValue().equals(value));
    }

    public Optional<String> getCookieValue(URI uri, String name) {
        return BCloudBackupDownloadNotificationHandler.getCookieManager().getCookieStore().get(uri).stream().filter(cookie -> cookie.getName().equals(name)).map(HttpCookie::getValue).findFirst();
    }

    public void removeCookie(URI uri, String name) {
        CookieStore store = BCloudBackupDownloadNotificationHandler.getCookieManager().getCookieStore();
        store.get(uri).stream().filter(cookie -> cookie.getName().equals(name)).forEach(cookie -> store.remove(uri, (HttpCookie)cookie));
    }

    public void addCookie(URI uri, String name, String value) throws IOException {
        HttpCookie cookie = new HttpCookie(name, value);
        LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
        headers.put("Set-Cookie", Collections.singletonList(cookie.toString()));
        BCloudBackupDownloadNotificationHandler.getCookieManager().put(uri, headers);
    }

    private static CookieManager getCookieManager() {
        CookieHandler handler = CookieHandler.getDefault();
        if (handler == null || !(handler instanceof CookieManager)) {
            handler = new CookieManager(null, CookiePolicy.ACCEPT_ALL);
            CookieHandler.setDefault(handler);
        }
        return (CookieManager)handler;
    }

    private static final class BytesWrittenOutputStream
    extends FilterOutputStream {
        private long totalBytes;
        private long lastUpdate;
        private final Consumer<Long> listener;
        private static final long updateIncrement = 1024L;

        private BytesWrittenOutputStream(Consumer<Long> listener, OutputStream out) {
            super(out);
            this.listener = listener;
            this.update();
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.totalBytes;
            this.update();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
            this.totalBytes += (long)b.length;
            this.update();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.totalBytes += (long)len;
            this.update();
        }

        private void update() {
            if (this.totalBytes > this.lastUpdate && this.totalBytes - this.lastUpdate > 1024L) {
                this.lastUpdate = this.totalBytes;
                this.listener.accept(this.lastUpdate);
            }
        }
    }

    static enum DownloadOption {
        encrypted,
        decrypted,
        cancelled;

    }
}

