/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.control.trigger;

import javax.baja.control.trigger.BDailyTriggerMode;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.control.trigger.TriggerScheduler;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="triggerMode", type="BTriggerMode", defaultValue="BDailyTriggerMode.DEFAULT"), @NiagaraProperty(name="lastTrigger", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="nextTrigger", type="BAbsTime", defaultValue="BAbsTime.END_OF_TIME", flags=65537)})
@NiagaraActions(value={@NiagaraAction(name="fireTrigger"), @NiagaraAction(name="checkTime", flags=4)})
public class BTimeTrigger
extends BComponent {
    @Generated
    public static final Property triggerMode = BTimeTrigger.newProperty((int)0, (BValue)BDailyTriggerMode.DEFAULT, null);
    @Generated
    public static final Property lastTrigger = BTimeTrigger.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property nextTrigger = BTimeTrigger.newProperty((int)65537, (BValue)BAbsTime.END_OF_TIME, null);
    @Generated
    public static final Action fireTrigger = BTimeTrigger.newAction((int)0, null);
    @Generated
    public static final Action checkTime = BTimeTrigger.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTimeTrigger.class);
    private static final BIcon icon = BIcon.std((String)"control/trigger.png");
    private TriggerScheduler scheduler;

    @Generated
    public BTriggerMode getTriggerMode() {
        return (BTriggerMode)this.get(triggerMode);
    }

    @Generated
    public void setTriggerMode(BTriggerMode v) {
        this.set(triggerMode, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastTrigger() {
        return (BAbsTime)this.get(lastTrigger);
    }

    @Generated
    public void setLastTrigger(BAbsTime v) {
        this.set(lastTrigger, (BValue)v, null);
    }

    @Generated
    public BAbsTime getNextTrigger() {
        return (BAbsTime)this.get(nextTrigger);
    }

    @Generated
    public void setNextTrigger(BAbsTime v) {
        this.set(nextTrigger, (BValue)v, null);
    }

    @Generated
    public void fireTrigger() {
        this.invoke(fireTrigger, null, null);
    }

    @Generated
    public void checkTime() {
        this.invoke(checkTime, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTimeTrigger() {
    }

    public BTimeTrigger(BTriggerMode mode) {
        this.setTriggerMode(mode);
    }

    public void atSteadyState() {
        if (this.isRunning()) {
            this.init();
        }
    }

    public void started() {
        if (Sys.atSteadyState()) {
            this.init();
        }
    }

    public void stopped() {
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
        this.scheduler = null;
    }

    private void init() {
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
        this.scheduler = this.getTriggerMode().makeScheduler(this);
        this.checkTime();
        this.scheduler.start();
        BAbsTime scheduled = this.scheduler.getScheduledTriggerTime();
        if (scheduled == null) {
            this.setNextTrigger(this.scheduler.getNextTriggerTime(Clock.time(), this.getLastTrigger()));
        } else {
            this.setNextTrigger(scheduled);
        }
    }

    public void doFireTrigger() {
        BAbsTime now = Clock.time();
        this.setLastTrigger(now);
    }

    public void doCheckTime() {
        BAbsTime scheduled;
        BAbsTime now = Clock.time();
        if (this.scheduler.isTriggerTime(now)) {
            this.fireTrigger();
        }
        if ((scheduled = this.scheduler.getScheduledTriggerTime()) == null) {
            this.setNextTrigger(this.scheduler.getNextTriggerTime(now, this.getLastTrigger()));
        } else {
            this.setNextTrigger(scheduled);
        }
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p == triggerMode) {
            this.init();
        }
    }

    public void clockChanged(BRelTime shift) {
        this.init();
    }

    public String toString(Context cx) {
        return this.getTriggerMode().toString(cx);
    }

    public BIcon getIcon() {
        return icon;
    }
}

