/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator.baja;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.baja.io.ValueDocDecoder;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.Mark;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BServiceContainer;
import javax.baja.util.Version;

@NiagaraType
public class BRestrictedServiceConverter
extends BComponent
implements BIBogElementConverter {
    @Generated
    public static final Type TYPE = Sys.loadType(BRestrictedServiceConverter.class);
    private static final List<String> convertTypes = new ArrayList<String>();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public List<String> getConvertTypes() {
        return convertTypes;
    }

    public void convertComplex(BComponent root, ValueDocDecoder.ITypeResolver resolver, BComplex toConvert, Version sourceVersion) throws Exception {
        BRestrictedServiceConverter.checkRestrictedService(root, toConvert);
    }

    public static void checkRestrictedService(BComponent root, BComplex toConvert) {
        if (!root.getType().is(BStation.TYPE) || !toConvert.getType().is(BIRestrictedComponent.TYPE)) {
            return;
        }
        BComponent parent = toConvert.getParent().asComponent();
        if (parent.getType().is(BServiceContainer.TYPE)) {
            return;
        }
        String pathString = null;
        try {
            pathString = toConvert.asComponent().toDisplayPathString(null);
            Property prop = toConvert.getPropertyInParent();
            String propName = prop.getName();
            int slotFlags = parent.getFlags((Slot)prop);
            BFacets slotFacets = parent.getSlotFacets((Slot)prop);
            BFormat displayNameFormat = parent.getDisplayNameFormat(prop);
            BObject[] vals = new BObject[]{toConvert};
            String[] propNames = new String[]{prop.getName()};
            BServiceContainer services = ((BStation)root).getServices();
            new Mark(vals, propNames).moveTo((BObject)services, null);
            Property newProp = services.getProperty(propName);
            services.setFlags((Slot)newProp, slotFlags);
            services.setFacets((Slot)newProp, slotFacets);
            if (displayNameFormat != null) {
                services.setDisplayName(newProp, displayNameFormat, null);
            }
            log.warning("Moved the service at '" + pathString + "' to a new location under the station's Services container.");
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Failed to move the service at '" + pathString + "' to a new location under the station's Services container. The service will be removed when the station is started.", t);
        }
    }

    static {
        convertTypes.add("history:AuditHistoryService");
        convertTypes.add("baja:AuthenticationService");
        convertTypes.add("backup:BackupService");
        convertTypes.add("batchJob:BatchJobService");
        convertTypes.add("box:BoxService");
        convertTypes.add("baja:CategoryService");
        convertTypes.add("email:EmailService");
        convertTypes.add("event:EventService");
        convertTypes.add("hierarchy:HierarchyService");
        convertTypes.add("net:HttpProxyService");
        convertTypes.add("baja:JobService");
        convertTypes.add("workbench:KioskService");
        convertTypes.add("baja:LoggingService");
        convertTypes.add("onCall:OnCallService");
        convertTypes.add("orion:OrionService");
        convertTypes.add("platform:PlatformServiceContainer");
        convertTypes.add("program:ProgramService");
        convertTypes.add("report:ReportService");
        convertTypes.add("baja:RoleService");
        convertTypes.add("systemMonitor:SystemMonitorService");
        convertTypes.add("tagdictionary:TagDictionaryService");
        convertTypes.add("template:TemplateService");
    }
}

