/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator.alarm;

import com.tridium.alarm.db.file.AlarmStore;
import com.tridium.install.installable.DistributionManifest;
import com.tridium.migrator.MigrationUtils;
import java.io.File;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.zip.ZipFile;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.file.BajaFileUtil;
import javax.baja.migration.BFileMigrator;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BAlarmDbMigrator
extends BFileMigrator {
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmDbMigrator.class);
    private boolean zip = false;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public String[] getMigratePatterns() {
        return new String[]{"alarm.*\\.zip"};
    }

    public String[] getMigrateTypes() {
        return new String[]{"adb"};
    }

    public void initialize(File source, File target, Supplier<BPassword> passwordSupplier, DistributionManifest distManifest) {
        super.initialize(source, target, passwordSupplier, distManifest);
        if ("zip".equals(BajaFileUtil.getExtension((String)source.getName()))) {
            this.zip = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> migrate() throws Exception {
        boolean finest = this.log.isLoggable(Level.FINEST);
        File alarmSrcFile = this.source;
        File alarmTgtFile = this.target;
        try {
            if (this.zip) {
                File alarmSrc = MigrationUtils.createMigTempDir("alarmSrc");
                try (ZipFile zin = new ZipFile(this.source);){
                    MigrationUtils.extractZip(zin, alarmSrc, zipEntry -> true);
                }
                catch (Exception e) {
                    return MigrationUtils.errorResult(this.log, "Error copying zipped source " + this.source + " to temp files", e);
                }
                alarmSrcFile = Paths.get(alarmSrc.getAbsolutePath(), "alarm.adb").toFile();
                alarmTgtFile = Paths.get(MigrationUtils.createMigTempDir("alarmTgt").getAbsolutePath(), "alarm.adb").toFile();
            }
            AlarmStore srcStore = new AlarmStore(alarmSrcFile);
            AlarmStore tgtStore = new AlarmStore(alarmTgtFile);
            if (finest) {
                this.log.finest("Trying to safeCreateFile for " + alarmTgtFile);
            }
            MigrationUtils.safeCreateFile(alarmTgtFile);
            try {
                if (finest) {
                    this.log.finest("Opening source alarm store (should be init())");
                }
                srcStore.open();
                if (finest) {
                    this.log.finest("Opening target alarm store (should be create())");
                }
                tgtStore.open();
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("AlarmDbMigrator: source store record count=" + srcStore.getRecordCount());
                }
                int count = 0;
                try (Cursor records = srcStore.scan();){
                    while (records.next()) {
                        tgtStore.append((BAlarmRecord)records.get());
                        ++count;
                    }
                }
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Appended " + count + (count != 1 ? " records " : " record ") + "to target store");
                }
                tgtStore.flush();
            }
            finally {
                srcStore.close();
                tgtStore.close();
            }
            if (this.zip) {
                MigrationUtils.createZip(alarmTgtFile.getParentFile(), this.target);
            }
            return Optional.empty();
        }
        catch (Exception e) {
            return MigrationUtils.errorResult(this.log, "Error migrating " + this.source + " to " + this.target, e);
        }
    }
}

