/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator;

import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.installable.DistributionManifest;
import com.tridium.migrator.FileStats;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BITemplate;
import javax.baja.file.FilePath;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.migration.MigrationException;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.FileUtil;
import javax.baja.platform.install.BVersionRelation;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XWriter;

public final class MigrationUtils {
    private static final HashMap<String, Lexicon> lexMap = new HashMap();
    private static final Lexicon lex = Lexicon.make((String)"migrator");
    private static final Logger log = Logger.getLogger("migration");
    private static final ArrayList<String> protectedStationHomeNames = new ArrayList();
    private static final ArrayList<String> protectedStationHomePatterns;
    private static final String MIG_TEMP_DIR_NAME = "migTemp";
    private static final File migTempDir;
    private static final String NIAGARA_MIGRATION_TEMPLATES_DIR = "file:!defaults/workbench/migrationTemplates";
    private static final FilePath USER_MIGRATION_TEMPLATES_DIR;
    private static final int MAX_NAME_LEN_IN_PROGRESS = 40;
    private static final int MAX_BAR_LEN = 15;
    private static final int MAX_MSG_LEN_IN_PROGRESS = 15;
    private static final String FORMAT_STR = " [%s] %3d%% %s";
    public static final BIFile[] EMPTY_BIFILE_ARRAY;

    private MigrationUtils() {
    }

    public static File safeCreateDirectory(File file) throws IOException {
        if (file.exists()) {
            return file;
        }
        if (!file.mkdirs()) {
            throw new IOException("Could not create directory " + file);
        }
        return file;
    }

    public static File safeCreateFile(File file) throws IOException {
        if (file.exists()) {
            return file;
        }
        File parentFile = file.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            throw new IOException("Could not create parent dir for " + file);
        }
        if (!file.createNewFile()) {
            throw new IOException("Could not create file " + file);
        }
        return file;
    }

    public static void safeCopy(File oldFile, File newFile) throws IOException {
        if (!newFile.getParentFile().exists() && !newFile.getParentFile().mkdirs()) {
            throw new IOException("Cannot make dir for file: " + newFile);
        }
        if (!oldFile.isDirectory()) {
            FileUtil.delete((File)newFile);
        }
        FileUtil.copy((File)oldFile, (File)newFile);
    }

    public static void safeMove(File oldFile, File newFile) throws IOException {
        if (!newFile.getParentFile().exists() && !newFile.getParentFile().mkdirs()) {
            throw new IOException("Cannot make dir for move file: " + newFile);
        }
        if (!oldFile.isDirectory()) {
            FileUtil.delete((File)newFile);
        }
        FileUtil.move((File)oldFile, (File)newFile);
    }

    public static FileStats getFileStats(File f) {
        return MigrationUtils.getFileStats(f, new FileStats());
    }

    public static FileStats getFileStats(File f, FileStats msize) {
        long bcStart = msize.byteCount;
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (File ff : files) {
                    MigrationUtils.getFileStats(ff, msize);
                }
            }
        } else {
            ++msize.fileCount;
            msize.byteCount += f.length();
        }
        if (msize.byteCount < bcStart) {
            log.severe("!!!!!!!!!! FileStats byteCount rollover!");
        }
        return msize;
    }

    private static File makeFileFromZipEntry(File root, ZipEntry ze) throws IOException {
        File file = new File(root, ze.getName());
        if (ze.isDirectory()) {
            return MigrationUtils.safeCreateDirectory(file);
        }
        return MigrationUtils.safeCreateFile(file);
    }

    public static void extractZip(ZipFile zin, File extractTgt, Predicate<? super ZipEntry> filter) throws Exception {
        Enumeration<? extends ZipEntry> entries = zin.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zeIn = entries.nextElement();
            if (!filter.test(zeIn)) continue;
            File temp = MigrationUtils.makeFileFromZipEntry(extractTgt, zeIn);
            if (zeIn.isDirectory()) continue;
            InputStream fis = zin.getInputStream(zeIn);
            Throwable throwable = null;
            try {
                FileOutputStream fos = new FileOutputStream(temp);
                Throwable throwable2 = null;
                try {
                    FileUtil.pipe((InputStream)fis, (long)zeIn.getSize(), (OutputStream)fos);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (fos == null) continue;
                    if (throwable2 != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    fos.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (fis == null) continue;
                if (throwable != null) {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                fis.close();
            }
        }
    }

    public static void extractZip(ZipFile zin, File extractTgt, List<String> xDirs, BiPredicate<? super ZipEntry, ? super List<String>> filter) throws Exception {
        int numEntries = zin.size();
        int numExtracted = 0;
        Enumeration<? extends ZipEntry> entries = zin.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zeIn = entries.nextElement();
            MigrationUtils.showProgress(numExtracted++, numEntries, "migrate.unzip.progress", zeIn.getName());
            if (!filter.test(zeIn, xDirs)) continue;
            File temp = MigrationUtils.makeFileFromZipEntry(extractTgt, zeIn);
            if (zeIn.isDirectory()) continue;
            InputStream fis = zin.getInputStream(zeIn);
            Throwable throwable = null;
            try {
                FileOutputStream fos = new FileOutputStream(temp);
                Throwable throwable2 = null;
                try {
                    FileUtil.pipe((InputStream)fis, (long)zeIn.getSize(), (OutputStream)fos);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (fos == null) continue;
                    if (throwable2 != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    fos.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (fis == null) continue;
                if (throwable != null) {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                fis.close();
            }
        }
        MigrationUtils.showProgress(numEntries, numEntries, "migrate.unzip.progress", null);
    }

    public static DistributionManifest getDistributionManifest(ZipFile zfDist) throws Exception {
        ZipEntry zeDist = zfDist.getEntry("META-INF/dist.xml");
        if (zeDist == null) {
            zeDist = zfDist.getEntry("meta-inf/dist.xml");
            if (zeDist != null) {
                throw new MigrationException(lex.getText("backupDistMigrator.distIs3_6"));
            }
            throw new MigrationException(lex.getText("backupDistMigrator.missingDistXml"));
        }
        InputStream is = zfDist.getInputStream(zeDist);
        return DistributionManifest.make((InputStream)is);
    }

    public static BDependency validateDist(DistributionManifest dm, BVersion minimumVersion) {
        BDependency[] deps = dm.getDependencies();
        BDependency bajaDep = null;
        for (BDependency dep : deps) {
            if (!"baja".equals(dep.getPartName())) continue;
            bajaDep = dep;
        }
        if (bajaDep == null) {
            throw new MigrationException(lex.getText("migrator.dist.noBajaVersion"));
        }
        boolean meets3_8 = bajaDep.getVersion().meetsVersionRequirement(minimumVersion, BVersionRelation.minimum);
        if (!meets3_8) {
            throw new MigrationException(MessageFormat.format(lex.getText("migrator.dist.minVersionFail"), minimumVersion, bajaDep.getVersion()));
        }
        return bajaDep;
    }

    public static void showProgress(int cur, int goal, String lexKey, String message) {
        System.out.print(String.format(MigrationUtils.trim(lex.getText(lexKey), 15) + FORMAT_STR, MigrationUtils.bar(cur, goal), MigrationUtils.progress(cur, goal, 100), MigrationUtils.trim(message, 40)) + '\r');
        if (cur >= goal) {
            System.out.println();
        }
    }

    private static String pad(int num) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < num; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private static String trim(String s, int len) {
        if (s == null) {
            return MigrationUtils.pad(len);
        }
        if (len < 3) {
            return MigrationUtils.pad(len);
        }
        if (s.length() < len) {
            return s + MigrationUtils.pad(len - s.length());
        }
        return s.substring(0, len - 3) + "...";
    }

    private static int progress(int cur, int goal, int max) {
        return (int)((double)cur * (double)max / (double)goal);
    }

    private static String bar(int cur, int goal) {
        int i;
        int numBars = MigrationUtils.progress(cur, goal, 15);
        int numSpcs = 15 - numBars;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < numBars; ++i) {
            sb.append('>');
        }
        for (i = 0; i < numSpcs; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public static void createZip(File unzippedSrc, File zipTgt) throws Exception {
        try (ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(zipTgt));){
            Object[] files = unzippedSrc.listFiles();
            if (files != null) {
                Arrays.sort(files);
                for (Object f : files) {
                    MigrationUtils.addFileToZip(zout, (File)f, "");
                }
            }
            zout.flush();
        }
    }

    private static void addFileToZip(ZipOutputStream zout, File f, String path) throws Exception {
        if (MigrationUtils.isEmpty(f)) {
            return;
        }
        String zeName = path + f.getName();
        if (f.isDirectory()) {
            zeName = zeName + "/";
        }
        ZipEntry ze = new ZipEntry(zeName);
        zout.putNextEntry(ze);
        if (f.isDirectory()) {
            zout.closeEntry();
            File[] files = f.listFiles();
            if (files != null) {
                for (File f2 : files) {
                    MigrationUtils.addFileToZip(zout, f2, zeName);
                }
            }
        } else {
            try (FileInputStream in = new FileInputStream(f);){
                FileUtil.pipe((InputStream)in, (OutputStream)zout);
            }
            zout.closeEntry();
        }
    }

    private static boolean isEmpty(File file) {
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            File kid;
            File[] kids = file.listFiles();
            if (kids == null) {
                return true;
            }
            boolean empty = true;
            File[] fileArray = kids;
            int n = fileArray.length;
            for (int i = 0; i < n && (empty = MigrationUtils.isEmpty(kid = fileArray[i])); ++i) {
            }
            return empty;
        }
        return false;
    }

    public static void logConfig(String lexiconKey, Object ... args) {
        log.config(MessageFormat.format(lex.getText(lexiconKey), args));
    }

    public static void logInfo(String lexiconKey, Object ... args) {
        log.info(MessageFormat.format(lex.getText(lexiconKey), args));
    }

    public static void logInfo(String lexiconKey, Throwable t, Object ... args) {
        log.info(MessageFormat.format(lex.getText(lexiconKey) + MigrationUtils.formatThrowable(t, log), args));
    }

    public static void logInfoByModule(String module, String lexiconKey, Object ... args) {
        log.info(MessageFormat.format(MigrationUtils.getLexicon(module).getText(lexiconKey), args));
    }

    public static void logWarning(String lexiconKey, Throwable t, Object ... args) {
        log.warning(MessageFormat.format(lex.getText(lexiconKey) + MigrationUtils.formatThrowable(t, log), args));
    }

    public static void logWarning(String lexiconKey, Object ... args) {
        log.warning(MessageFormat.format(lex.getText(lexiconKey), args));
    }

    public static void logSevere(String lexiconKey, Throwable t, Object ... args) {
        log.severe(MessageFormat.format(lex.getText(lexiconKey) + MigrationUtils.formatThrowable(t, log), args));
    }

    public static void logSevere(String lexiconKey, Object ... args) {
        log.severe(MessageFormat.format(lex.getText(lexiconKey), args));
    }

    public static void logSevereByModule(String module, String lexiconKey, Object ... args) {
        log.severe(MessageFormat.format(MigrationUtils.getLexicon(module).getText(lexiconKey), args));
    }

    private static Lexicon getLexicon(String module) {
        Lexicon lexicon = lexMap.get(module);
        if (lexicon == null) {
            lexicon = Lexicon.make((String)module);
            lexMap.put(module, lexicon);
        }
        return lexicon;
    }

    public static String formatThrowable(Throwable t, Logger log) {
        StringBuilder sb = new StringBuilder();
        if (log.isLoggable(Level.CONFIG)) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            sw.flush();
            String stackTrace = sw.toString();
            sb.append('\n').append(stackTrace);
        } else {
            sb.append(':').append(t.toString());
        }
        return sb.toString();
    }

    public static Optional<String> validateTarget(File target, Logger log, boolean overwrite) {
        try {
            if (target.exists()) {
                if (!overwrite) {
                    String message = MessageFormat.format(lex.getText("migrate.targetExistsFail"), target);
                    log.severe(message);
                    return Optional.of(message);
                }
                log.info(MessageFormat.format(lex.getText("migrate.targetExistsOverwrite"), target));
                FileUtil.delete((File)target);
            }
            return Optional.empty();
        }
        catch (Exception e) {
            String message = MessageFormat.format(lex.getText("migrate.cannotValidate"), target);
            log.log(Level.SEVERE, message, e);
            return MigrationUtils.errorResult(log, message, e);
        }
    }

    public static Optional<String> errorResult(Logger log, String msg) {
        return MigrationUtils.errorResult(log, msg, null);
    }

    public static Optional<String> errorResult(Logger log, String msg, Throwable t) {
        StringBuilder sb = new StringBuilder(msg);
        if (t != null) {
            if (log.isLoggable(Level.CONFIG)) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                sw.flush();
                String stackTrace = sw.toString();
                sb.append('\n').append(stackTrace);
            } else {
                sb.append(':').append(t.toString());
            }
        }
        return Optional.of(sb.toString());
    }

    public static void outOfMemoryError(Logger log) {
        System.out.println("\n\n******************************************************************************");
        System.out.println("*** General Failure");
        System.out.println("*** OutOfMemoryError - You must increase the maximum heap allocated to the");
        System.out.println("*** Niagara VM to support this migration.");
        System.out.println("***    In the System Home of your Niagara installation,");
        System.out.println("***    edit the defaults/nre.properties file;");
        System.out.println("***    set the property wb.java.options '-Xmx' field to a higher value.");
        System.out.println("****************************************************************************\n");
        System.exit(0);
    }

    public static void cleanMigTempDirs() throws IOException {
        FileUtil.delete((File)migTempDir);
    }

    public static File createMigTempDir(String proposedName) throws IOException {
        File newFile = new File(migTempDir, proposedName);
        int i = 1;
        while (newFile.exists()) {
            newFile = new File(migTempDir, proposedName + i);
            ++i;
        }
        return MigrationUtils.safeCreateDirectory(newFile);
    }

    public static File getMigTempDirName(String proposedName) {
        File newFile = new File(migTempDir, proposedName);
        int i = 1;
        while (newFile.exists()) {
            newFile = new File(migTempDir, proposedName + i);
            ++i;
        }
        return newFile;
    }

    public static boolean isProtected(File targetFile, DistributionManifest distributionManifest) {
        return MigrationUtils.isProtected(targetFile.toPath(), MigrationUtils.getVersion(distributionManifest, "baja"));
    }

    public static boolean isProtected(Path targetPath, DistributionManifest distributionManifest) {
        return MigrationUtils.isProtected(targetPath, MigrationUtils.getVersion(distributionManifest, "baja"));
    }

    public static boolean isProtected(String tgtFilename, Version sourceVersion) {
        return MigrationUtils.isProtected(Paths.get(tgtFilename, new String[0]), sourceVersion);
    }

    public static boolean isProtected(Path tgtPath, Version sourceVersion) {
        if (sourceVersion.major() == 4) {
            return true;
        }
        String topName = tgtPath.getName(0).toString();
        if (protectedStationHomeNames.contains(topName)) {
            return true;
        }
        for (String pattern : protectedStationHomePatterns) {
            if (!tgtPath.toString().matches(pattern)) continue;
            return true;
        }
        return false;
    }

    public static String dumpToString(XElem x) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            XWriter w = new XWriter((OutputStream)os);
            x.write(w);
            w.flush();
            return new String(os.toByteArray());
        }
        catch (Exception e) {
            return x.toString();
        }
    }

    public static BIFile[] getDefaultMigStationTemplates() {
        try {
            BDirectory directory = (BDirectory)BOrd.make((String)NIAGARA_MIGRATION_TEMPLATES_DIR).get();
            return directory.listFiles();
        }
        catch (UnresolvedException e) {
            return EMPTY_BIFILE_ARRAY;
        }
    }

    public static BIFile[] getUserMigStationTemplates() {
        try {
            return BFileSystem.INSTANCE.makeDir(USER_MIGRATION_TEMPLATES_DIR, null).listFiles();
        }
        catch (Exception e) {
            return EMPTY_BIFILE_ARRAY;
        }
    }

    public static BDirectory getUserMigStationDirectory() {
        try {
            return BFileSystem.INSTANCE.makeDir(USER_MIGRATION_TEMPLATES_DIR);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BIFile[] getMigStationTemplates() {
        BIFile[] biFiles;
        ArrayList<BIFile> templates = new ArrayList<BIFile>();
        Collections.addAll(templates, MigrationUtils.getDefaultMigStationTemplates());
        for (BIFile newFile : biFiles = MigrationUtils.getUserMigStationTemplates()) {
            ListIterator iterator = templates.listIterator();
            boolean exist = false;
            while (iterator.hasNext()) {
                BIFile next = (BIFile)iterator.next();
                if (!newFile.getFileName().equals(next.getFileName())) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            templates.add(newFile);
        }
        return (BIFile[])templates.stream().filter(obj -> obj instanceof BIFile && obj instanceof BITemplate && !(obj instanceof BDirectory) && "ntpl".equals(obj.getExtension())).toArray(BIFile[]::new);
    }

    public static Version getVersion(DistributionManifest manifest, String moduleOrTspec) {
        BDependency[] deps;
        if (manifest == null) {
            return BIBogElementConverter.VERSION_3_8;
        }
        if (moduleOrTspec == null) {
            return BIBogElementConverter.VERSION_3_8;
        }
        if (moduleOrTspec.contains(":")) {
            moduleOrTspec = moduleOrTspec.split(":")[0];
        }
        for (BDependency dep : deps = manifest.getDependencies()) {
            if (!dep.getPartName().equals(moduleOrTspec)) continue;
            return dep.getVersion().getVendorVersion();
        }
        return BIBogElementConverter.VERSION_3_8;
    }

    public static String getUserInput() throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        return br.readLine().toLowerCase();
    }

    static {
        protectedStationHomeNames.add("alarm");
        protectedStationHomeNames.add("dataRecovery");
        protectedStationHomeNames.add("history");
        protectedStationHomeNames.add("logging");
        protectedStationHomeNames.add("provisioningNiagara");
        protectedStationHomeNames.add("webLogs");
        protectedStationHomeNames.add("ldap");
        protectedStationHomeNames.add("config.bog");
        protectedStationHomeNames.add("alarm.zip");
        protectedStationHomeNames.add("console.txt");
        protectedStationHomePatterns = new ArrayList();
        protectedStationHomePatterns.add(".*_nVirtual");
        protectedStationHomePatterns.add("config.*\\.bog");
        protectedStationHomePatterns.add("console\\..*\\.txt");
        migTempDir = new File(Sys.getNiagaraUserHome(), MIG_TEMP_DIR_NAME);
        USER_MIGRATION_TEMPLATES_DIR = new FilePath("~migrationTemplates");
        EMPTY_BIFILE_ARRAY = new BIFile[0];
    }
}

