/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.file.types.bog.BBogSpace;
import com.tridium.file.types.bog.CannotLoadBogException;
import com.tridium.migrator.BBogMigrator;
import com.tridium.nre.util.FileLockException;
import java.io.File;
import java.text.MessageFormat;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BLocalFileStore;
import javax.baja.io.ValueDocDecoder;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BMigrationBogFile
extends BBogFile {
    @Generated
    public static final Type TYPE = Sys.loadType(BMigrationBogFile.class);
    private final Lexicon lex = Lexicon.make((String)"migrator");
    ValueDocDecoder.ITypeResolver resolver;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BMigrationBogFile(File file, ValueDocDecoder.ITypeResolver resolver) {
        super((BIFileStore)new BLocalFileStore((BFileSpace)BFileSystem.INSTANCE, BFileSystem.INSTANCE.localFileToPath(file), file));
        this.resolver = resolver;
    }

    public BMigrationBogFile(BIFile file, ValueDocDecoder.ITypeResolver resolver) {
        super(file.getStore());
        this.resolver = resolver;
    }

    public BMigrationBogFile() {
    }

    protected BSpace doOpen() {
        BBogSpace space = new BBogSpace((BBogFile)this);
        try {
            space.checkLock();
            ValueDocDecoder decoder = this.getDecoder();
            decoder.setLog(BBogMigrator.log);
            decoder.setTypeResolver(this.resolver);
            BValue valRoot = decoder.decodeDocument();
            this.processHeaderInformation(decoder, space);
            if (!valRoot.isComponent()) {
                throw new IllegalArgumentException(MessageFormat.format(this.lex.getText("bogMigrator.bogRootIsComplex"), this.getAbsoluteOrd()));
            }
            BComponent root = valRoot.asComponent();
            space.setRootComponent(root);
            BBogSpace.activateLinks((BComponent)root);
        }
        catch (FileLockException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CannotLoadBogException(this.getAbsoluteOrd().toString(), (Throwable)e);
        }
        return space;
    }
}

