/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fcModelSyncNiagara;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.nc.CloudUtilities;
import com.tridium.nc.cmds.BCloudWriteInfo;
import com.tridium.nc.point.BCloudProxyExt;
import com.tridium.nc.point.BCloudTuningPolicy;
import com.tridium.nc.point.BCloudWriteController;
import com.tridium.nc.point.ICloudWriter;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BNiagaraProxyExt;
import com.tridium.nd.point.BPointChannel;
import com.tridium.util.CompUtil;
import java.util.logging.Level;
import javax.baja.control.BControlPoint;
import javax.baja.naming.BOrd;
import javax.baja.registry.Registry;
import javax.baja.registry.TypeInfo;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BConversionLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BConverter;

public class FoxCloudWriter
implements ICloudWriter,
BFoxClientConnection.Interest {
    public boolean write(BCloudWriteInfo writeInfo, BControlPoint cloudProxyPoint, String writeInfoName, String targetSlotName, BRelTime duration) {
        try {
            BCloudProxyExt proxyExt = CloudUtilities.cloudProxy((BControlPoint)cloudProxyPoint);
            log.fine(() -> String.format("FoxCloudWriter: writing '%s' to slot '%s' through cloud proxy point '%s' [pointId %s]", writeInfo.getValue(), targetSlotName, proxyExt.getParentPoint().getName(), proxyExt.getPointId()));
            this.writeDirect(proxyExt, writeInfo, targetSlotName);
            CompUtil.setOrAdd((BComponent)cloudProxyPoint, (String)writeInfoName, (BValue)writeInfo, (int)3, null, null);
            if (duration.getMillis() > 0L) {
                writeInfo.setExpiration(BAbsTime.now().add(duration));
                writeInfo.makeTicket();
            }
            return true;
        }
        catch (Exception e) {
            log.info(() -> String.format("FoxCloudWriter:exception writing point:%s", CloudUtilities.cloudProxy((BControlPoint)cloudProxyPoint).getPointId()));
            return false;
        }
    }

    public boolean clear(BControlPoint cloudProxyPoint, int priority, BCloudWriteInfo writeInfo) {
        if (writeInfo == null) {
            BCloudProxyExt proxyExt = CloudUtilities.cloudProxy((BControlPoint)cloudProxyPoint);
            BControlPoint stationPoint = CloudUtilities.cloudProxy((BControlPoint)cloudProxyPoint).getPoint();
            int ptPri = this.getPointActivePriority(stationPoint);
            log.fine(String.format("FoxCloudWriter: cloud write info not present at '%s' for a cloud proxy point '%s' [pointId %s]", ptPri, proxyExt.getParentPoint().getName(), proxyExt.getPointId()));
            BStatus targetPointStatusValue = stationPoint.getOutStatusValue().getStatus();
            if (!targetPointStatusValue.isStale() && !targetPointStatusValue.isDown()) {
                if (ptPri == priority) {
                    BCloudWriteInfo newWriteInfo = new BCloudWriteInfo();
                    newWriteInfo.setValue((BStatusValue)stationPoint.getOutStatusValue().newCopy());
                    BCloudTuningPolicy policy = proxyExt.getCloudTuningPolicy();
                    String targetSlotName = BCloudWriteController.getTargetSlotName((int)priority, (int)policy.getDefaultPriority().getOrdinal());
                    String writeInfoName = BCloudWriteController.getCloudWriteInfoName((int)priority, (int)policy.getDefaultPriority().getOrdinal());
                    if (!this.write(newWriteInfo, cloudProxyPoint, writeInfoName, targetSlotName, BRelTime.make((long)0L))) {
                        return false;
                    }
                    stationPoint.doExecute();
                    writeInfo = newWriteInfo;
                }
            } else {
                return false;
            }
        }
        writeInfo.getValue().setStatusNull(true);
        String slotName = FoxCloudWriter.getSlotName(priority);
        try {
            BCloudProxyExt proxyExt = CloudUtilities.cloudProxy((BControlPoint)cloudProxyPoint);
            log.fine(String.format("FoxCloudWriter: clearing slot '%s' through cloud proxy point '%s' [pointId %s] with value %s", slotName, proxyExt.getParentPoint().getName(), proxyExt.getPointId(), writeInfo.getValue()));
            this.writeDirect(proxyExt, writeInfo, slotName);
            cloudProxyPoint.remove(writeInfo.getName());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void controllerEnabled(BControlPoint cloudProxyPoint, BCloudWriteInfo writeInfo, boolean enabled) {
        try {
            log.finest(() -> String.format("FoxCloudWriter.setEnabled(): pt=%s; info=%s; enabled=%s", cloudProxyPoint.getSlotPath(), writeInfo.toDebugString(), enabled));
            this.writeDirect(CloudUtilities.cloudProxy((BControlPoint)cloudProxyPoint), writeInfo, FoxCloudWriter.getSlotName(BCloudWriteController.getPriority((String)writeInfo.getName())));
        }
        catch (Exception e) {
            log.log(Level.INFO, String.format("Could not propagate enabled status change [%s] to target point %s: %s", enabled, cloudProxyPoint.getSlotPath(), e), log.isLoggable(Level.FINE) ? e : null);
        }
    }

    private void writeDirect(BCloudProxyExt proxyExt, BCloudWriteInfo writeInfo, String targetSlotName) throws Exception {
        BStatusValue writeValue;
        BControlPoint ndPoint = (BControlPoint)proxyExt.getOrdPath().get((BObject)proxyExt);
        BNiagaraProxyExt ndProxyExt = (BNiagaraProxyExt)ndPoint.getProxyExt().as(BNiagaraProxyExt.class);
        String pointId = ndProxyExt.getPointId();
        BPointChannel ptChannel = this.getPointChannel(ndProxyExt);
        Property tgtProp = proxyExt.getPoint().getOutProperty();
        Type writeType = writeInfo.getValue().getType();
        Type targetType = tgtProp.getType();
        Registry registry = Sys.getRegistry();
        TypeInfo[] adapters = registry.getAdapters(writeType.getTypeInfo(), targetType.getTypeInfo());
        BConverter converter = null;
        for (int i = adapters.length - 1; i >= 0; --i) {
            if (!registry.isAgent(adapters[i], BConversionLink.TYPE.getTypeInfo())) continue;
            converter = (BConverter)adapters[i].getInstance();
            break;
        }
        if (converter == null) {
            writeValue = writeInfo.getValue();
        } else {
            writeValue = (BStatusValue)targetType.getInstance();
            converter.convert((BObject)writeInfo.getValue(), (BObject)writeValue, (Context)ndPoint.getFacets());
        }
        ptChannel.write(BOrd.make((String)("station:|" + pointId)), targetSlotName, (BValue)writeValue);
    }

    public static String getSlotName(int priority) {
        return priority < 1 || priority > 16 ? "fallback" : "in" + priority;
    }

    protected BPointChannel getPointChannel(BNiagaraProxyExt ndProxyExt) throws Exception {
        BNiagaraStation station = ndProxyExt.getNiagaraStation();
        BFoxClientConnection connection = station.getClientConnection();
        connection.engageNoRetry((BFoxClientConnection.Interest)this);
        return (BPointChannel)connection.getChannels().get("point", BPointChannel.TYPE);
    }
}

