/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.message;

import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.enums.BAceReqActionTypeEnum;
import com.tridium.ace.message.AceMessage;
import com.tridium.ndriver.io.TypedInputStream;
import com.tridium.ndriver.io.TypedOutputStream;
import javax.baja.sys.BajaRuntimeException;

public class AceComponentReq
extends AceMessage {
    String compName;
    String parentName;
    String typeName;
    String newName = "";
    BAceReqActionTypeEnum action;

    public AceComponentReq() {
        super(8);
    }

    public static AceComponentReq makeAdd(BAceComponent c) {
        AceComponentReq nac = new AceComponentReq();
        nac.action = BAceReqActionTypeEnum.add;
        nac.compName = c.getAceComponentName();
        nac.parentName = ((BAceComponent)c.getParent()).getAceFullPathName();
        nac.typeName = c.getAceKitName() + "::" + c.getAceTypeName();
        nac.setNextTag();
        return nac;
    }

    public static AceComponentReq makeRemove(String cName) {
        AceComponentReq nac = new AceComponentReq();
        nac.action = BAceReqActionTypeEnum.delete;
        nac.compName = cName;
        nac.setNextTag();
        return nac;
    }

    public static AceComponentReq makeRename(String oName, String nName) {
        AceComponentReq nac = new AceComponentReq();
        nac.action = BAceReqActionTypeEnum.rename;
        nac.compName = oName;
        nac.newName = nName;
        nac.setNextTag();
        return nac;
    }

    @Override
    protected void toTypedOutputStream(TypedOutputStream out) {
        String str = this.compName;
        if (str.length() > 255) {
            throw new BajaRuntimeException("Name exceeds maximum allowed string length");
        }
        out.writeUnsigned8(this.action.getOrdinal());
        out.writeUnsigned8(str.length());
        out.writeCharArray(str, str.length());
        if (this.action.isAdd()) {
            if (str.length() > 32) {
                throw new BajaRuntimeException("Component name exceeds maximum allowed length");
            }
            str = this.parentName;
            if (str.length() > 255) {
                throw new BajaRuntimeException("Parent full path name exceeds maximum allowed string length");
            }
            out.writeUnsigned8(str.length());
            out.writeCharArray(str, str.length());
            str = this.typeName;
            if (str.length() > 98) {
                throw new BajaRuntimeException("Type name exceeds maximum allowed length");
            }
            out.writeUnsigned8(str.length());
            out.writeCharArray(str, str.length());
        } else if (this.action.isRename()) {
            str = this.newName;
            if (str.length() > 32) {
                throw new BajaRuntimeException("Component name exceeds maximum allowed length");
            }
            out.writeUnsigned8(str.length());
            out.writeCharArray(str, str.length());
        }
    }

    @Override
    protected void fromTypedInputStream(TypedInputStream in) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    protected void toTraceString(StringBuffer sb) {
        sb.append("action:").append((Object)this.action);
        sb.append(" comp:").append(this.compName).append("\n");
        if (this.action.isAdd()) {
            sb.append("parentName:").append(this.parentName).append("\n");
            sb.append("typeName:").append(this.typeName).append("\n");
        }
        if (this.action.isRename()) {
            sb.append("newName:").append(this.newName).append("\n");
        }
    }
}

