/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.json;

import com.tridium.ace.json.JSlot;
import com.tridium.ace.kit.AceSlot;
import com.tridium.ace.kit.AceType;
import com.tridium.ace.kit.CatalogKit;
import com.tridium.ace.sys.AceException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BFacets;

public class JComponent
implements AceType {
    private String aceType = "";
    private CatalogKit kit;
    private List<AceSlot> slots = new ArrayList<AceSlot>();
    private Map<String, Integer> slotIndices = new HashMap<String, Integer>();
    BFacets facets = BFacets.DEFAULT;

    public void addSlot(JSlot js) {
        if (this.slotIndices.get(js.getName()) != null) {
            throw new AceException(String.format("Can't add duplicate slot %s to component type %s", js.getName(), this.getTypeName()));
        }
        this.slotIndices.put(js.getName(), this.slots.size());
        this.slots.add(js);
    }

    public void setKit(CatalogKit kit) {
        this.kit = kit;
    }

    public void setAceType(String aceType) {
        this.aceType = aceType;
    }

    @Override
    public AceSlot getSlot(String slotName) {
        Integer slotIndex = this.slotIndices.get(slotName);
        if (slotIndex == null) {
            return null;
        }
        return this.slots.get(slotIndex);
    }

    @Override
    public int compareTo(AceType that) {
        if (that == null) {
            return -1;
        }
        return this.toString().compareTo(that.toString());
    }

    public boolean equals(Object obj) {
        if (obj instanceof AceType) {
            return ((AceType)obj).getTypeName().equals(this.getTypeName());
        }
        return false;
    }

    public int hashCode() {
        return this.slots.hashCode();
    }

    @Override
    public String getTypeName() {
        return this.aceType;
    }

    @Override
    public String getKitName() {
        if (this.kit != null) {
            return this.kit.name();
        }
        return null;
    }

    @Override
    public CatalogKit getKit() {
        return this.kit;
    }

    @Override
    public List<AceSlot> getSlots() {
        return this.slots;
    }

    @Override
    public Integer getSlotIndex(String slotName) {
        return this.slotIndices.get(slotName);
    }

    @Override
    public void addFacet(String name, BIDataValue value) {
        this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)name, (BIDataValue)value));
    }

    @Override
    public BFacets getFacets() {
        return this.facets;
    }
}

