/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.app;

import com.tridium.ace.app.App;
import com.tridium.ace.app.Component;
import com.tridium.ace.app.ConfigValue;
import com.tridium.ace.app.Link;
import com.tridium.ace.component.AceUtil;
import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.component.BAceTextBlock;
import com.tridium.ace.datatypes.BIAceInteger;
import com.tridium.ace.datatypes.InvalidTypeException;
import com.tridium.ace.enums.BAceSlotTypeEnum;
import com.tridium.ace.kit.AceSlot;
import com.tridium.ace.kit.AceType;
import com.tridium.ace.kit.Catalog;
import com.tridium.ace.kit.CatalogKit;
import com.tridium.ace.kit.Kit;
import com.tridium.ace.sys.AceException;
import com.tridium.ace.sys.BAceApp;
import com.tridium.driver.util.StringUtil;
import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.util.CompUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.status.BIStatusValue;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.Lexicon;

public abstract class AceAppReader {
    private static final Logger LOG = Logger.getLogger("AceNetwork");
    private static Lexicon lex = Lexicon.make((String)"ace");
    private boolean online = false;
    private List<String> typeList = new ArrayList<String>();

    public AceAppReader() {
        this.online = false;
    }

    public AceAppReader(boolean online) {
        this.online = online;
    }

    public abstract App decode(InputStream var1, Catalog var2) throws IOException;

    public abstract Catalog decodeCatalog(InputStream var1) throws Exception;

    public App decode(BOrd ord, Catalog catalog) throws IOException {
        BIFile f = (BIFile)ord.resolve().get();
        return this.decode(f.getInputStream(), catalog);
    }

    public BAceApp loadAceApp(InputStream inputStream, Catalog catalog) throws Exception {
        App app = this.decode(inputStream, catalog);
        BAceApp aceApp = this.buildAceApp(app, catalog);
        return aceApp;
    }

    public BAceApp buildAceApp(App app, Catalog catalog) throws InvalidTypeException {
        HashMap<Integer, BAceComponent> aceComponents = new HashMap<Integer, BAceComponent>();
        BAceApp aceApp = this.buildComponentTree(app, aceComponents, catalog);
        this.buildLinks(app, aceComponents);
        return aceApp;
    }

    public BAceApp buildComponentTree(App aceApp, Map<Integer, BAceComponent> aceComponents, Catalog catalog) throws InvalidTypeException {
        if (aceApp == null) {
            return null;
        }
        Component appComp = aceApp.getRootComponent();
        if (appComp == null) {
            throw new AceException(lex.getText("json.appComponentError"));
        }
        for (Kit appKit : aceApp.getKits()) {
            CatalogKit catalogKit = catalog.get(appKit.getName());
            if (catalogKit != null) continue;
            LOG.warning(lex.getText("ace.kitNotFound", new Object[]{appKit.getName()}));
        }
        CatalogKit kit = catalog.get(appComp.getKitName());
        if (kit == null) {
            throw new AceException(lex.getText("json.componentRegistryKitError", new Object[]{appComp.getName(), appComp.getKitName()}));
        }
        AceType aceType = kit.type(appComp.getTypeName());
        if (aceType == null) {
            throw new AceException(lex.getText("json.componentRegistryError", new Object[]{appComp.getName(), appComp.getTypeName()}));
        }
        BAceApp topComp = (BAceApp)aceType.newInstance(this.online);
        if (topComp == null) {
            throw new AceException(lex.getText("json.appComponentError"));
        }
        this.getConfigs(appComp, topComp);
        for (Component childComp : appComp.getChildren()) {
            BAceComponent aceComp = this.getComponent(catalog, childComp, aceComponents);
            if (aceComp == null) continue;
            topComp.add(childComp.getName(), (BValue)aceComp, Context.decoding);
            aceComponents.put(childComp.getId(), aceComp);
        }
        aceComponents.put(appComp.getId(), topComp);
        return topComp;
    }

    protected void buildLinks(App aceApp, Map<Integer, BAceComponent> aceComponents) {
        for (Link link : aceApp.getLinks()) {
            int fromComponentId = link.getFromComponentId();
            String fromSlotName = link.getFromSlotName();
            int toComponentId = link.getToComponentId();
            String toSlotName = link.getToSlotName();
            BAceComponent sourceComponent = aceComponents.get(fromComponentId);
            if (sourceComponent == null) {
                throw new AceException(lex.getText("json.componentLinkError", new Object[]{fromComponentId, fromSlotName}));
            }
            BAceComponent targetComponent = aceComponents.get(toComponentId);
            if (targetComponent == null) {
                throw new AceException(lex.getText("json.componentLinkError", new Object[]{toComponentId, toSlotName}));
            }
            Slot srcSlot = sourceComponent.getSlot(fromSlotName);
            Slot tgtSlot = targetComponent.getSlot(toSlotName);
            if (srcSlot == null) {
                LOG.warning("Invalid link source slot - " + sourceComponent.getDisplayName(null) + "(" + sourceComponent.getObjectId() + "):" + fromSlotName);
                continue;
            }
            if (tgtSlot == null) {
                LOG.warning("Invalid link target slot - " + targetComponent.getDisplayName(null) + "(" + targetComponent.getObjectId() + "):" + toSlotName);
                continue;
            }
            BLink newLink = targetComponent.makeLink(sourceComponent, srcSlot, tgtSlot, Context.NULL);
            targetComponent.add(null, (BValue)newLink, 2, Context.decoding);
        }
    }

    protected BAceComponent getComponent(Catalog catalog, Component childComp, Map<Integer, BAceComponent> aceComponents) throws InvalidTypeException {
        CatalogKit kit = catalog.get(childComp.getKitName());
        if (kit == null) {
            throw new AceException(lex.getText("json.componentRegistryKitError", new Object[]{childComp.getName(), childComp.getKitName()}));
        }
        AceType aceType = kit.type(childComp.getTypeName());
        if (aceType == null) {
            throw new AceException(lex.getText("json.componentRegistryError", new Object[]{childComp.getName(), childComp.getTypeName()}));
        }
        BAceComponent compInstance = aceType.newInstance(this.online);
        compInstance.setObjectId(childComp.getId());
        ((ComponentSlotMap)compInstance.fw(1)).setHandle((Object)Integer.toString(childComp.getId()));
        ConfigValue meta = childComp.getConfigValues().get("meta");
        if (meta != null) {
            int metaInt = ((BInteger)meta.getValue()).getInt();
            BWsAnnotation annotation = AceUtil.decodeWsAnnotationFromMeta(metaInt);
            if (compInstance instanceof BAceTextBlock) {
                annotation = this.makeTextBlockAnnotation(childComp, annotation);
            }
            if (metaInt > 0) {
                CompUtil.setOrAdd((BComponent)compInstance, (String)"wsAnnotation", (BValue)annotation, (Context)Context.decoding);
            }
            compInstance.setMeta(metaInt);
        }
        this.getConfigs(childComp, compInstance);
        for (Component child : childComp.getChildren()) {
            BAceComponent newComp = this.getComponent(catalog, child, aceComponents);
            compInstance.add(child.getName(), (BValue)newComp, Context.decoding);
            aceComponents.put(child.getId(), newComp);
        }
        return compInstance;
    }

    private void getConfigs(Component childComp, BAceComponent compInstance) {
        for (Map.Entry<String, ConfigValue> configEntry : childComp.getConfigValues().entrySet()) {
            ConfigValue config = configEntry.getValue();
            try {
                Property configProp = compInstance.getProperty(configEntry.getKey());
                BValue currVal = compInstance.get(configProp);
                Object configValue = config.getValue();
                if (currVal instanceof BStatusEnum || currVal instanceof BDynamicEnum) {
                    BEnumRange range = ((BIEnum)currVal).getEnum().getRange();
                    int ord = configValue instanceof BStatusNumeric ? (int)((BStatusNumeric)configValue).getNumeric() : ((BNumber)configValue).getInt();
                    BDynamicEnum de = BDynamicEnum.make((int)ord, (BEnumRange)range);
                    configValue = configValue instanceof BIStatusValue ? new BStatusEnum((BEnum)de, ((BIStatusValue)configValue).getStatus()) : de;
                } else if (currVal instanceof BIAceInteger) {
                    int n = ((BInteger)configValue).getInt();
                    configValue = ((BIAceInteger)currVal).make(n).asValue();
                }
                if (currVal instanceof BEnumRange) {
                    configValue = (BValue)((BEnumRange)currVal).decodeFromString(configValue.toString(null));
                }
                compInstance.set(configProp, (BValue)configValue);
            }
            catch (Exception e) {
                LOG.warning(lex.getText("json.configNotLoaded", new Object[]{childComp.getName(), configEntry.getKey()}));
                LOG.fine(lex.getText("json.configErrorDetail", new Object[]{e.getLocalizedMessage()}));
            }
        }
    }

    protected void addTypeList(BValue configValue, BFacets f) {
        if (configValue == null) {
            String agent = f.gets("agent", "");
            this.addToTypeList("ACE.ACE_AGENT", agent);
            String command = f.gets("command", "");
            this.addToTypeList("command", command);
            String ntype = f.gets(BAceSlotTypeEnum.niagaraType.getTag(), "");
            this.addToTypeList(BAceSlotTypeEnum.niagaraType.getTag(), ntype);
            BValue enumList = (BValue)f.get(BAceSlotTypeEnum.enumList.getTag());
            if (enumList != null && enumList.toString().startsWith("|")) {
                String er = enumList.toString().substring(1);
                this.addToTypeList(BAceSlotTypeEnum.enumRange.getTag(), er);
            }
            String fieldEditor = f.gets(BAceSlotTypeEnum.fieldEditor.getTag(), "");
            this.addToTypeList(BAceSlotTypeEnum.fieldEditor.getTag(), fieldEditor);
        } else if (f.get(BAceSlotTypeEnum.enumRange.getTag()) != null) {
            this.addToTypeList(BAceSlotTypeEnum.enumRange.getTag(), configValue.toString(null));
        }
        this.typeList.sort(null);
    }

    private void addToTypeList(String anno, String val) {
        int moduleIdx = val.indexOf(":");
        if (moduleIdx > 0) {
            try {
                Type tp = null;
                tp = Sys.getType((String)val);
            }
            catch (ModuleNotFoundException e) {
                String[] split = val.split(":");
                String module = split[0];
                String typeStr = anno + ":" + module;
                if (!this.typeList.contains(typeStr)) {
                    this.typeList.add(typeStr);
                }
            }
            catch (Exception e) {
                LOG.warning("in addToTypeList, caught exception " + e);
            }
        }
    }

    protected void getTypeListFromFacets(AceType at) {
        if (!at.getFacets().equals((Object)BFacets.DEFAULT)) {
            this.addTypeList(null, at.getFacets());
        }
        List<AceSlot> slots = at.getSlots();
        for (AceSlot slot : slots) {
            this.addTypeList(null, slot.getFacets().toFacets());
        }
    }

    private BWsAnnotation makeTextBlockAnnotation(Component childComp, BWsAnnotation annotation) {
        ConfigValue height = childComp.getConfigValues().get("wsHeight");
        ConfigValue width = childComp.getConfigValues().get("wsWidth");
        int wh = 2;
        int ww = 8;
        if (height == null) {
            LOG.warning(lex.getText("json.configNotLoaded", new Object[]{childComp.getName(), "wsHeight"}));
        } else {
            wh = ((BInteger)height.getValue()).getInt();
        }
        if (width == null) {
            LOG.warning(lex.getText("json.configNotLoaded", new Object[]{childComp.getName(), "wsWidth"}));
        } else {
            ww = ((BInteger)width.getValue()).getInt();
        }
        return BWsAnnotation.make((int)annotation.p, (int)annotation.q, (int)ww, (int)wh);
    }

    public String verifyTypes() {
        String[] arr = this.typeList.toArray(new String[0]);
        return StringUtil.toString((String[])arr, (String)"\n");
    }
}

