/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sms.util;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.nre.util.TextUtil;
import javax.baja.util.Lexicon;

public final class SmsToolkit {
    public static final Logger log = Logger.getLogger("sms");
    private static final Lexicon lex = Lexicon.make(SmsToolkit.class);
    public static final HashMap<String, Integer> escapeCharHashTable = new HashMap();

    public static boolean isValidPhoneNumber(String phoneNumber) {
        char[] digits = SmsToolkit.removeSpaceCharacters(phoneNumber).toCharArray();
        if (digits.length == 0) {
            return false;
        }
        for (int i = 0; i < digits.length; ++i) {
            char d = digits[i];
            if (i == 0 && d == '+' || d == '0' || d == '1' || d == '2' || d == '3' || d == '4' || d == '5' || d == '6' || d == '7' || d == '8' || d == '9') continue;
            return false;
        }
        return true;
    }

    public static String removeSpaceCharacters(String phoneNumber) {
        phoneNumber = TextUtil.replace((String)phoneNumber, (String)" ", (String)"");
        phoneNumber = TextUtil.replace((String)phoneNumber, (String)"-", (String)"");
        phoneNumber = TextUtil.replace((String)phoneNumber, (String)".", (String)"");
        phoneNumber = TextUtil.replace((String)phoneNumber, (String)"(", (String)"");
        phoneNumber = TextUtil.replace((String)phoneNumber, (String)")", (String)"");
        phoneNumber = TextUtil.replace((String)phoneNumber, (String)",", (String)"");
        return phoneNumber;
    }

    public static byte[] filterForEscapeCharacters(String str) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Filtering this escape bytes: " + ByteArrayUtil.toHexString((byte[])str.getBytes(), (int)0, (int)str.getBytes().length));
        }
        ByteBuffer buff = new ByteBuffer(str.length());
        Integer currentInt = null;
        for (int i = 0; i < str.length(); ++i) {
            currentInt = escapeCharHashTable.get(String.valueOf(str.charAt(i)));
            if (currentInt != null) {
                buff.write((int)((byte)(0xFF & currentInt)));
                continue;
            }
            buff.write((int)((byte)(0xFF & str.charAt(i))));
        }
        byte[] retBytes = buff.toByteArray();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Filtered this escape bytes: " + ByteArrayUtil.toHexString((byte[])retBytes, (int)0, (int)retBytes.length) + " with length: " + retBytes.length);
        }
        return retBytes;
    }

    public static String getText(String lexStr) {
        return lex.getText(lexStr);
    }

    static {
        escapeCharHashTable.put("@", 0);
        escapeCharHashTable.put("\u00a3", 1);
        escapeCharHashTable.put("$", 2);
        escapeCharHashTable.put("\u00a5", 3);
        escapeCharHashTable.put("\u00e8", 4);
        escapeCharHashTable.put("\u00e9", 5);
        escapeCharHashTable.put("\u00f9", 6);
        escapeCharHashTable.put("\u00ec", 7);
        escapeCharHashTable.put("\u00f2", 8);
        escapeCharHashTable.put("\u00c7", 9);
        escapeCharHashTable.put("\u00d8", 11);
        escapeCharHashTable.put("\u00f8", 12);
        escapeCharHashTable.put("\u00c5", 14);
        escapeCharHashTable.put("\u00e5", 15);
        escapeCharHashTable.put("\u2206", 16);
        escapeCharHashTable.put("_", 17);
        escapeCharHashTable.put("\u0424", 18);
        escapeCharHashTable.put("\u0393", 19);
        escapeCharHashTable.put("\u039b", 20);
        escapeCharHashTable.put("\u03a9", 21);
        escapeCharHashTable.put("\u03c0", 22);
        escapeCharHashTable.put("\u03a8", 23);
        escapeCharHashTable.put("\u03a3", 24);
        escapeCharHashTable.put("\u0398", 25);
        escapeCharHashTable.put("\u039e", 26);
        escapeCharHashTable.put("\u00c6", 28);
        escapeCharHashTable.put("\u00e6", 29);
        escapeCharHashTable.put("\u00df", 30);
        escapeCharHashTable.put("\u00c8", 31);
        escapeCharHashTable.put("\u00c4", 91);
        escapeCharHashTable.put("\u00d6", 92);
        escapeCharHashTable.put("\u00d1", 93);
        escapeCharHashTable.put("\u00dc", 94);
        escapeCharHashTable.put("\u00a7", 95);
        escapeCharHashTable.put("\u00bf", 95);
        escapeCharHashTable.put("\u00e4", 123);
        escapeCharHashTable.put("\u00f6", 124);
        escapeCharHashTable.put("\u00f1", 125);
        escapeCharHashTable.put("\u00fc", 126);
        escapeCharHashTable.put("\u00e0", 127);
    }
}

