/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sms.serial.command;

import com.tridium.sms.gprs.BGprsSmsTransport;
import com.tridium.sms.serial.command.SmsCommand;
import com.tridium.sms.util.SmsToolkit;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class SmsSignalStrengthCommand
extends SmsCommand {
    private double signalStrength = 0.0;

    public SmsSignalStrengthCommand(SmsCommand.ICommsImplementer comms) {
        super(comms);
    }

    @Override
    public boolean doRun() {
        boolean success;
        block11: {
            success = false;
            try {
                if (this.comms instanceof BGprsSmsTransport) {
                    int serviceStateMsgStart;
                    if (SmsToolkit.log.isLoggable(Level.FINE)) {
                        SmsToolkit.log.fine("Running on an internal GRPS Modem board");
                    }
                    String reply = this.comms.write("AT^MONI\r", "OK\r\n");
                    if ((reply = reply.toLowerCase()).indexOf("searching", serviceStateMsgStart = reply.indexOf("serving cell")) != -1) {
                        if (SmsToolkit.log.isLoggable(Level.FINE)) {
                            SmsToolkit.log.fine("MONI Response shows modem as searching for a network, setting signal stren to 0");
                        }
                        this.signalStrength = 0.0;
                        success = true;
                    } else if (reply.indexOf("limited service", serviceStateMsgStart) != -1) {
                        if (SmsToolkit.log.isLoggable(Level.FINE)) {
                            SmsToolkit.log.fine("MONI Response shows modem as having limited service, setting signal stren to 0");
                        }
                        this.signalStrength = 0.0;
                        success = true;
                    }
                }
                if (!success) {
                    if (SmsToolkit.log.isLoggable(Level.FINE)) {
                        SmsToolkit.log.fine("Reading normal signal strength");
                    }
                    success = this.parseSignalStrengthFromCsq(this.comms.write("AT+CSQ\r", "OK\r\n"));
                }
            }
            catch (Exception e) {
                if (!SmsToolkit.log.isLoggable(Level.FINE)) break block11;
                SmsToolkit.log.fine("SMSSignalStrengthCommand.execute(CommsManager): Failed to send message through SMS manager");
            }
        }
        return success;
    }

    public boolean parseSignalStrengthFromCsq(String reply) {
        boolean res = false;
        try {
            Pattern pattern = Pattern.compile("\\+[Cc][Ss][Qq]\\: *([0-9]+)");
            Matcher matcher = pattern.matcher(reply);
            if (matcher.find()) {
                String strength = matcher.group(1);
                if (SmsToolkit.log.isLoggable(Level.FINE)) {
                    SmsToolkit.log.fine("AT+CSQ reports signal strength of " + strength);
                }
                this.signalStrength = SmsSignalStrengthCommand.getSignalStrengthAsPercentage(Double.parseDouble(strength));
                res = true;
            }
        }
        catch (PatternSyntaxException e) {
            SmsToolkit.log.log(Level.SEVERE, "Can't compile Signal Strength RegEx Pattern", e);
        }
        return res;
    }

    private static double getSignalStrengthAsPercentage(double nRawSignalStrength) {
        double nSignalStrength = 0.0;
        nSignalStrength = nRawSignalStrength > 31.0 ? 0.0 : nRawSignalStrength / 31.0 * 100.0;
        return Math.round(nSignalStrength);
    }

    public double getSignalStrength() {
        return this.signalStrength;
    }

    public String toString() {
        return SmsToolkit.getText("smsCommand.signal");
    }
}

