/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sms.gprs;

import com.tridium.sms.gprs.GprsCommTransaction;
import com.tridium.sms.util.SmsToolkit;
import java.io.InputStream;
import java.util.logging.Level;
import javax.baja.nre.util.ByteBuffer;

final class GprsCommReceiver
implements Runnable {
    private InputStream in = null;
    private boolean cancelled = false;
    private GprsCommTransaction commTransaction = null;
    private final Object cancelMutex = new Object();
    private final ByteBuffer rcvBuffer = new ByteBuffer();
    private static final byte[] linetermbytes = new byte[]{13, 10};

    GprsCommReceiver() {
    }

    @Override
    public void run() {
        if (SmsToolkit.log.isLoggable(Level.FINE)) {
            SmsToolkit.log.fine("GprsCommReceiver thread started");
        }
        while (!this.isCancelled()) {
            try {
                String recStr = this.receive();
                if (recStr == null || this.commTransaction == null) continue;
                this.commTransaction.check(recStr);
            }
            catch (Exception e) {
                SmsToolkit.log.log(Level.SEVERE, "Cancelling Sms CommReceiver", e);
                break;
            }
        }
        if (SmsToolkit.log.isLoggable(Level.FINE)) {
            SmsToolkit.log.fine("SmsCommReceiver thread shutdown");
        }
    }

    String receive() throws Exception {
        this.rcvBuffer.reset();
        try {
            boolean done = false;
            int lastChar = 0;
            while (!done) {
                InputStream inStr = this.getInputStream();
                if (inStr != null) {
                    lastChar = inStr.read();
                    if (lastChar < 0) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            done = true;
                        }
                    } else {
                        this.rcvBuffer.write(lastChar);
                        if (this.rcvBuffer.endsWith(linetermbytes)) {
                            if (SmsToolkit.log.isLoggable(Level.FINE)) {
                                this.rcvBuffer.dump();
                            }
                            return new String(this.rcvBuffer.toByteArray());
                        }
                    }
                } else {
                    done = true;
                }
                if (!this.isCancelled()) continue;
                break;
            }
        }
        catch (Exception e) {
            if (SmsToolkit.log.isLoggable(Level.FINE)) {
                SmsToolkit.log.log(Level.SEVERE, "Error in receive method for CommReceiver", e);
            }
            throw e;
        }
        return new String(this.rcvBuffer.toByteArray());
    }

    synchronized InputStream getInputStream() {
        return this.in;
    }

    synchronized void setInputStream(InputStream in) {
        this.in = in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCancelled() {
        boolean ret;
        Object object = this.cancelMutex;
        synchronized (object) {
            ret = this.cancelled;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCancelled(boolean cancelled) {
        Object object = this.cancelMutex;
        synchronized (object) {
            this.cancelled = cancelled;
        }
    }

    synchronized void setTransaction(GprsCommTransaction commTransaction) {
        this.commTransaction = commTransaction;
    }
}

