/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sms;

import com.tridium.sms.BSmsService;
import com.tridium.sms.SmsException;
import com.tridium.sms.util.SmsToolkit;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="id", type="int", defaultValue="0", flags=5), @NiagaraProperty(name="phoneNumbers", type="String", defaultValue="", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"sms:PhoneNumbersFE\"))")}), @NiagaraProperty(name="message", type="String", defaultValue="", facets={@Facet(value="BFacets.make(BFacets.MULTI_LINE, BBoolean.make(true))")})})
public final class BSmsMessage
extends BStruct {
    @Generated
    public static final Property id = BSmsMessage.newProperty((int)5, (int)0, null);
    @Generated
    public static final Property phoneNumbers = BSmsMessage.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"sms:PhoneNumbersFE")));
    @Generated
    public static final Property message = BSmsMessage.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)true)));
    @Generated
    public static final Type TYPE = Sys.loadType(BSmsMessage.class);
    private static final int MAX_CHAR_SIZE = 140;
    private static final BIcon icon = BIcon.make((String)"module://sms/res/smsMessage.png");

    @Generated
    public int getId() {
        return this.getInt(id);
    }

    @Generated
    public void setId(int v) {
        this.setInt(id, v, null);
    }

    @Generated
    public String getPhoneNumbers() {
        return this.getString(phoneNumbers);
    }

    @Generated
    public void setPhoneNumbers(String v) {
        this.setString(phoneNumbers, v, null);
    }

    @Generated
    public String getMessage() {
        return this.getString(message);
    }

    @Generated
    public void setMessage(String v) {
        this.setString(message, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSmsMessage() {
    }

    public BSmsMessage(String numbers, String msg) {
        this.setPhoneNumbers(numbers);
        this.setMessage(msg);
    }

    public BIcon getIcon() {
        return icon;
    }

    boolean send() throws SmsException {
        String[] numbers;
        String msg = this.getMessage();
        if (this.getService().getUseEscapeCharacters()) {
            msg = new String(SmsToolkit.filterForEscapeCharacters(msg));
        }
        if (msg.length() > 140) {
            msg = msg.substring(0, 140);
        }
        if ((numbers = TextUtil.splitAndTrim((String)this.getPhoneNumbers(), (char)';')).length <= 0) {
            throw new SmsException(SmsToolkit.getText("smsMessage.invalidNumber"));
        }
        boolean error = false;
        StringBuilder unsent = new StringBuilder();
        for (int i = 0; i < numbers.length; ++i) {
            if (this.getService().getNumberSentToday() >= this.getService().getMaxSendablePerDay()) {
                if (unsent.length() > 0) {
                    unsent.append(";");
                }
                unsent.append(numbers[i]);
                continue;
            }
            try {
                if (SmsToolkit.isValidPhoneNumber(numbers[i])) {
                    this.getService().getTransport().send(SmsToolkit.removeSpaceCharacters(numbers[i]), msg);
                    this.getService().setNumberSentToday(this.getService().getNumberSentToday() + 1);
                    this.getService().setLastMessageSentTime(BAbsTime.now());
                    continue;
                }
                SmsToolkit.log.log(Level.SEVERE, numbers[i] + " is not a valid number, skipping");
                continue;
            }
            catch (Exception e) {
                try {
                    SmsToolkit.log.log(Level.SEVERE, "Unable to send sms message", e);
                    error = true;
                    if (unsent.length() > 0) {
                        unsent.append(";");
                    }
                    unsent.append(numbers[i]);
                    continue;
                }
                catch (Exception e2) {
                    SmsToolkit.log.log(Level.SEVERE, "Fatal error. Unable to send sms message", e2);
                }
            }
        }
        String unsentStr = unsent.toString();
        this.setPhoneNumbers(unsentStr);
        if (unsentStr.length() == 0) {
            return true;
        }
        if (this.getService().getNumberSentToday() >= this.getService().getMaxSendablePerDay() && !error) {
            return false;
        }
        throw new SmsException(SmsToolkit.getText("smsMessage.errorUnsent") + ": " + unsentStr);
    }

    private BSmsService getService() {
        return (BSmsService)this.getParent().getParent();
    }
}

