/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.util;

import com.tridium.fox.sys.NiagaraStation;
import com.tridium.fox.sys.data.BIPostQueryFilter;
import com.tridium.fox.sys.data.BIPreQueryValidator;
import com.tridium.fox.sys.data.BTranslateOrdPostQueryFilter;
import com.tridium.fox.sys.data.EntityExportSource;
import com.tridium.fox.sys.data.TranslatedEntity;
import com.tridium.nd.BNSpaceScheme;
import com.tridium.nd.util.NiagaraDriverUtil;
import com.tridium.sys.station.BStationScheme;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BICategorizable;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.virtual.BVirtualGateway;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="translateOrds", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="failWhenFindExport", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="persistCategoryMask", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="allowVirtuals", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="tagsThatExcludeEntities", type="String", defaultValue="systemIndex:excluded", flags=1)})
public class BNiagaraRemoteQueryFilter
extends BStruct
implements BIPreQueryValidator,
BIPostQueryFilter {
    @Generated
    public static final Property translateOrds = BNiagaraRemoteQueryFilter.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property failWhenFindExport = BNiagaraRemoteQueryFilter.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property persistCategoryMask = BNiagaraRemoteQueryFilter.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property allowVirtuals = BNiagaraRemoteQueryFilter.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property tagsThatExcludeEntities = BNiagaraRemoteQueryFilter.newProperty((int)1, (String)"systemIndex:excluded", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraRemoteQueryFilter.class);

    @Generated
    public boolean getTranslateOrds() {
        return this.getBoolean(translateOrds);
    }

    @Generated
    public void setTranslateOrds(boolean v) {
        this.setBoolean(translateOrds, v, null);
    }

    @Generated
    public boolean getFailWhenFindExport() {
        return this.getBoolean(failWhenFindExport);
    }

    @Generated
    public void setFailWhenFindExport(boolean v) {
        this.setBoolean(failWhenFindExport, v, null);
    }

    @Generated
    public boolean getPersistCategoryMask() {
        return this.getBoolean(persistCategoryMask);
    }

    @Generated
    public void setPersistCategoryMask(boolean v) {
        this.setBoolean(persistCategoryMask, v, null);
    }

    @Generated
    public boolean getAllowVirtuals() {
        return this.getBoolean(allowVirtuals);
    }

    @Generated
    public void setAllowVirtuals(boolean v) {
        this.setBoolean(allowVirtuals, v, null);
    }

    @Generated
    public String getTagsThatExcludeEntities() {
        return this.getString(tagsThatExcludeEntities);
    }

    @Generated
    public void setTagsThatExcludeEntities(String v) {
        this.setString(tagsThatExcludeEntities, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BNiagaraRemoteQueryFilter make(boolean translateOrds, boolean failWhenFindExport) {
        BNiagaraRemoteQueryFilter filter = new BNiagaraRemoteQueryFilter();
        filter.setTranslateOrds(translateOrds);
        filter.setFailWhenFindExport(failWhenFindExport);
        return filter;
    }

    public static BNiagaraRemoteQueryFilter make(boolean translateOrds, boolean failWhenFindExport, boolean persistCategoryMask) {
        BNiagaraRemoteQueryFilter filter = new BNiagaraRemoteQueryFilter();
        filter.setTranslateOrds(translateOrds);
        filter.setFailWhenFindExport(failWhenFindExport);
        filter.setPersistCategoryMask(persistCategoryMask);
        return filter;
    }

    public void validateRemoteQuery(NiagaraStation querySourceStation, BOrdList queryOrds, int offset, int limit, Context cx) {
        if (this.getFailWhenFindExport() && BNiagaraRemoteQueryFilter.hasEnabledEntityExportSource(querySourceStation)) {
            throw new LocalizableRuntimeException("niagaraDriver", "niagaraSystemIndex.illegalImportAndExport");
        }
    }

    public Stream<Entity> postQueryFilter(Stream<Entity> queryResults, Context cx) {
        Stream<Entity> filteredResults = this.getAllowVirtuals() ? queryResults : queryResults.filter(e -> !(e instanceof BVirtualGateway) && !(e instanceof BVirtualComponent));
        Set<Id> filteredIds = NiagaraDriverUtil.parseIds(this.getTagsThatExcludeEntities());
        if (!filteredIds.isEmpty()) {
            filteredResults = filteredResults.filter(e -> !NiagaraDriverUtil.hasAnyMatchingTagId(e.tags(), filteredIds));
        }
        if (this.getTranslateOrds()) {
            if (this.getPersistCategoryMask()) {
                return filteredResults.map(e -> {
                    if (e instanceof BICategorizable) {
                        return new CategorizableTranslatedEntity((Entity)e, BNiagaraRemoteQueryFilter::translateOrd);
                    }
                    return new TranslatedEntity(e, BNiagaraRemoteQueryFilter::translateOrd);
                });
            }
            return filteredResults.map(e -> new TranslatedEntity(e, BNiagaraRemoteQueryFilter::translateOrd));
        }
        return filteredResults;
    }

    private static boolean hasEnabledEntityExportSource(NiagaraStation station) {
        if (station instanceof BComplex) {
            SlotCursor c = ((BComplex)station).getProperties();
            while (c.next(EntityExportSource.class)) {
                EntityExportSource source = (EntityExportSource)c.get();
                if (!source.isEntityExportEnabled()) continue;
                return true;
            }
        }
        return false;
    }

    private static BOrd translateOrd(BOrd ord, BObject base) {
        if (ord.isNull()) {
            return ord;
        }
        BOrd translatedOrd = BTranslateOrdPostQueryFilter.translateOrd((BOrd)ord, (BObject)base);
        OrdQuery[] queries = translatedOrd.parse();
        if (queries.length > 0) {
            String firstQueryScheme = queries[0].getScheme();
            if (BStationScheme.INSTANCE.getId().equals(firstQueryScheme)) {
                translatedOrd = BOrd.make((BOrd)NspaceBaseHolder.nspaceBase, (BOrd)BOrd.make((OrdQuery[])queries, (int)1, (int)queries.length));
            } else if (!BNSpaceScheme.INSTANCE.getId().equals(firstQueryScheme)) {
                translatedOrd = BOrd.make((BOrd)NspaceBaseHolder.nspaceBase, (BOrd)translatedOrd);
            }
        }
        return translatedOrd;
    }

    private static class CategorizableTranslatedEntity
    extends TranslatedEntity
    implements BICategorizable {
        private final BCategoryMask appliedCategoryMask;
        private final BCategoryMask categoryMask;

        public CategorizableTranslatedEntity(Entity categorizableEntity, BiFunction<BOrd, BObject, BOrd> ordTranslationFunction) {
            super(categorizableEntity, ordTranslationFunction);
            BICategorizable categorizable = (BICategorizable)categorizableEntity;
            this.categoryMask = categorizable.getCategoryMask();
            this.appliedCategoryMask = categorizable.getAppliedCategoryMask();
        }

        public BCategoryMask getAppliedCategoryMask() {
            return this.appliedCategoryMask;
        }

        public BCategoryMask getCategoryMask() {
            return this.categoryMask;
        }

        public <T extends BIObject> T as(Class<T> cls) {
            throw new UnsupportedOperationException("Only Entity and Category APIs are valid");
        }

        public BIDataValue toDataValue() {
            throw new UnsupportedOperationException("Only Entity and Category APIs are valid");
        }

        public String toString(Context context) {
            throw new UnsupportedOperationException("Only Entity and Category APIs are valid");
        }

        public boolean equivalent(Object obj) {
            throw new UnsupportedOperationException("Only Entity and Category APIs are valid");
        }

        public Type getType() {
            throw new UnsupportedOperationException("Only Entity and Category APIs are valid");
        }

        public BObject asObject() {
            throw new UnsupportedOperationException("Only Entity and Category APIs are valid");
        }
    }

    private static final class NspaceBaseHolder {
        public static final BOrd nspaceBase = BOrd.make((String)(BNSpaceScheme.INSTANCE.getId() + ':' + Sys.getStation().getStationName()));

        private NspaceBaseHolder() {
        }
    }
}

